/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.ajax.AjaxUtil;
import org.apache.wiki.ajax.WikiAjaxDispatcherServlet;
import org.apache.wiki.ajax.WikiAjaxServlet;
import org.apache.wiki.api.exceptions.FilterException;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.filters.BasicPageFilter;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventUtils;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.modules.InternalModule;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.search.BasicSearchProvider;
import org.apache.wiki.search.LuceneSearchProvider;
import org.apache.wiki.search.SearchProvider;
import org.apache.wiki.search.SearchResult;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;

public class SearchManager
extends BasicPageFilter
implements InternalModule,
WikiEventListener {
    private static final Logger log = Logger.getLogger(SearchManager.class);
    private static final String DEFAULT_SEARCHPROVIDER = "org.apache.wiki.search.LuceneSearchProvider";
    private static final String PROP_USE_LUCENE = "jspwiki.useLucene";
    public static final String PROP_SEARCHPROVIDER = "jspwiki.searchProvider";
    private SearchProvider m_searchProvider;
    public static final String JSON_SEARCH = "search";

    public SearchManager(WikiEngine engine, Properties properties) throws FilterException {
        this.initialize(engine, properties);
        WikiEventUtils.addWikiEventListener(this.m_engine.getPageManager(), 26, this);
        WikiAjaxDispatcherServlet.registerServlet(JSON_SEARCH, new JSONSearch());
    }

    @Override
    public void initialize(WikiEngine engine, Properties properties) throws FilterException {
        this.m_engine = engine;
        this.loadSearchProvider(properties);
        try {
            this.m_searchProvider.initialize(engine, properties);
        }
        catch (NoRequiredPropertyException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void loadSearchProvider(Properties properties) {
        String useLucene = properties.getProperty(PROP_USE_LUCENE);
        if (useLucene != null) {
            log.info((Object)"jspwiki.useLucene is deprecated; please use jspwiki.searchProvider=<your search provider> instead.");
            this.m_searchProvider = TextUtil.isPositive(useLucene) ? new LuceneSearchProvider() : new BasicSearchProvider();
            log.debug((Object)("useLucene was set, loading search provider " + this.m_searchProvider));
            return;
        }
        String providerClassName = properties.getProperty(PROP_SEARCHPROVIDER, DEFAULT_SEARCHPROVIDER);
        try {
            Class<?> providerClass = ClassUtil.findClass("org.apache.wiki.search", providerClassName);
            this.m_searchProvider = (SearchProvider)providerClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.warn((Object)"Failed loading SearchProvider, will use BasicSearchProvider.", (Throwable)e);
        }
        if (null == this.m_searchProvider) {
            this.m_searchProvider = new BasicSearchProvider();
        }
        log.debug((Object)("Loaded search provider " + this.m_searchProvider));
    }

    public SearchProvider getSearchEngine() {
        return this.m_searchProvider;
    }

    public Collection<SearchResult> findPages(String query, WikiContext wikiContext) throws ProviderException, IOException {
        if (query == null) {
            query = "";
        }
        return this.m_searchProvider.findPages(query, wikiContext);
    }

    public void pageRemoved(WikiPage page) {
        this.m_searchProvider.pageRemoved(page);
    }

    @Override
    public void postSave(WikiContext wikiContext, String content) {
        WikiPage p = this.m_engine.getPage(wikiContext.getPage().getName());
        this.reindexPage(p);
    }

    public void reindexPage(WikiPage page) {
        this.m_searchProvider.reindexPage(page);
    }

    @Override
    public void actionPerformed(WikiEvent event) {
        String pageName;
        WikiPage p;
        if (event instanceof WikiPageEvent && event.getType() == 26 && (p = this.m_engine.getPage(pageName = ((WikiPageEvent)event).getPageName())) != null) {
            this.pageRemoved(p);
        }
    }

    public class JSONSearch
    implements WikiAjaxServlet {
        public static final String AJAX_ACTION_SUGGESTIONS = "suggestions";
        public static final String AJAX_ACTION_PAGES = "pages";
        public static final int DEFAULT_MAX_RESULTS = 20;
        public int maxResults = 20;

        @Override
        public String getServletMapping() {
            return SearchManager.JSON_SEARCH;
        }

        @Override
        public void service(HttpServletRequest req, HttpServletResponse resp, String actionName, List<String> params) throws ServletException, IOException {
            String result = "";
            if (StringUtils.isNotBlank((String)actionName)) {
                List<Object> callResults;
                if (params.size() < 1) {
                    return;
                }
                String itemId = params.get(0);
                log.debug((Object)("itemId=" + itemId));
                if (params.size() > 1) {
                    String maxResultsParam = params.get(1);
                    log.debug((Object)("maxResultsParam=" + maxResultsParam));
                    if (StringUtils.isNotBlank((String)maxResultsParam) && StringUtils.isNumeric((String)maxResultsParam)) {
                        this.maxResults = Integer.parseInt(maxResultsParam);
                    }
                }
                if (actionName.equals(AJAX_ACTION_SUGGESTIONS)) {
                    callResults = new ArrayList();
                    log.debug((Object)"Calling getSuggestions() START");
                    callResults = this.getSuggestions(itemId, this.maxResults);
                    log.debug((Object)("Calling getSuggestions() DONE. " + callResults.size()));
                    result = AjaxUtil.toJson(callResults);
                } else if (actionName.equals(AJAX_ACTION_PAGES)) {
                    callResults = new ArrayList();
                    log.debug((Object)"Calling findPages() START");
                    WikiContext wikiContext = SearchManager.this.m_engine.createContext(req, WikiContext.VIEW);
                    if (wikiContext == null) {
                        throw new ServletException("Could not create a WikiContext from the request " + req);
                    }
                    callResults = this.findPages(itemId, this.maxResults, wikiContext);
                    log.debug((Object)("Calling findPages() DONE. " + callResults.size()));
                    result = AjaxUtil.toJson(callResults);
                }
            }
            log.debug((Object)("result=" + result));
            resp.getWriter().write(result);
        }

        public List<String> getSuggestions(String wikiName, int maxLength) {
            StopWatch sw = new StopWatch();
            sw.start();
            ArrayList<String> list = new ArrayList<String>(maxLength);
            if (wikiName.length() > 0) {
                String filename = "";
                int pos = wikiName.indexOf("/");
                if (pos >= 0) {
                    filename = wikiName.substring(pos).toLowerCase();
                    wikiName = wikiName.substring(0, pos);
                }
                String cleanWikiName = MarkupParser.cleanLink(wikiName).toLowerCase() + filename;
                String oldStyleName = MarkupParser.wikifyLink(wikiName).toLowerCase() + filename;
                Set<String> allPages = SearchManager.this.m_engine.getReferenceManager().findCreated();
                int counter = 0;
                Iterator<String> i = allPages.iterator();
                while (i.hasNext() && counter < maxLength) {
                    String p = i.next();
                    String pp = p.toLowerCase();
                    if (!pp.startsWith(cleanWikiName) && !pp.startsWith(oldStyleName)) continue;
                    list.add(p);
                    ++counter;
                }
            }
            sw.stop();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Suggestion request for " + wikiName + " done in " + sw));
            }
            return list;
        }

        public List<Map<String, Object>> findPages(String searchString, int maxLength, WikiContext wikiContext) {
            StopWatch sw = new StopWatch();
            sw.start();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(maxLength);
            if (searchString.length() > 0) {
                try {
                    Collection<SearchResult> c = SearchManager.this.m_searchProvider instanceof LuceneSearchProvider ? ((LuceneSearchProvider)SearchManager.this.m_searchProvider).findPages(searchString, 0, wikiContext) : SearchManager.this.m_searchProvider.findPages(searchString, wikiContext);
                    Iterator<SearchResult> i = c.iterator();
                    for (int count = 0; i.hasNext() && count < maxLength; ++count) {
                        SearchResult sr = i.next();
                        HashMap<String, Object> hm = new HashMap<String, Object>();
                        hm.put("page", sr.getPage().getName());
                        hm.put("score", sr.getScore());
                        list.add(hm);
                    }
                }
                catch (Exception e) {
                    log.info((Object)"AJAX search failed; ", (Throwable)e);
                }
            }
            sw.stop();
            if (log.isDebugEnabled()) {
                log.debug((Object)("AJAX search complete in " + sw));
            }
            return list;
        }
    }
}

