/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.tags.WikiTagBase;

public class BreadcrumbsTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static final Logger log = Logger.getLogger(BreadcrumbsTag.class);
    public static final String BREADCRUMBTRAIL_KEY = "breadCrumbTrail";
    private int m_maxQueueSize = 11;
    private String m_separator = ", ";

    @Override
    public void initTag() {
        super.initTag();
        this.m_maxQueueSize = 11;
        this.m_separator = ", ";
    }

    public int getMaxpages() {
        return this.m_maxQueueSize;
    }

    public void setMaxpages(int maxpages) {
        this.m_maxQueueSize = maxpages + 1;
    }

    public String getSeparator() {
        return this.m_separator;
    }

    public void setSeparator(String separator) {
        this.m_separator = separator;
    }

    @Override
    public int doWikiStartTag() throws IOException {
        HttpSession session = this.pageContext.getSession();
        FixedQueue trail = (FixedQueue)session.getAttribute(BREADCRUMBTRAIL_KEY);
        String page = this.m_wikiContext.getPage().getName();
        if (trail == null) {
            trail = new FixedQueue(this.m_maxQueueSize);
        } else {
            for (int i = 0; i < trail.size(); ++i) {
                if (this.m_wikiContext.getEngine().pageExists((String)trail.get(i))) continue;
                trail.remove(i);
            }
        }
        if (this.m_wikiContext.getRequestContext().equals(WikiContext.VIEW)) {
            if (this.m_wikiContext.getEngine().pageExists(page)) {
                if (trail.isEmpty()) {
                    trail.pushItem(page);
                } else if (!((String)trail.getLast()).equals(page)) {
                    trail.pushItem(page);
                }
            } else {
                log.debug((Object)("didn't add page because it doesn't exist: " + page));
            }
        }
        session.setAttribute(BREADCRUMBTRAIL_KEY, (Object)trail);
        JspWriter out = this.pageContext.getOut();
        int queueSize = trail.size();
        String linkclass = "wikipage";
        String curPage = null;
        for (int i = 0; i < queueSize - 1; ++i) {
            curPage = (String)trail.get(i);
            out.print("<a class=\"" + linkclass + "\" href=\"" + this.m_wikiContext.getViewURL(curPage) + "\">" + curPage + "</a>");
            if (i >= queueSize - 2) continue;
            out.print(this.m_separator);
        }
        return 0;
    }

    public static class FixedQueue
    extends LinkedList<String>
    implements Serializable {
        private int m_size;
        private static final long serialVersionUID = 0L;

        FixedQueue(int size) {
            this.m_size = size;
        }

        String pushItem(String o) {
            this.add(o);
            if (this.size() > this.m_size) {
                return (String)this.removeFirst();
            }
            return null;
        }

        public void removeItem(String pageName) {
            for (int i = 0; i < this.size(); ++i) {
                String page = (String)this.get(i);
                if (page == null || !page.equals(pageName)) continue;
                this.remove(page);
            }
        }
    }
}

