/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.util.TextUtil;

public class CalendarTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static final Logger log = Logger.getLogger(CalendarTag.class);
    private SimpleDateFormat m_pageFormat = null;
    private SimpleDateFormat m_urlFormat = null;
    private SimpleDateFormat m_monthUrlFormat = null;
    private SimpleDateFormat m_dateFormat = new SimpleDateFormat("ddMMyy");

    @Override
    public void initTag() {
        super.initTag();
        this.m_monthUrlFormat = null;
        this.m_urlFormat = null;
        this.m_pageFormat = null;
        this.m_dateFormat = new SimpleDateFormat("ddMMyy");
    }

    public void setPageformat(String format) {
        this.m_pageFormat = new SimpleDateFormat(format);
    }

    public void setUrlformat(String format) {
        this.m_urlFormat = new SimpleDateFormat(format);
    }

    public void setMonthurlformat(String format) {
        this.m_monthUrlFormat = new SimpleDateFormat(format);
    }

    private String format(String txt) {
        WikiPage p = this.m_wikiContext.getPage();
        if (p != null) {
            return TextUtil.replaceString(txt, "%p", p.getName());
        }
        return txt;
    }

    private String getDayLink(Calendar day) {
        WikiEngine engine = this.m_wikiContext.getEngine();
        String result = "";
        if (this.m_pageFormat != null) {
            String pagename = this.m_pageFormat.format(day.getTime());
            if (engine.pageExists(pagename)) {
                if (this.m_urlFormat != null) {
                    String url = this.m_urlFormat.format(day.getTime());
                    result = "<td class=\"link\"><a href=\"" + url + "\">" + day.get(5) + "</a></td>";
                } else {
                    result = "<td class=\"link\"><a href=\"" + this.m_wikiContext.getViewURL(pagename) + "\">" + day.get(5) + "</a></td>";
                }
            } else {
                result = "<td class=\"days\">" + day.get(5) + "</td>";
            }
        } else if (this.m_urlFormat != null) {
            String url = this.m_urlFormat.format(day.getTime());
            result = "<td><a href=\"" + url + "\">" + day.get(5) + "</a></td>";
        } else {
            result = "<td class=\"days\">" + day.get(5) + "</td>";
        }
        return this.format(result);
    }

    private String getMonthLink(Calendar day) {
        String result;
        SimpleDateFormat monthfmt = new SimpleDateFormat("MMMM yyyy");
        if (this.m_monthUrlFormat == null) {
            result = monthfmt.format(day.getTime());
        } else {
            Calendar cal = (Calendar)day.clone();
            int firstDay = cal.getActualMinimum(5);
            int lastDay = cal.getActualMaximum(5);
            cal.set(5, lastDay);
            String url = this.m_monthUrlFormat.format(cal.getTime());
            url = TextUtil.replaceString(url, "%d", Integer.toString(lastDay - firstDay + 1));
            result = "<a href=\"" + url + "\">" + monthfmt.format(cal.getTime()) + "</a>";
        }
        return this.format(result);
    }

    private String getMonthNaviLink(Calendar day, String txt, String queryString) {
        String result = "";
        queryString = TextUtil.replaceEntities(queryString);
        Calendar nextMonth = Calendar.getInstance();
        nextMonth.set(5, 1);
        nextMonth.add(5, -1);
        nextMonth.add(2, 1);
        if (day.before(nextMonth)) {
            WikiPage thePage = this.m_wikiContext.getPage();
            String pageName = thePage.getName();
            String calendarDate = this.m_dateFormat.format(day.getTime());
            String url = this.m_wikiContext.getURL(WikiContext.VIEW, pageName, "calendar.date=" + calendarDate);
            if (queryString != null && queryString.length() > 0) {
                int pos1 = queryString.indexOf("calendar.date=");
                if (pos1 >= 0) {
                    String tmp = queryString.substring(0, pos1);
                    int pos2 = queryString.indexOf("&", pos1) + 1;
                    if (pos2 > 0 && pos2 < queryString.length()) {
                        tmp = tmp + queryString.substring(pos2);
                    }
                    queryString = tmp;
                }
                if (queryString != null && queryString.length() > 0) {
                    url = url + "&amp;" + queryString;
                }
            }
            result = "<td><a href=\"" + url + "\">" + txt + "</a></td>";
        } else {
            result = "<td> </td>";
        }
        return this.format(result);
    }

    @Override
    public final int doWikiStartTag() throws IOException, ProviderException {
        WikiEngine engine = this.m_wikiContext.getEngine();
        JspWriter out = this.pageContext.getOut();
        Calendar cal = Calendar.getInstance();
        Calendar prevCal = Calendar.getInstance();
        Calendar nextCal = Calendar.getInstance();
        String calendarDate = this.pageContext.getRequest().getParameter("calendar.date");
        if (calendarDate == null) {
            calendarDate = this.pageContext.getRequest().getParameter("weblog.startDate");
        }
        if (calendarDate != null) {
            try {
                Date d = this.m_dateFormat.parse(calendarDate);
                cal.setTime(d);
                prevCal.setTime(d);
                nextCal.setTime(d);
            }
            catch (ParseException e) {
                log.warn((Object)("date format wrong: " + calendarDate));
            }
        }
        cal.set(5, 1);
        prevCal.set(5, 1);
        nextCal.set(5, 1);
        prevCal.add(2, -1);
        nextCal.add(2, 1);
        out.write("<table class=\"calendar\">\n");
        HttpServletRequest httpServletRequest = this.m_wikiContext.getHttpRequest();
        String queryString = engine.safeGetQueryString(httpServletRequest);
        out.write("<tr>" + this.getMonthNaviLink(prevCal, "&lt;&lt;", queryString) + "<td colspan=5 class=\"month\">" + this.getMonthLink(cal) + "</td>" + this.getMonthNaviLink(nextCal, "&gt;&gt;", queryString) + "</tr>\n");
        int month = cal.get(2);
        cal.set(7, 2);
        out.write("<tr><td class=\"weekdays\">Mon</td><td class=\"weekdays\">Tue</td><td class=\"weekdays\">Wed</td><td class=\"weekdays\">Thu</td><td class=\"weekdays\">Fri</td><td class=\"weekdays\">Sat</td><td class=\"weekdays\">Sun</td></tr>\n");
        boolean noMoreDates = false;
        while (!noMoreDates) {
            out.write("<tr>");
            for (int i = 0; i < 7; ++i) {
                int mth = cal.get(2);
                if (mth != month) {
                    out.write("<td class=\"othermonth\">" + cal.get(5) + "</td>");
                } else {
                    out.write(this.getDayLink(cal));
                }
                cal.add(5, 1);
            }
            if (cal.get(2) != month) {
                noMoreDates = true;
            }
            out.write("</tr>\n");
        }
        out.write("</table>\n");
        return 1;
    }
}

