/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import org.apache.wiki.WikiSession;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.tags.WikiTagBase;

public class UserCheckTag
extends WikiTagBase {
    private static final long serialVersionUID = 3256438110127863858L;
    private static final String ASSERTED = "asserted";
    private static final String AUTHENTICATED = "authenticated";
    private static final String ANONYMOUS = "anonymous";
    private static final String ASSERTIONS_ALLOWED = "assertionsallowed";
    private static final String ASSERTIONS_NOT_ALLOWED = "assertionsnotallowed";
    private static final String CONTAINER_AUTH = "containerauth";
    private static final String CUSTOM_AUTH = "customauth";
    private static final String KNOWN = "known";
    private static final String NOT_AUTHENTICATED = "notauthenticated";
    private String m_status;

    @Override
    public void initTag() {
        super.initTag();
        this.m_status = null;
    }

    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status.toLowerCase();
    }

    public void setExists(String arg) {
        this.m_status = "true".equals(arg) ? AUTHENTICATED : ANONYMOUS;
    }

    @Override
    public final int doWikiStartTag() throws IOException {
        WikiSession session = this.m_wikiContext.getWikiSession();
        String status = session.getStatus();
        AuthenticationManager mgr = this.m_wikiContext.getEngine().getAuthenticationManager();
        boolean containerAuth = mgr.isContainerAuthenticated();
        boolean cookieAssertions = mgr.allowsCookieAssertions();
        if (this.m_status != null) {
            if (ANONYMOUS.equals(this.m_status)) {
                if (status.equals(ANONYMOUS)) {
                    return 1;
                }
            } else if (AUTHENTICATED.equals(this.m_status)) {
                if (status.equals(AUTHENTICATED)) {
                    return 1;
                }
            } else if (ASSERTED.equals(this.m_status)) {
                if (status.equals(ASSERTED)) {
                    return 1;
                }
            } else {
                if (ASSERTIONS_ALLOWED.equals(this.m_status)) {
                    if (cookieAssertions) {
                        return 1;
                    }
                    return 0;
                }
                if (ASSERTIONS_NOT_ALLOWED.equals(this.m_status)) {
                    if (!cookieAssertions) {
                        return 1;
                    }
                    return 0;
                }
                if (CONTAINER_AUTH.equals(this.m_status)) {
                    if (containerAuth) {
                        return 1;
                    }
                    return 0;
                }
                if (CUSTOM_AUTH.equals(this.m_status)) {
                    if (!containerAuth) {
                        return 1;
                    }
                    return 0;
                }
                if (KNOWN.equals(this.m_status)) {
                    if (!session.isAnonymous()) {
                        return 1;
                    }
                    return 0;
                }
                if (NOT_AUTHENTICATED.equals(this.m_status) && !status.equals(AUTHENTICATED)) {
                    return 1;
                }
            }
        }
        return 0;
    }
}

