/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.security.Principal;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.util.TextUtil;

public class UserNameTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static String notStartWithBlankOrColon = "^[^( |:)]";
    private static String noColons = "[^:]*";
    private static final Pattern VALID_USER_NAME_PATTERN = Pattern.compile(notStartWithBlankOrColon + noColons);

    @Override
    public final int doWikiStartTag() throws IOException {
        WikiEngine engine = this.m_wikiContext.getEngine();
        WikiSession wikiSession = WikiSession.getWikiSession(engine, (HttpServletRequest)this.pageContext.getRequest());
        Principal user = wikiSession.getUserPrincipal();
        if (user != null) {
            if (VALID_USER_NAME_PATTERN.matcher(user.getName()).matches()) {
                this.pageContext.getOut().print(TextUtil.replaceEntities(user.getName()));
            } else {
                this.pageContext.getOut().print(Preferences.getBundle(this.m_wikiContext, "CoreResources").getString("security.user.fullname.invalid"));
            }
        }
        return 0;
    }
}

