/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.jsp.PageContext;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.exceptions.NoSuchVariableException;
import org.apache.wiki.modules.ModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.XmlUtil;
import org.jdom2.Element;

public class EditorManager
extends ModuleManager {
    public static final String PROP_EDITORTYPE = "jspwiki.editor";
    public static final String PARA_EDITOR = "editor";
    public static final String EDITOR_PLAIN = "plain";
    public static final String EDITOR_PREVIEW = "preview";
    public static final String REQ_EDITEDTEXT = "_editedtext";
    public static final String ATTR_EDITEDTEXT = "_editedtext";
    private Map<String, WikiEditorInfo> m_editors;
    private static Logger log = Logger.getLogger(EditorManager.class);

    public EditorManager(WikiEngine engine) {
        super(engine);
    }

    public void initialize(Properties props) {
        this.registerEditors();
    }

    private void registerEditors() {
        log.info((Object)"Registering editor modules");
        this.m_editors = new HashMap<String, WikiEditorInfo>();
        List<Element> editors = XmlUtil.parse("ini/jspwiki_module.xml", "/modules/editor");
        for (Element pluginEl : editors) {
            String name = pluginEl.getAttributeValue("name");
            WikiEditorInfo info = WikiEditorInfo.newInstance(name, pluginEl);
            if (this.checkCompatibility(info)) {
                this.m_editors.put(name, info);
                log.debug((Object)("Registered editor " + name));
                continue;
            }
            log.info((Object)("Editor '" + name + "' not compatible with this version of JSPWiki."));
        }
    }

    public String getEditorName(WikiContext context) {
        if (context.getRequestContext().equals(WikiContext.PREVIEW)) {
            return EDITOR_PREVIEW;
        }
        String editor = null;
        editor = Preferences.getPreference(context, PARA_EDITOR);
        if (editor == null) {
            try {
                editor = this.m_engine.getVariableManager().getValue(context, PROP_EDITORTYPE);
            }
            catch (NoSuchVariableException noSuchVariableException) {
                // empty catch block
            }
        }
        if (editor != null) {
            String[] editorlist = this.getEditorList();
            editor = editor.trim();
            for (int i = 0; i < editorlist.length; ++i) {
                if (!editorlist[i].equalsIgnoreCase(editor)) continue;
                return editorlist[i];
            }
        }
        return EDITOR_PLAIN;
    }

    public String[] getEditorList() {
        String[] editors = new String[this.m_editors.size()];
        Set<String> keys = this.m_editors.keySet();
        return keys.toArray(editors);
    }

    public String getEditorPath(WikiContext context) {
        String path = null;
        String editor = this.getEditorName(context);
        WikiEditorInfo ed = this.m_editors.get(editor);
        path = ed != null ? ed.getPath() : "editors/" + editor + ".jsp";
        return path;
    }

    public static String getEditedText(PageContext ctx) {
        String usertext = ctx.getRequest().getParameter("_editedtext");
        if (usertext == null) {
            usertext = (String)ctx.findAttribute("_editedtext");
        }
        return usertext;
    }

    @Override
    public Collection<WikiModuleInfo> modules() {
        return this.modules(this.m_editors.values().iterator());
    }

    @Override
    public WikiEditorInfo getModuleInfo(String moduleName) {
        return this.m_editors.get(moduleName);
    }

    private static final class WikiEditorInfo
    extends WikiModuleInfo {
        private String m_path;

        protected static WikiEditorInfo newInstance(String name, Element el) {
            if (name == null || name.length() == 0) {
                return null;
            }
            WikiEditorInfo info = new WikiEditorInfo(name);
            info.initializeFromXML(el);
            return info;
        }

        @Override
        protected void initializeFromXML(Element el) {
            super.initializeFromXML(el);
            this.m_path = el.getChildText("path");
        }

        private WikiEditorInfo(String name) {
            super(name);
        }

        public String getPath() {
            return this.m_path;
        }
    }
}

