/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.security.Permission;
import org.apache.wiki.WikiPage;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.ui.AbstractCommand;
import org.apache.wiki.ui.Command;

public final class PageCommand
extends AbstractCommand {
    public static final Command ATTACH = new PageCommand("att", "%uattach/%n", null, null, "upload");
    public static final Command COMMENT = new PageCommand("comment", "%uComment.jsp?page=%n", "CommentContent.jsp", null, "comment");
    public static final Command CONFLICT = new PageCommand("conflict", "%uPageModified.jsp?page=%n", "ConflictContent.jsp", null, "view");
    public static final Command DELETE = new PageCommand("del", "%uDelete.jsp?page=%n", null, null, "delete");
    public static final Command DIFF = new PageCommand("diff", "%uDiff.jsp?page=%n", "DiffContent.jsp", null, "view");
    public static final Command EDIT = new PageCommand("edit", "%uEdit.jsp?page=%n", "EditContent.jsp", null, "edit");
    public static final Command INFO = new PageCommand("info", "%uPageInfo.jsp?page=%n", "InfoContent.jsp", null, "view");
    public static final Command PREVIEW = new PageCommand("preview", "%uPreview.jsp?page=%n", "PreviewContent.jsp", null, "view");
    public static final Command RENAME = new PageCommand("rename", "%uRename.jsp?page=%n", "InfoContent.jsp", null, "rename");
    public static final Command RSS = new PageCommand("rss", "%urss.jsp", null, null, "view");
    public static final Command UPLOAD = new PageCommand("upload", "%uUpload.jsp?page=%n", null, null, "upload");
    public static final Command VIEW = new PageCommand("view", "%uWiki.jsp?page=%n", "PageContent.jsp", null, "view");
    public static final Command NONE;
    public static final Command OTHER;
    private final String m_action;
    private final Permission m_permission;

    private PageCommand(String requestContext, String urlPattern, String contentTemplate, WikiPage target, String action) {
        super(requestContext, urlPattern, contentTemplate, target);
        this.m_action = action;
        this.m_permission = target == null || this.m_action == null ? null : PermissionFactory.getPagePermission(target, action);
    }

    @Override
    public Command targetedCommand(Object target) {
        if (target == null || !(target instanceof WikiPage)) {
            throw new IllegalArgumentException("Target must non-null and of type WikiPage.");
        }
        return new PageCommand(this.getRequestContext(), this.getURLPattern(), this.getContentTemplate(), (WikiPage)target, this.m_action);
    }

    @Override
    public String getName() {
        Object target = this.getTarget();
        if (target == null) {
            return this.getJSPFriendlyName();
        }
        return ((WikiPage)target).getName();
    }

    @Override
    public Permission requiredPermission() {
        return this.m_permission;
    }

    static {
        OTHER = NONE = new PageCommand("", "%u%n", null, null, null);
    }
}

