/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.url;

import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.url.DefaultURLConstructor;
import org.apache.wiki.util.TextUtil;

public class ShortURLConstructor
extends DefaultURLConstructor {
    private static final String DEFAULT_PREFIX = "wiki/";
    static Logger log = Logger.getLogger(ShortURLConstructor.class);
    protected String m_urlPrefix = "";
    public static final String PROP_PREFIX = "jspwiki.shortURLConstructor.prefix";

    @Override
    public void initialize(WikiEngine engine, Properties properties) {
        super.initialize(engine, properties);
        this.m_urlPrefix = TextUtil.getStringProperty(properties, PROP_PREFIX, null);
        if (this.m_urlPrefix == null) {
            this.m_urlPrefix = DEFAULT_PREFIX;
        }
        log.info((Object)("Short URL prefix path=" + this.m_urlPrefix + " (You can use " + PROP_PREFIX + " to override this)"));
    }

    private String makeURL(String context, String name, boolean absolute) {
        String viewurl = "%p" + this.m_urlPrefix + "%n";
        if (absolute) {
            viewurl = "%u" + this.m_urlPrefix + "%n";
        }
        if (context.equals(WikiContext.VIEW)) {
            if (name == null) {
                return this.doReplacement("%u", "", absolute);
            }
            return this.doReplacement(viewurl, name, absolute);
        }
        if (context.equals(WikiContext.PREVIEW)) {
            if (name == null) {
                return this.doReplacement("%u", "", absolute);
            }
            return this.doReplacement(viewurl + "?do=Preview", name, absolute);
        }
        if (context.equals(WikiContext.EDIT)) {
            return this.doReplacement(viewurl + "?do=Edit", name, absolute);
        }
        if (context.equals(WikiContext.ATTACH)) {
            return this.doReplacement("%uattach/%n", name, absolute);
        }
        if (context.equals(WikiContext.INFO)) {
            return this.doReplacement(viewurl + "?do=PageInfo", name, absolute);
        }
        if (context.equals(WikiContext.DIFF)) {
            return this.doReplacement(viewurl + "?do=Diff", name, absolute);
        }
        if (context.equals(WikiContext.NONE)) {
            return this.doReplacement("%u%n", name, absolute);
        }
        if (context.equals(WikiContext.UPLOAD)) {
            return this.doReplacement(viewurl + "?do=Upload", name, absolute);
        }
        if (context.equals(WikiContext.COMMENT)) {
            return this.doReplacement(viewurl + "?do=Comment", name, absolute);
        }
        if (context.equals(WikiContext.LOGIN)) {
            String loginUrl = absolute ? "%uLogin.jsp?redirect=%n" : "%pLogin.jsp?redirect=%n";
            return this.doReplacement(loginUrl, name, absolute);
        }
        if (context.equals(WikiContext.DELETE)) {
            return this.doReplacement(viewurl + "?do=Delete", name, absolute);
        }
        if (context.equals(WikiContext.CONFLICT)) {
            return this.doReplacement(viewurl + "?do=PageModified", name, absolute);
        }
        if (context.equals(WikiContext.PREFS)) {
            return this.doReplacement(viewurl + "?do=UserPreferences", name, absolute);
        }
        if (context.equals(WikiContext.FIND)) {
            return this.doReplacement(viewurl + "?do=Search", name, absolute);
        }
        if (context.equals(WikiContext.ERROR)) {
            return this.doReplacement("%uError.jsp", name, absolute);
        }
        if (context.equals(WikiContext.CREATE_GROUP)) {
            return this.doReplacement(viewurl + "?do=NewGroup", name, absolute);
        }
        if (context.equals(WikiContext.DELETE_GROUP)) {
            return this.doReplacement(viewurl + "?do=DeleteGroup", name, absolute);
        }
        if (context.equals(WikiContext.EDIT_GROUP)) {
            return this.doReplacement(viewurl + "?do=EditGroup", name, absolute);
        }
        if (context.equals(WikiContext.VIEW_GROUP)) {
            return this.doReplacement(viewurl + "?do=Group&group=%n", name, absolute);
        }
        throw new InternalWikiException("Requested unsupported context " + context);
    }

    @Override
    public String makeURL(String context, String name, boolean absolute, String parameters) {
        parameters = parameters != null && parameters.length() > 0 ? (context.equals(WikiContext.ATTACH) || context.equals(WikiContext.VIEW) ? "?" + parameters : (context.equals(WikiContext.NONE) ? (name.indexOf(63) != -1 ? "&amp;" : "?" + parameters) : "&amp;" + parameters)) : "";
        return this.makeURL(context, name, absolute) + parameters;
    }

    @Override
    public String parsePage(String context, HttpServletRequest request, String encoding) throws UnsupportedEncodingException {
        String pagereq = request.getParameter("page");
        if (pagereq == null) {
            pagereq = ShortURLConstructor.parsePageFromURL(request, encoding);
        }
        return pagereq;
    }

    @Override
    public String getForwardPage(HttpServletRequest req) {
        String jspPage = req.getParameter("do");
        if (jspPage == null) {
            jspPage = "Wiki";
        }
        return jspPage + ".jsp";
    }
}

