/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class HttpUtil {
    static Logger log = Logger.getLogger(HttpUtil.class);

    private HttpUtil() {
    }

    public static String getRemoteAddress(HttpServletRequest req) {
        return StringUtils.isNotEmpty((String)req.getHeader("X-Forwarded-For")) ? req.getHeader("X-Forwarded-For") : req.getRemoteAddr();
    }

    public static String retrieveCookieValue(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(cookieName)) continue;
                String value = cookies[i].getValue();
                if (value.length() == 0) {
                    return null;
                }
                if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                    value = value.substring(1, value.length() - 1);
                }
                return value;
            }
        }
        return null;
    }

    public static String createETag(String pageName, Date lastModified) {
        return Long.toString((long)pageName.hashCode() ^ lastModified.getTime());
    }

    public static boolean checkFor304(HttpServletRequest req, String pageName, Date lastModified) {
        block9: {
            if (!"no-cache".equalsIgnoreCase(req.getHeader("Pragma")) && !"no-cache".equalsIgnoreCase(req.getHeader("cache-control"))) {
                String thisTag = HttpUtil.createETag(pageName, lastModified);
                String eTag = req.getHeader("If-None-Match");
                if (eTag != null && eTag.equals(thisTag)) {
                    return true;
                }
                SimpleDateFormat rfcDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
                try {
                    long ifModifiedSince = req.getDateHeader("If-Modified-Since");
                    if (ifModifiedSince != -1L) {
                        long lastModifiedTime = lastModified.getTime();
                        if (lastModifiedTime <= ifModifiedSince) {
                            return true;
                        }
                        break block9;
                    }
                    try {
                        Date ifModifiedSinceDate;
                        String s = req.getHeader("If-Modified-Since");
                        if (s != null && lastModified.before(ifModifiedSinceDate = rfcDateFormat.parse(s))) {
                            return true;
                        }
                    }
                    catch (ParseException e) {
                        log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static String guessValidURI(String uri) {
        if (uri.indexOf(64) != -1) {
            if (!uri.startsWith("mailto:")) {
                uri = "mailto:" + uri;
            }
        } else if (HttpUtil.notBeginningWithHttpOrHttps(uri)) {
            uri = "http://" + uri;
        }
        return uri;
    }

    static boolean notBeginningWithHttpOrHttps(String uri) {
        return uri.length() > 0 && !uri.startsWith("http://") && !uri.startsWith("https://");
    }
}

