/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.apache.wiki.util.TextUtil;

public final class PropertyReader {
    private static final Logger LOG = Logger.getLogger(PropertyReader.class);
    public static final String DEFAULT_JSPWIKI_CONFIG = "/ini/jspwiki.properties";
    public static final String PARAM_CUSTOMCONFIG = "jspwiki.custom.config";
    public static final String PARAM_CUSTOMCONFIG_CASCADEPREFIX = "jspwiki.custom.cascade.";
    public static final String CUSTOM_JSPWIKI_CONFIG = "/jspwiki-custom.properties";
    private static final String PARAM_VAR_DECLARATION = "var.";
    private static final String PARAM_VAR_IDENTIFIER = "$";

    private PropertyReader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadWebAppProps(ServletContext context) {
        String propertyFile = PropertyReader.getInitParameter(context, PARAM_CUSTOMCONFIG);
        try (InputStream propertyStream = PropertyReader.loadCustomPropertiesFile(context, propertyFile);){
            Properties props = PropertyReader.getDefaultProperties();
            if (propertyStream == null) {
                LOG.info((Object)"No custom property file found, relying on JSPWiki defaults.");
            } else {
                props.load(propertyStream);
            }
            LOG.debug((Object)"Loading cascading properties...");
            PropertyReader.loadWebAppPropsCascade(context, props);
            PropertyReader.expandVars(props);
            Properties properties = props;
            return properties;
        }
        catch (Exception e) {
            LOG.error((Object)("JSPWiki: Unable to load and setup properties from jspwiki.properties. " + e.getMessage()));
            return null;
        }
    }

    static InputStream loadCustomPropertiesFile(ServletContext context, String propertyFile) throws FileNotFoundException {
        InputStream propertyStream;
        if (propertyFile == null) {
            LOG.info((Object)"No jspwiki.custom.config defined for this context, looking for custom properties file with default name of: /jspwiki-custom.properties");
            propertyStream = PropertyReader.locateClassPathResource(context, CUSTOM_JSPWIKI_CONFIG);
        } else {
            LOG.info((Object)("jspwiki.custom.config defined, using " + propertyFile + " as the custom properties file."));
            propertyStream = new FileInputStream(new File(propertyFile));
        }
        return propertyStream;
    }

    public static Properties getDefaultProperties() {
        Properties props = new Properties();
        InputStream in = PropertyReader.class.getResourceAsStream(DEFAULT_JSPWIKI_CONFIG);
        if (in != null) {
            try {
                props.load(in);
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to load default propertyfile '/ini/jspwiki.properties'" + e.getMessage()), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getCombinedProperties(String fileName) {
        Properties newPropertySet = PropertyReader.getDefaultProperties();
        InputStream in = PropertyReader.class.getResourceAsStream(fileName);
        if (in != null) {
            try {
                newPropertySet.load(in);
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to load propertyfile '" + fileName + "'" + e.getMessage()), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        } else {
            LOG.error((Object)("*** Custom property file \"" + fileName + "\" not found, relying on default file alone."));
        }
        return newPropertySet;
    }

    private static String getInitParameter(ServletContext context, String name) {
        String value = context.getInitParameter(name);
        return value != null ? value : System.getProperty(name);
    }

    private static void loadWebAppPropsCascade(ServletContext context, Properties defaultProperties) {
        if (PropertyReader.getInitParameter(context, "jspwiki.custom.cascade.1") == null) {
            LOG.debug((Object)" No cascading properties defined for this context");
            return;
        }
        int depth = 0;
        boolean more = true;
        while (more) {
            String propertyFile = PropertyReader.getInitParameter(context, PARAM_CUSTOMCONFIG_CASCADEPREFIX + ++depth);
            if (propertyFile == null) {
                more = false;
                break;
            }
            try {
                FileInputStream propertyStream = new FileInputStream(new File(propertyFile));
                Throwable throwable = null;
                try {
                    LOG.info((Object)(" Reading additional properties from " + propertyFile + " and merge to cascade."));
                    Properties additionalProps = new Properties();
                    additionalProps.load(propertyStream);
                    defaultProperties.putAll((Map<?, ?>)additionalProps);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (propertyStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)propertyStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)propertyStream).close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("JSPWiki: Unable to load and setup properties from " + propertyFile + "." + e.getMessage()));
            }
        }
    }

    public static void expandVars(Properties properties) {
        String propertyValue;
        String propertyName;
        HashMap<String, String> vars = new HashMap<String, String>();
        Enumeration<?> propertyList = properties.propertyNames();
        while (propertyList.hasMoreElements()) {
            propertyName = (String)propertyList.nextElement();
            propertyValue = properties.getProperty(propertyName);
            if (!propertyName.startsWith(PARAM_VAR_DECLARATION)) continue;
            String varName = propertyName.substring(4, propertyName.length()).trim();
            String varValue = propertyValue.trim();
            vars.put(varName, varValue);
        }
        propertyList = properties.propertyNames();
        while (propertyList.hasMoreElements()) {
            propertyName = (String)propertyList.nextElement();
            propertyValue = properties.getProperty(propertyName);
            if (propertyName.startsWith(PARAM_VAR_DECLARATION)) continue;
            for (Map.Entry entry : vars.entrySet()) {
                String varName = (String)entry.getKey();
                String varValue = (String)entry.getValue();
                propertyValue = TextUtil.replaceString(propertyValue, PARAM_VAR_IDENTIFIER + varName, varValue);
                properties.put(propertyName, propertyValue);
            }
        }
    }

    public static InputStream locateClassPathResource(ServletContext context, String resourceName) {
        if (StringUtils.isEmpty((String)resourceName)) {
            return null;
        }
        String currResourceLocation = PropertyReader.createResourceLocation("/WEB-INF/classes", resourceName);
        InputStream result = context.getResourceAsStream(currResourceLocation);
        if (result != null) {
            LOG.debug((Object)(" Successfully located the following classpath resource : " + currResourceLocation));
            return result;
        }
        currResourceLocation = PropertyReader.createResourceLocation("", resourceName);
        result = PropertyReader.class.getResourceAsStream(currResourceLocation);
        if (result != null) {
            LOG.debug((Object)(" Successfully located the following classpath resource : " + currResourceLocation));
            return result;
        }
        LOG.debug((Object)(" Unable to resolve the following classpath resource : " + resourceName));
        return result;
    }

    static String createResourceLocation(String path, String name) {
        String sanitizedName;
        Validate.notEmpty((String)name, (String)"name is empty");
        StringBuilder result = new StringBuilder();
        String sanitizedPath = path != null && !path.isEmpty() && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        String string = sanitizedName = name.startsWith("/") ? name.substring(1, name.length()) : name;
        if (sanitizedPath == null || sanitizedPath.isEmpty()) {
            result.append("/");
        } else {
            if (!sanitizedPath.startsWith("/")) {
                result.append("/");
            }
            result.append(sanitizedPath);
            result.append("/");
        }
        result.append(sanitizedName);
        return result.toString();
    }
}

