/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

public final class TextUtil {
    static final String HEX_DIGITS = "0123456789ABCDEF";
    private static final int EOI = 0;
    private static final int LOWER = 1;
    private static final int UPPER = 2;
    private static final int DIGIT = 3;
    private static final int OTHER = 4;
    private static final Random RANDOM = new SecureRandom();
    public static final int PASSWORD_LENGTH = 8;

    private TextUtil() {
    }

    protected static String urlEncode(byte[] rs) {
        StringBuilder result = new StringBuilder(rs.length * 2);
        block4: for (int i = 0; i < rs.length; ++i) {
            char c = (char)rs[i];
            switch (c) {
                case '*': 
                case '-': 
                case '.': 
                case '/': 
                case '_': {
                    result.append(c);
                    continue block4;
                }
                case ' ': {
                    result.append('+');
                    continue block4;
                }
                default: {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                        result.append(c);
                        continue block4;
                    }
                    result.append('%');
                    result.append(HEX_DIGITS.charAt((c & 0xF0) >> 4));
                    result.append(HEX_DIGITS.charAt(c & 0xF));
                }
            }
        }
        return result.toString();
    }

    protected static String urlDecode(byte[] bytes, String encoding) throws IllegalArgumentException {
        if (bytes == null) {
            return null;
        }
        byte[] decodeBytes = new byte[bytes.length];
        int decodedByteCount = 0;
        try {
            block6: for (int count = 0; count < bytes.length; ++count) {
                switch (bytes[count]) {
                    case 43: {
                        decodeBytes[decodedByteCount++] = 32;
                        continue block6;
                    }
                    case 37: {
                        decodeBytes[decodedByteCount++] = (byte)((HEX_DIGITS.indexOf(bytes[++count]) << 4) + HEX_DIGITS.indexOf(bytes[++count]));
                        continue block6;
                    }
                    default: {
                        decodeBytes[decodedByteCount++] = bytes[count];
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException ae) {
            throw new IllegalArgumentException("Malformed UTF-8 string?");
        }
        return new String(decodeBytes, 0, decodedByteCount, Charset.forName(encoding));
    }

    public static String urlEncodeUTF8(String text) {
        if (text == null) {
            return "";
        }
        byte[] rs = text.getBytes(StandardCharsets.UTF_8);
        return TextUtil.urlEncode(rs);
    }

    public static String urlDecodeUTF8(String utf8) {
        if (utf8 == null) {
            return null;
        }
        return TextUtil.urlDecode(utf8.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8.toString());
    }

    public static String urlEncode(String data, String encoding) {
        if (StandardCharsets.UTF_8.toString().equals(encoding)) {
            return TextUtil.urlEncodeUTF8(data);
        }
        return TextUtil.urlEncode(data.getBytes(Charset.forName(encoding)));
    }

    public static String urlDecode(String data, String encoding) throws IllegalArgumentException {
        if ("UTF-8".equals(encoding)) {
            return TextUtil.urlDecodeUTF8(data);
        }
        return TextUtil.urlDecode(data.getBytes(Charset.forName(encoding)), encoding);
    }

    public static String replaceEntities(String src) {
        src = TextUtil.replaceString(src, "&", "&amp;");
        src = TextUtil.replaceString(src, "<", "&lt;");
        src = TextUtil.replaceString(src, ">", "&gt;");
        src = TextUtil.replaceString(src, "\"", "&quot;");
        return src;
    }

    public static String replaceString(String orig, String src, String dest) {
        if (orig == null) {
            return null;
        }
        if (src == null || dest == null) {
            throw new NullPointerException();
        }
        if (src.length() == 0) {
            return orig;
        }
        StringBuilder res = new StringBuilder(orig.length() + 20);
        int start = 0;
        int end = 0;
        int last = 0;
        while ((start = orig.indexOf(src, end)) != -1) {
            res.append(orig.substring(last, start));
            res.append(dest);
            end = start + src.length();
            last = start + src.length();
        }
        res.append(orig.substring(end));
        return res.toString();
    }

    public static String replaceString(String orig, int start, int end, String text) {
        if (orig == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(orig);
        buf.replace(start, end, text);
        return buf.toString();
    }

    public static String replaceStringCaseUnsensitive(String orig, String src, String dest) {
        if (orig == null) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        int start = 0;
        int end = 0;
        int last = 0;
        String origCaseUnsn = orig.toLowerCase();
        String srcCaseUnsn = src.toLowerCase();
        while ((start = origCaseUnsn.indexOf(srcCaseUnsn, end)) != -1) {
            res.append(orig.substring(last, start));
            res.append(dest);
            end = start + src.length();
            last = start + src.length();
        }
        res.append(orig.substring(end));
        return res.toString();
    }

    public static int parseIntParameter(String value, int defvalue) {
        int val = defvalue;
        try {
            val = Integer.parseInt(value.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static int getIntegerProperty(Properties props, String key, int defVal) {
        String val = System.getProperties().getProperty(key, System.getenv(StringUtils.replace((String)key, (String)".", (String)"_")));
        if (val == null) {
            val = props.getProperty(key);
        }
        return TextUtil.parseIntParameter(val, defVal);
    }

    public static boolean getBooleanProperty(Properties props, String key, boolean defval) {
        String val = System.getProperties().getProperty(key, System.getenv(StringUtils.replace((String)key, (String)".", (String)"_")));
        if (val == null) {
            val = props.getProperty(key);
        }
        if (val == null) {
            return defval;
        }
        return TextUtil.isPositive(val);
    }

    public static String getStringProperty(Properties props, String key, String defval) {
        String val = System.getProperties().getProperty(key, System.getenv(StringUtils.replace((String)key, (String)".", (String)"_")));
        if (val == null) {
            val = props.getProperty(key);
        }
        if (val == null) {
            return defval;
        }
        return val.trim();
    }

    public static String getCanonicalFilePathProperty(Properties props, String key, String defval) {
        String result;
        String val = System.getProperties().getProperty(key, System.getenv(StringUtils.replace((String)key, (String)".", (String)"_")));
        if (val == null) {
            val = props.getProperty(key);
        }
        if (val == null) {
            val = defval;
        }
        try {
            result = new File(new File(val.trim()).getCanonicalPath()).getAbsolutePath();
        }
        catch (IOException e) {
            result = val.trim();
        }
        return result;
    }

    public static boolean isPositive(String val) {
        if (val == null) {
            return false;
        }
        return (val = val.trim()).equalsIgnoreCase("true") || val.equalsIgnoreCase("on") || val.equalsIgnoreCase("yes");
    }

    public static String normalizePostData(String postData) {
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < postData.length(); ++i) {
            switch (postData.charAt(i)) {
                case '\n': {
                    sb.append("\r\n");
                    continue block4;
                }
                case '\r': {
                    sb.append("\r\n");
                    if (i >= postData.length() - 1 || postData.charAt(i + 1) != '\n') continue block4;
                    ++i;
                    continue block4;
                }
                default: {
                    sb.append(postData.charAt(i));
                }
            }
        }
        if (sb.length() < 2 || !sb.substring(sb.length() - 2).equals("\r\n")) {
            sb.append("\r\n");
        }
        return sb.toString();
    }

    private static int getCharKind(int c) {
        if (c == -1) {
            return 0;
        }
        char ch = (char)c;
        if (Character.isLowerCase(ch)) {
            return 1;
        }
        if (Character.isUpperCase(ch)) {
            return 2;
        }
        if (Character.isDigit(ch)) {
            return 3;
        }
        return 4;
    }

    public static String beautifyString(String s) {
        return TextUtil.beautifyString(s, " ");
    }

    public static String beautifyString(String s, String space) {
        if (s == null || s.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int cur = s.charAt(0);
        int curKind = TextUtil.getCharKind(cur);
        int prevKind = 1;
        int nextKind = -1;
        int next = -1;
        int nextPos = 1;
        while (curKind != 0) {
            next = nextPos < s.length() ? (int)s.charAt(nextPos++) : -1;
            nextKind = TextUtil.getCharKind(next);
            if (prevKind == 2 && curKind == 2 && nextKind == 1) {
                result.append(space);
                result.append((char)cur);
            } else {
                result.append((char)cur);
                if (curKind == 2 && nextKind == 3 || curKind == 1 && (nextKind == 3 || nextKind == 2) || curKind == 3 && (nextKind == 2 || nextKind == 1)) {
                    result.append(space);
                }
            }
            prevKind = curKind;
            cur = next;
            curKind = nextKind;
        }
        return result.toString();
    }

    public static Properties createProperties(String[] values) throws IllegalArgumentException {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("One value is missing.");
        }
        Properties props = new Properties();
        for (int i = 0; i < values.length; i += 2) {
            props.setProperty(values[i], values[i + 1]);
        }
        return props;
    }

    public static int countSections(String pagedata) {
        int tags = 0;
        int start = 0;
        while ((start = pagedata.indexOf("----", start)) != -1) {
            ++tags;
            start += 4;
        }
        return pagedata.length() > 0 ? tags + 1 : 0;
    }

    public static String getSection(String pagedata, int section) throws IllegalArgumentException {
        int tags = 0;
        int start = 0;
        int previous = 0;
        while ((start = pagedata.indexOf("----", start)) != -1) {
            if (++tags == section) {
                return pagedata.substring(previous, start);
            }
            start += 4;
            while (start < pagedata.length() && pagedata.charAt(start) == '-') {
                ++start;
            }
            previous = start;
        }
        if (++tags == section) {
            return pagedata.substring(previous);
        }
        throw new IllegalArgumentException("There is no section no. " + section + " on the page.");
    }

    public static String repeatString(String what, int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(what);
        }
        return sb.toString();
    }

    public static String native2Ascii(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char aChar = s.charAt(i);
            if (aChar < ' ' || aChar > '~') {
                sb.append('\\');
                sb.append('u');
                sb.append(TextUtil.toHex(aChar >> 12 & 0xF));
                sb.append(TextUtil.toHex(aChar >> 8 & 0xF));
                sb.append(TextUtil.toHex(aChar >> 4 & 0xF));
                sb.append(TextUtil.toHex(aChar & 0xF));
                continue;
            }
            sb.append(aChar);
        }
        return sb.toString();
    }

    private static char toHex(int nibble) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        return hexDigit[nibble & 0xF];
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(TextUtil.toHex(bytes[i] >> 4));
            sb.append(TextUtil.toHex(bytes[i]));
        }
        return sb.toString();
    }

    public static boolean isNumber(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() > 1 && s.charAt(0) == '-') {
            s = s.substring(1);
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String generateRandomPassword() {
        String letters = "abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ23456789+@";
        String pw = "";
        for (int i = 0; i < 8; ++i) {
            int index = (int)(RANDOM.nextDouble() * (double)letters.length());
            pw = pw + letters.substring(index, index + 1);
        }
        return pw;
    }
}

