/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util.comparators;

import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public class HumanComparator
implements Comparator<String> {
    public static final Comparator<String> DEFAULT_HUMAN_COMPARATOR = new HumanComparator();
    private CharType[] sortOrder = new CharType[]{CharType.TYPE_OTHER, CharType.TYPE_DIGIT, CharType.TYPE_LETTER};

    public static Comparator<String> getInstance() {
        return DEFAULT_HUMAN_COMPARATOR;
    }

    public HumanComparator() {
    }

    public HumanComparator(CharType[] sortOrder) {
        this.setSortOrder(sortOrder);
    }

    @Override
    public int compare(String str1, String str2) {
        if (StringUtils.equals((String)str1, (String)str2)) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        char[] s1 = str1.toCharArray();
        char[] s2 = str2.toCharArray();
        int len1 = s1.length;
        int len2 = s2.length;
        int idx = 0;
        int caseComparison = 0;
        while (idx < len1 && idx < len2) {
            CharType type2;
            char c1 = s1[idx];
            char c2 = s2[idx++];
            char lc1 = Character.toLowerCase(c1);
            char lc2 = Character.toLowerCase(c2);
            if (caseComparison == 0 && c1 != c2 && lc1 == lc2) {
                if (Character.isLowerCase(c1)) {
                    caseComparison = 1;
                } else if (Character.isLowerCase(c2)) {
                    caseComparison = -1;
                }
            }
            if ((c1 = lc1) == (c2 = lc2) && c1 != '0') continue;
            CharType type1 = this.mapCharTypes(c1);
            int result = this.compareCharTypes(type1, type2 = this.mapCharTypes(c2));
            if (result != 0) {
                return result;
            }
            if (type1 != CharType.TYPE_DIGIT) {
                Character ch1 = Character.valueOf(c1);
                Character ch2 = Character.valueOf(c2);
                return ch1.compareTo(ch2);
            }
            assert (type1 == CharType.TYPE_DIGIT && type2 == CharType.TYPE_DIGIT);
            result = this.compareDigits(s1, s2, idx - 1);
            if (result != 0) {
                return result;
            }
            while (idx < len1 && idx < len2 && Character.isDigit(s1[idx])) {
                ++idx;
            }
        }
        if (len1 == len2) {
            return caseComparison;
        }
        return len1 - len2;
    }

    private int compareCharTypes(CharType type1, CharType type2) {
        if (type1 == type2) {
            return 0;
        }
        if (type1 == this.sortOrder[0]) {
            return -1;
        }
        if (type2 == this.sortOrder[0]) {
            return 1;
        }
        if (type1 == this.sortOrder[1]) {
            return -1;
        }
        if (type2 == this.sortOrder[1]) {
            return 1;
        }
        assert (type1 != type2);
        return 0;
    }

    private int compareDigits(char[] left, char[] right, int offset) {
        int idx;
        for (idx = offset; idx < left.length && Character.isDigit(left[idx]); ++idx) {
        }
        int leftLen = idx - offset;
        int leftValue = Integer.valueOf(new String(left, offset, leftLen));
        for (idx = offset; idx < right.length && Character.isDigit(right[idx]); ++idx) {
        }
        int rightLen = idx - offset;
        int rightValue = Integer.valueOf(new String(right, offset, rightLen));
        if (leftValue == rightValue) {
            return leftLen - rightLen;
        }
        return leftValue - rightValue;
    }

    public CharType[] getSortOrder() {
        return this.sortOrder;
    }

    private CharType mapCharTypes(char c) {
        if (Character.isDigit(c)) {
            return CharType.TYPE_DIGIT;
        }
        if (Character.isLetter(c)) {
            return CharType.TYPE_LETTER;
        }
        return CharType.TYPE_OTHER;
    }

    public void setSortOrder(CharType[] sortOrder) {
        if (this == DEFAULT_HUMAN_COMPARATOR) {
            throw new IllegalArgumentException("Can't call setters on default " + HumanComparator.class.getName());
        }
        if (sortOrder == null || sortOrder.length != 3) {
            throw new IllegalArgumentException("There must be exactly three elements in the sort order");
        }
        if (sortOrder[0] == sortOrder[1] || sortOrder[0] == sortOrder[2] || sortOrder[1] == sortOrder[2]) {
            throw new IllegalArgumentException("The sort order must contain EXACTLY one of each CharType");
        }
        this.sortOrder = (CharType[])sortOrder.clone();
    }

    public static enum CharType {
        TYPE_OTHER,
        TYPE_DIGIT,
        TYPE_LETTER;

    }
}

