/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.workflow;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.workflow.AbstractStep;
import org.apache.wiki.workflow.Fact;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Workflow;
import org.apache.wiki.workflow.WorkflowManager;

public abstract class Decision
extends AbstractStep {
    private static final long serialVersionUID = -6835601038263238062L;
    private Principal m_actor;
    private int m_id;
    private final Outcome m_defaultOutcome;
    private final List<Fact> m_facts;

    public Decision(Workflow workflow, String messageKey, Principal actor, Outcome defaultOutcome) {
        super(workflow, messageKey);
        this.m_actor = actor;
        this.m_defaultOutcome = defaultOutcome;
        this.m_facts = new ArrayList<Fact>();
        this.addSuccessor(defaultOutcome, null);
    }

    public final void addFact(Fact fact) {
        this.m_facts.add(fact);
    }

    public void decide(Outcome outcome) throws WikiException {
        super.setOutcome(outcome);
        Workflow w = this.getWorkflow();
        if (w.getCurrentState() == 30 && this.equals(w.getCurrentStep())) {
            WorkflowManager wm = w.getWorkflowManager();
            if (wm != null) {
                wm.getDecisionQueue().remove(this);
            }
            w.restart();
        }
    }

    @Override
    public Outcome execute() throws WikiException {
        if (this.getOutcome().isCompletion()) {
            return this.getOutcome();
        }
        WorkflowManager wm = this.getWorkflow().getWorkflowManager();
        if (wm != null) {
            wm.getDecisionQueue().add(this);
        }
        return Outcome.STEP_CONTINUE;
    }

    @Override
    public final Principal getActor() {
        return this.m_actor;
    }

    public Outcome getDefaultOutcome() {
        return this.m_defaultOutcome;
    }

    public final List<Fact> getFacts() {
        return Collections.unmodifiableList(this.m_facts);
    }

    public final int getId() {
        return this.m_id;
    }

    public boolean isReassignable() {
        return true;
    }

    public final synchronized void reassign(Principal actor) {
        if (!this.isReassignable()) {
            throw new IllegalArgumentException("Decision cannot be reassigned.");
        }
        this.m_actor = actor;
    }

    public final void setId(int id) {
        this.m_id = id;
    }
}

