/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.xmlrpc;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.plugin.WeblogEntryPlugin;
import org.apache.wiki.plugin.WeblogPlugin;
import org.apache.wiki.util.comparators.PageTimeComparator;
import org.apache.wiki.xmlrpc.WikiRPCHandler;
import org.apache.xmlrpc.XmlRpcException;

public class MetaWeblogHandler
implements WikiRPCHandler {
    private static Logger log = Logger.getLogger(MetaWeblogHandler.class);
    private WikiContext m_context;

    @Override
    public void initialize(WikiContext context) {
        this.m_context = context;
    }

    private void checkPermissions(WikiPage page, String username, String password, String permission) throws XmlRpcException {
        block4: {
            try {
                AuthenticationManager amm = this.m_context.getEngine().getAuthenticationManager();
                AuthorizationManager mgr = this.m_context.getEngine().getAuthorizationManager();
                if (amm.login(this.m_context.getWikiSession(), this.m_context.getHttpRequest(), username, password)) {
                    if (!mgr.checkPermission(this.m_context.getWikiSession(), PermissionFactory.getPagePermission(page, permission))) {
                        throw new XmlRpcException(1, "No permission");
                    }
                    break block4;
                }
                throw new XmlRpcException(1, "Unknown login");
            }
            catch (WikiSecurityException e) {
                throw new XmlRpcException(1, e.getMessage(), (Throwable)e);
            }
        }
    }

    public Hashtable getCategories(String blogid, String username, String password) throws XmlRpcException {
        WikiPage page = this.m_context.getEngine().getPage(blogid);
        this.checkPermissions(page, username, password, "view");
        Hashtable ht = new Hashtable();
        return ht;
    }

    private String getURL(String page) {
        return this.m_context.getEngine().getURL(WikiContext.VIEW, page, null, true);
    }

    private Hashtable<String, Object> makeEntry(WikiPage page) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        WikiPage firstVersion = this.m_context.getEngine().getPage(page.getName(), 1);
        ht.put("dateCreated", firstVersion.getLastModified());
        ht.put("link", this.getURL(page.getName()));
        ht.put("permaLink", this.getURL(page.getName()));
        ht.put("postid", page.getName());
        ht.put("userid", page.getAuthor());
        String pageText = this.m_context.getEngine().getText(page.getName());
        String title = "";
        int firstLine = pageText.indexOf(10);
        if (firstLine > 0) {
            title = pageText.substring(0, firstLine);
        }
        if (title.trim().length() == 0) {
            title = page.getName();
        }
        while (title.startsWith("!")) {
            title = title.substring(1);
        }
        ht.put("title", title);
        ht.put("description", pageText);
        return ht;
    }

    public Hashtable getRecentPosts(String blogid, String username, String password, int numberOfPosts) throws XmlRpcException {
        Hashtable<String, Hashtable<String, Object>> result = new Hashtable<String, Hashtable<String, Object>>();
        log.info((Object)"metaWeblog.getRecentPosts() called");
        WikiPage page = this.m_context.getEngine().getPage(blogid);
        this.checkPermissions(page, username, password, "view");
        try {
            WeblogPlugin plugin = new WeblogPlugin();
            List<WikiPage> changed = plugin.findBlogEntries(this.m_context.getEngine(), blogid, new Date(0L), new Date());
            Collections.sort(changed, new PageTimeComparator());
            Iterator<WikiPage> i = changed.iterator();
            for (int items = 0; i.hasNext() && items < numberOfPosts; ++items) {
                WikiPage p = i.next();
                result.put("entry", this.makeEntry(p));
            }
        }
        catch (ProviderException e) {
            log.error((Object)"Failed to list recent posts", (Throwable)e);
            throw new XmlRpcException(0, e.getMessage());
        }
        return result;
    }

    public String newPost(String blogid, String username, String password, Hashtable content, boolean publish) throws XmlRpcException {
        log.info((Object)"metaWeblog.newPost() called");
        WikiEngine engine = this.m_context.getEngine();
        WikiPage page = engine.getPage(blogid);
        this.checkPermissions(page, username, password, "createPages");
        try {
            WeblogEntryPlugin plugin = new WeblogEntryPlugin();
            String pageName = plugin.getNewEntryPage(engine, blogid);
            WikiPage entryPage = new WikiPage(engine, pageName);
            entryPage.setAuthor(username);
            WikiContext context = new WikiContext(engine, entryPage);
            StringBuilder text = new StringBuilder();
            text.append("!" + content.get("title"));
            text.append("\n\n");
            text.append(content.get("description"));
            log.debug((Object)("Writing entry: " + text));
            engine.saveText(context, text.toString());
        }
        catch (Exception e) {
            log.error((Object)"Failed to create weblog entry", (Throwable)e);
            throw new XmlRpcException(0, "Failed to create weblog entry: " + e.getMessage());
        }
        return "";
    }

    public Hashtable newMediaObject(String blogid, String username, String password, Hashtable content) throws XmlRpcException {
        WikiEngine engine = this.m_context.getEngine();
        String url = "";
        log.info((Object)"metaWeblog.newMediaObject() called");
        WikiPage page = engine.getPage(blogid);
        this.checkPermissions(page, username, password, "upload");
        String name = (String)content.get("name");
        byte[] data = (byte[])content.get("bits");
        AttachmentManager attmgr = engine.getAttachmentManager();
        try {
            Attachment att = new Attachment(engine, blogid, name);
            att.setAuthor(username);
            attmgr.storeAttachment(att, new ByteArrayInputStream(data));
            url = engine.getURL(WikiContext.ATTACH, att.getName(), null, true);
        }
        catch (Exception e) {
            log.error((Object)"Failed to upload attachment", (Throwable)e);
            throw new XmlRpcException(0, "Failed to upload media object: " + e.getMessage());
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("url", url);
        return result;
    }

    boolean editPost(String postid, String username, String password, Hashtable content, boolean publish) throws XmlRpcException {
        WikiEngine engine = this.m_context.getEngine();
        log.info((Object)("metaWeblog.editPost(" + postid + ") called"));
        WikiPage page = engine.getPage(postid);
        this.checkPermissions(page, username, password, "edit");
        try {
            WikiPage entryPage = (WikiPage)page.clone();
            entryPage.setAuthor(username);
            WikiContext context = new WikiContext(engine, entryPage);
            StringBuilder text = new StringBuilder();
            text.append("!" + content.get("title"));
            text.append("\n\n");
            text.append(content.get("description"));
            log.debug((Object)("Updating entry: " + text));
            engine.saveText(context, text.toString());
        }
        catch (Exception e) {
            log.error((Object)"Failed to create weblog entry", (Throwable)e);
            throw new XmlRpcException(0, "Failed to update weblog entry: " + e.getMessage());
        }
        return true;
    }

    Hashtable getPost(String postid, String username, String password) throws XmlRpcException {
        String wikiname = "FIXME";
        WikiPage page = this.m_context.getEngine().getPage(wikiname);
        this.checkPermissions(page, username, password, "view");
        return this.makeEntry(page);
    }
}

