/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.filters.BasicPageFilter;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventUtils;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.modules.InternalModule;
import org.apache.wiki.util.TextUtil;

public class ReferenceManager
extends BasicPageFilter
implements InternalModule,
WikiEventListener {
    private Map<String, Collection<String>> m_refersTo = new HashMap<String, Collection<String>>();
    private Map<String, Collection<String>> m_unmutableRefersTo;
    private Map<String, Set<String>> m_referredBy = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> m_unmutableReferredBy;
    private boolean m_matchEnglishPlurals = false;
    private static Logger log = Logger.getLogger(ReferenceManager.class);
    private static final String SERIALIZATION_FILE = "refmgr.ser";
    private static final String SERIALIZATION_DIR = "refmgr-attr";
    private static final long serialVersionUID = 4L;

    public ReferenceManager(WikiEngine engine) {
        this.m_engine = engine;
        this.m_matchEnglishPlurals = TextUtil.getBooleanProperty((Properties)engine.getWikiProperties(), (String)"jspwiki.translatorReader.matchEnglishPlurals", (boolean)this.m_matchEnglishPlurals);
        this.m_unmutableReferredBy = Collections.unmodifiableMap(this.m_referredBy);
        this.m_unmutableRefersTo = Collections.unmodifiableMap(this.m_refersTo);
    }

    private void updatePageReferences(WikiPage page) throws ProviderException {
        String content = this.m_engine.getPageManager().getPageText(page.getName(), -1);
        TreeSet<String> res = new TreeSet<String>();
        Collection<String> links = this.m_engine.scanWikiLinks(page, content);
        res.addAll(links);
        List<Attachment> attachments = this.m_engine.getAttachmentManager().listAttachments(page);
        Iterator<Attachment> atti = attachments.iterator();
        while (atti.hasNext()) {
            res.add(atti.next().getName());
        }
        this.internalUpdateReferences(page.getName(), res);
    }

    public void initialize(Collection<WikiPage> pages) throws ProviderException {
        log.debug((Object)("Initializing new ReferenceManager with " + pages.size() + " initial pages."));
        StopWatch sw = new StopWatch();
        sw.start();
        log.info((Object)"Starting cross reference scan of WikiPages");
        try {
            long saved = this.unserializeFromDisk();
            for (WikiPage page : pages) {
                this.unserializeAttrsFromDisk(page);
            }
            for (WikiPage page : pages) {
                if (page instanceof Attachment) continue;
                if ((page = this.m_engine.getPage(page.getName())).getLastModified() == null) {
                    log.fatal((Object)"Provider returns null lastModified.  Please submit a bug report.");
                    continue;
                }
                if (page.getLastModified().getTime() <= saved) continue;
                this.updatePageReferences(page);
            }
        }
        catch (Exception e) {
            log.info((Object)("Unable to unserialize old refmgr information, rebuilding database: " + e.getMessage()));
            this.buildKeyLists(pages);
            for (WikiPage page : pages) {
                if (page instanceof Attachment) continue;
                this.updatePageReferences(page);
                this.serializeAttrsToDisk(page);
            }
            this.serializeToDisk();
        }
        sw.stop();
        log.info((Object)("Cross reference scan done in " + sw));
        WikiEventUtils.addWikiEventListener(this.m_engine.getPageManager(), 27, this);
    }

    private synchronized long unserializeFromDisk() throws IOException, ClassNotFoundException {
        long saved = 0L;
        File f = new File(this.m_engine.getWorkDir(), SERIALIZATION_FILE);
        try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)));){
            StopWatch sw = new StopWatch();
            sw.start();
            long ver = in.readLong();
            if (ver != 4L) {
                throw new IOException("File format has changed; I need to recalculate references.");
            }
            saved = in.readLong();
            this.m_refersTo = (Map)in.readObject();
            this.m_referredBy = (Map)in.readObject();
            in.close();
            this.m_unmutableReferredBy = Collections.unmodifiableMap(this.m_referredBy);
            this.m_unmutableRefersTo = Collections.unmodifiableMap(this.m_refersTo);
            sw.stop();
            log.debug((Object)("Read serialized data successfully in " + sw));
        }
        return saved;
    }

    private synchronized void serializeToDisk() {
        File f = new File(this.m_engine.getWorkDir(), SERIALIZATION_FILE);
        try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));){
            StopWatch sw = new StopWatch();
            sw.start();
            out.writeLong(4L);
            out.writeLong(System.currentTimeMillis());
            out.writeObject(this.m_refersTo);
            out.writeObject(this.m_referredBy);
            out.close();
            sw.stop();
            log.debug((Object)("serialization done - took " + sw));
        }
        catch (IOException ioe) {
            log.error((Object)"Unable to serialize!", (Throwable)ioe);
        }
    }

    private String getHashFileName(String pageName) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] dig = digest.digest(pageName.getBytes(StandardCharsets.UTF_8));
            return TextUtil.toHexString((byte[])dig) + ".cache";
        }
        catch (NoSuchAlgorithmException e) {
            log.fatal((Object)"What do you mean - no such algorithm?", (Throwable)e);
            return null;
        }
    }

    private synchronized long unserializeAttrsFromDisk(WikiPage p) throws IOException, ClassNotFoundException {
        long saved = 0L;
        String hashName = this.getHashFileName(p.getName());
        if (hashName != null) {
            File f = new File(this.m_engine.getWorkDir(), SERIALIZATION_DIR);
            if (!(f = new File(f, hashName)).exists()) {
                return 0L;
            }
            try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)));){
                StopWatch sw = new StopWatch();
                sw.start();
                log.debug((Object)("Deserializing attributes for " + p.getName()));
                long ver = in.readLong();
                if (ver != 4L) {
                    log.debug((Object)"File format has changed; cannot deserialize.");
                    long l = 0L;
                    return l;
                }
                saved = in.readLong();
                String name = in.readUTF();
                if (!name.equals(p.getName())) {
                    log.debug((Object)("File name does not match (" + name + "), skipping..."));
                    long l = 0L;
                    return l;
                }
                long entries = in.readLong();
                int i = 0;
                while ((long)i < entries) {
                    String key = in.readUTF();
                    Object value = in.readObject();
                    p.setAttribute(key, value);
                    log.debug((Object)("   attr: " + key + "=" + value));
                    ++i;
                }
                in.close();
                sw.stop();
                log.debug((Object)("Read serialized data for " + name + " successfully in " + sw));
                p.setHasMetadata();
            }
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void serializeAttrsToDisk(WikiPage p) {
        StopWatch sw = new StopWatch();
        sw.start();
        String hashName = this.getHashFileName(p.getName());
        if (hashName != null) {
            File f = new File(this.m_engine.getWorkDir(), SERIALIZATION_DIR);
            if (!f.exists()) {
                f.mkdirs();
            }
            f = new File(f, hashName);
            try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));){
                HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>(p.getAttributes().entrySet());
                if (entries.size() == 0) {
                    f.delete();
                    return;
                }
                out.writeLong(4L);
                out.writeLong(System.currentTimeMillis());
                out.writeUTF(p.getName());
                out.writeLong(entries.size());
                for (Map.Entry entry : entries) {
                    if (!(entry.getValue() instanceof Serializable)) continue;
                    out.writeUTF((String)entry.getKey());
                    out.writeObject(entry.getValue());
                }
            }
            catch (IOException e) {
                log.error((Object)"Unable to serialize!", (Throwable)e);
            }
            finally {
                sw.stop();
                log.debug((Object)("serialization for " + p.getName() + " done - took " + sw));
            }
        }
    }

    @Override
    public void postSave(WikiContext context, String content) {
        WikiPage page = context.getPage();
        this.updateReferences(page.getName(), context.getEngine().scanWikiLinks(page, content));
        this.serializeAttrsToDisk(page);
    }

    public synchronized void pageRemoved(WikiPage page) {
        String pageName = page.getName();
        this.pageRemoved(pageName);
    }

    private void pageRemoved(String pageName) {
        Set<String> refBy;
        Collection<String> refTo = this.m_refersTo.get(pageName);
        if (refTo != null) {
            for (String referredPageName : refTo) {
                Set<String> refBy2 = this.m_referredBy.get(referredPageName);
                if (refBy2 == null) {
                    throw new InternalWikiException("Refmgr out of sync: page " + pageName + " refers to " + referredPageName + ", which has null referrers.");
                }
                refBy2.remove(pageName);
                this.m_referredBy.remove(referredPageName);
                if (refBy2.isEmpty() && !this.m_engine.pageExists(referredPageName)) continue;
                this.m_referredBy.put(referredPageName, refBy2);
            }
            log.debug((Object)("Removing from m_refersTo HashMap key:value " + pageName + ":" + this.m_refersTo.get(pageName)));
            this.m_refersTo.remove(pageName);
        }
        if ((refBy = this.m_referredBy.get(pageName)) == null || refBy.isEmpty()) {
            this.m_referredBy.remove(pageName);
        }
        this.serializeToDisk();
        String hashName = this.getHashFileName(pageName);
        if (hashName != null) {
            File f = new File(this.m_engine.getWorkDir(), SERIALIZATION_DIR);
            if ((f = new File(f, this.getHashFileName(pageName))).exists()) {
                f.delete();
            }
        }
    }

    public synchronized void updateReferences(String page, Collection<String> references) {
        this.internalUpdateReferences(page, references);
        this.serializeToDisk();
    }

    private void internalUpdateReferences(String page, Collection<String> references) {
        page = this.getFinalPageName(page);
        Collection<String> oldRefTo = this.m_refersTo.get(page);
        this.m_refersTo.remove(page);
        TreeSet<String> cleanedRefs = new TreeSet<String>();
        for (String ref : references) {
            ref = this.getFinalPageName(ref);
            cleanedRefs.add(ref);
        }
        this.m_refersTo.put(page, cleanedRefs);
        if (!this.m_referredBy.containsKey(page)) {
            this.m_referredBy.put(page, new TreeSet());
        }
        this.cleanReferredBy(page, oldRefTo, cleanedRefs);
        for (String referredPageName : cleanedRefs) {
            this.updateReferredBy(this.getFinalPageName(referredPageName), page);
        }
    }

    protected Map<String, Collection<String>> getRefersTo() {
        return this.m_refersTo;
    }

    protected Map<String, Set<String>> getReferredBy() {
        return this.m_referredBy;
    }

    private void cleanReferredBy(String referrer, Collection<String> oldReferred, Collection<String> newReferred) {
        if (oldReferred == null) {
            return;
        }
        for (String referredPage : oldReferred) {
            Set<String> oldRefBy = this.m_referredBy.get(referredPage);
            if (oldRefBy != null) {
                oldRefBy.remove(referrer);
            }
            if (oldRefBy != null && !oldRefBy.isEmpty() || this.m_engine.pageExists(referredPage)) continue;
            this.m_referredBy.remove(referredPage);
        }
    }

    private synchronized void buildKeyLists(Collection<WikiPage> pages) {
        this.m_refersTo.clear();
        this.m_referredBy.clear();
        if (pages == null) {
            return;
        }
        Iterator<WikiPage> it = pages.iterator();
        try {
            while (it.hasNext()) {
                WikiPage page = it.next();
                this.m_referredBy.put(page.getName(), new TreeSet());
                this.m_refersTo.put(page.getName(), null);
            }
        }
        catch (ClassCastException e) {
            log.fatal((Object)"Invalid collection entry in ReferenceManager.buildKeyLists().", (Throwable)e);
        }
    }

    private void updateReferredBy(String page, String referrer) {
        Set<String> referrers;
        if (this.m_matchEnglishPlurals) {
            String p2;
            String string = p2 = page.endsWith("s") ? page.substring(0, page.length() - 1) : page + "s";
            if (referrer.equals(p2)) {
                return;
            }
        }
        if ((referrers = this.m_referredBy.get(page)) == null) {
            referrers = new TreeSet<String>();
            this.m_referredBy.put(page, referrers);
        }
        referrers.add(referrer);
    }

    public synchronized void clearPageEntries(String pagename) {
        Collection<String> c = this.m_refersTo.get(pagename = this.getFinalPageName(pagename));
        if (c != null) {
            for (String key : c) {
                Collection dref = this.m_referredBy.get(key);
                dref.remove(pagename);
            }
        }
        this.m_referredBy.remove(pagename);
        this.m_refersTo.remove(pagename);
    }

    public synchronized Collection<String> findUnreferenced() {
        ArrayList<String> unref = new ArrayList<String>();
        for (String key : this.m_referredBy.keySet()) {
            Set refs = this.getReferenceList(this.m_referredBy, key);
            if (refs != null && !refs.isEmpty()) continue;
            unref.add(key);
        }
        return unref;
    }

    public synchronized Collection<String> findUncreated() {
        TreeSet<String> uncreated = new TreeSet<String>();
        Collection<Collection<String>> allReferences = this.m_refersTo.values();
        for (Collection<String> refs : allReferences) {
            if (refs == null) continue;
            for (String aReference : refs) {
                if (this.m_engine.pageExists(aReference)) continue;
                uncreated.add(aReference);
            }
        }
        return uncreated;
    }

    private <T> Set<T> getReferenceList(Map<String, Set<T>> coll, String pagename) {
        Set<T> refs2;
        Set<T> refs = coll.get(pagename);
        if (this.m_matchEnglishPlurals && (refs2 = pagename.endsWith("s") ? coll.get(pagename.substring(0, pagename.length() - 1)) : coll.get(pagename + "s")) != null) {
            if (refs != null) {
                refs.addAll(refs2);
            } else {
                refs = refs2;
            }
        }
        return refs;
    }

    public synchronized Set<String> findReferrers(String pagename) {
        Set<String> refs = this.getReferenceList(this.m_referredBy, pagename);
        if (refs == null || refs.isEmpty()) {
            return null;
        }
        return refs;
    }

    public Set<String> findReferredBy(String pageName) {
        return this.m_unmutableReferredBy.get(this.getFinalPageName(pageName));
    }

    public Collection<String> findRefersTo(String pageName) {
        return this.m_unmutableRefersTo.get(this.getFinalPageName(pageName));
    }

    public int deepHashCode() {
        boolean failed = true;
        int signature = 0;
        while (failed) {
            signature = 0;
            try {
                signature ^= this.m_referredBy.hashCode();
                signature ^= this.m_refersTo.hashCode();
                failed = false;
            }
            catch (ConcurrentModificationException e) {
                Thread.yield();
            }
        }
        return signature;
    }

    public Set<String> findCreated() {
        return new HashSet<String>(this.m_refersTo.keySet());
    }

    private String getFinalPageName(String orig) {
        try {
            String s = this.m_engine.getFinalPageName(orig);
            if (s == null) {
                s = orig;
            }
            return s;
        }
        catch (ProviderException e) {
            log.error((Object)"Error while trying to fetch a page name; trying to cope with the situation.", (Throwable)e);
            return orig;
        }
    }

    @Override
    public void actionPerformed(WikiEvent event) {
        String pageName;
        if (event instanceof WikiPageEvent && event.getType() == 27 && (pageName = ((WikiPageEvent)event).getPageName()) != null) {
            this.pageRemoved(pageName);
        }
    }
}

