/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.wiki.Release;

public class TranslationsCheck {
    private static final TreeSet<String> allProps = new TreeSet();
    private static final TreeSet<String> duplProps = new TreeSet();
    static String base = ".";
    static String suffix = null;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Usage: java TranslationsCheck <language> [<path>]");
            System.out.println("Example: java TranslationsCheck nl [jspwiki-main/src/main/resources]");
            return;
        }
        suffix = args[0];
        if (args.length >= 2) {
            base = args[1];
        }
        System.out.println("Using code base " + Release.VERSTR);
        System.out.println("Internationalization property file differences between 'default en' and '" + suffix + "' following:\n");
        try {
            TranslationsCheck.diff("/CoreResources.properties", "/CoreResources_" + suffix + ".properties");
            TranslationsCheck.detectDuplicates("/CoreResources_" + suffix + ".properties");
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to locate /CoreResources_" + suffix + ".properties");
        }
        try {
            TranslationsCheck.diff("/templates/default.properties", "/templates/default_" + suffix + ".properties");
            TranslationsCheck.detectDuplicates("/templates/default_" + suffix + ".properties");
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to locate /templates/default_" + suffix + ".properties");
        }
        try {
            TranslationsCheck.diff("/plugin/PluginResources.properties", "/plugin/PluginResources_" + suffix + ".properties");
            TranslationsCheck.detectDuplicates("/plugin/PluginResources_" + suffix + ".properties");
            System.out.println("Duplicates overall (two or more occurences):");
            System.out.println("--------------------------------------------");
            Iterator<String> iter = duplProps.iterator();
            if (duplProps.size() == 0) {
                System.out.println("(none)");
            } else {
                while (iter.hasNext()) {
                    System.out.println(iter.next());
                }
            }
            System.out.println();
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to locate /plugin/PluginResources_" + suffix + ".properties");
        }
        System.out.println("NOTE: Please remember that dependent on the usage of these i18n files, outdated properties maybe should not be deleted, because they may be used by previous releases. Moving them to a special section in the file may be the better solution.");
    }

    public static Map<String, Integer> diff(String source1, String source2) throws FileNotFoundException, IOException {
        String value;
        int missing = 0;
        int outdated = 0;
        Properties p1 = new Properties();
        p1.load(TranslationsCheck.class.getClassLoader().getResourceAsStream(base + source1));
        Properties p2 = new Properties();
        p2.load(TranslationsCheck.class.getClassLoader().getResourceAsStream(base + source2));
        String msg = "Checking " + source2 + "...";
        System.out.println(msg);
        for (String name : TranslationsCheck.sortedNames(p1)) {
            value = p1.getProperty(name);
            if (p2.get(name) != null) continue;
            if (++missing == 1) {
                System.out.println("\nMissing:");
                System.out.println("--------");
            }
            System.out.println(name + " = " + value);
        }
        if (missing > 0) {
            System.out.println();
        }
        for (String name : TranslationsCheck.sortedNames(p2)) {
            value = p2.getProperty(name);
            if (p1.get(name) != null) continue;
            if (++outdated == 1) {
                System.out.println("\nOutdated or superfluous:");
                System.out.println("------------------------");
            }
            System.out.println(name + " = " + value);
        }
        if (outdated > 0) {
            System.out.println();
        }
        HashMap<String, Integer> diff = new HashMap<String, Integer>(2);
        diff.put("missing", missing);
        diff.put("outdated", outdated);
        return diff;
    }

    private static List<String> sortedNames(Properties p) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<?> iter = p.propertyNames();
        while (iter.hasMoreElements()) {
            list.add((String)iter.nextElement());
        }
        Collections.sort(list);
        return list;
    }

    public static int detectDuplicates(String source) throws IOException {
        Properties p = new Properties();
        p.load(TranslationsCheck.class.getClassLoader().getResourceAsStream(base + source));
        Enumeration<?> iter = p.propertyNames();
        while (iter.hasMoreElements()) {
            String currentStr = (String)iter.nextElement();
            if (allProps.add(currentStr)) continue;
            duplProps.add(currentStr);
        }
        return duplProps.size();
    }
}

