/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.LinkCollector;
import org.apache.wiki.ReferenceManager;
import org.apache.wiki.Release;
import org.apache.wiki.StringTransmutator;
import org.apache.wiki.VariableManager;
import org.apache.wiki.WatchDog;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.engine.AdminBeanManager;
import org.apache.wiki.api.engine.FilterManager;
import org.apache.wiki.api.engine.PluginManager;
import org.apache.wiki.api.exceptions.FilterException;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.NoSuchVariableException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.acl.AclManager;
import org.apache.wiki.auth.authorize.GroupManager;
import org.apache.wiki.content.PageRenamer;
import org.apache.wiki.diff.DifferenceManager;
import org.apache.wiki.event.WikiEngineEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.event.WikiPageRenameEvent;
import org.apache.wiki.i18n.InternationalizationManager;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.pages.PageTimeComparator;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.rss.RSSGenerator;
import org.apache.wiki.rss.RSSThread;
import org.apache.wiki.search.SearchManager;
import org.apache.wiki.tasks.TasksManager;
import org.apache.wiki.ui.Command;
import org.apache.wiki.ui.CommandResolver;
import org.apache.wiki.ui.EditorManager;
import org.apache.wiki.ui.TemplateManager;
import org.apache.wiki.ui.progress.ProgressManager;
import org.apache.wiki.url.URLConstructor;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.PropertyReader;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.workflow.Decision;
import org.apache.wiki.workflow.DecisionRequiredException;
import org.apache.wiki.workflow.Fact;
import org.apache.wiki.workflow.Step;
import org.apache.wiki.workflow.Workflow;
import org.apache.wiki.workflow.WorkflowBuilder;
import org.apache.wiki.workflow.WorkflowManager;

public class WikiEngine {
    private static final String ATTR_WIKIENGINE = "org.apache.wiki.WikiEngine";
    private static final Logger log = Logger.getLogger(WikiEngine.class);
    private static boolean c_configured = false;
    private Properties m_properties;
    public static final String DEFAULT_INLINEPATTERN = "*.png";
    public static final String DEFAULT_TEMPLATE_NAME = "default";
    public static final String PROP_APPNAME = "jspwiki.applicationName";
    public static final String PROP_INLINEIMAGEPTRN = "jspwiki.translatorReader.inlinePattern";
    public static final String PROP_INTERWIKIREF = "jspwiki.interWikiRef.";
    public static final String PROP_STOREUSERNAME = "jspwiki.storeUserName";
    public static final String PROP_ENCODING = "jspwiki.encoding";
    public static final String PROP_NO_FILTER_ENCODING = "jspwiki.nofilterencoding";
    public static final String PROP_REFSTYLE = "jspwiki.referenceStyle";
    public static final String PROP_BEAUTIFYTITLE = "jspwiki.breakTitleWithSpaces";
    public static final String PROP_WORKDIR = "jspwiki.workDir";
    public static final String PREFS_COOKIE_NAME = "JSPWikiUserProfile";
    public static final String PROP_MATCHPLURALS = "jspwiki.translatorReader.matchEnglishPlurals";
    public static final String PROP_TEMPLATEDIR = "jspwiki.templateDir";
    public static final String PROP_FRONTPAGE = "jspwiki.frontPage";
    public static final String PROP_URLCONSTRUCTOR = "jspwiki.urlConstructor";
    public static final String PROP_RUNFILTERS = "jspwiki.runFilters";
    private PageRenamer m_pageRenamer = null;
    public static final String PROP_ACL_MANAGER_IMPL = "jspwiki.aclManager";
    public static final String PROP_ALLOW_CREATION_OF_EMPTY_PAGES = "jspwiki.allowCreationOfEmptyPages";
    private boolean m_saveUserInfo = true;
    private boolean m_useUTF8 = true;
    private String m_rootPath = System.getProperty("user.dir");
    private ReferenceManager m_referenceManager = null;
    private PluginManager m_pluginManager;
    private VariableManager m_variableManager;
    private AttachmentManager m_attachmentManager = null;
    private PageManager m_pageManager = null;
    private AuthorizationManager m_authorizationManager = null;
    private AuthenticationManager m_authenticationManager = null;
    private AclManager m_aclManager = null;
    private CommandResolver m_commandResolver = null;
    private TemplateManager m_templateManager = null;
    private DifferenceManager m_differenceManager;
    private FilterManager m_filterManager;
    private SearchManager m_searchManager = null;
    private UserManager m_userManager = null;
    private GroupManager m_groupManager = null;
    private RenderingManager m_renderingManager;
    private EditorManager m_editorManager;
    private InternationalizationManager m_internationalizationManager;
    private ProgressManager m_progressManager;
    private TasksManager m_tasksManager;
    private URLConstructor m_urlConstructor;
    private RSSGenerator m_rssGenerator;
    private String m_rssFile;
    private ServletContext m_servletContext = null;
    private boolean m_beautifyTitle = false;
    private String m_templateDir;
    private String m_frontPage;
    private Date m_startTime;
    private String m_workDir;
    private String m_appid = "";
    private boolean m_isConfigured = false;
    private WorkflowManager m_workflowMgr = null;
    private AdminBeanManager m_adminBeanManager;
    private Map<String, Object> m_attributes = new ConcurrentHashMap<String, Object>();

    public static synchronized WikiEngine getInstance(ServletConfig config) throws InternalWikiException {
        return WikiEngine.getInstance(config.getServletContext(), null);
    }

    public static synchronized WikiEngine getInstance(ServletConfig config, Properties props) {
        return WikiEngine.getInstance(config.getServletContext(), props);
    }

    public static synchronized WikiEngine getInstance(ServletContext context, Properties props) throws InternalWikiException {
        WikiEngine engine = (WikiEngine)context.getAttribute(ATTR_WIKIENGINE);
        if (engine == null) {
            String appid = Integer.toString(context.hashCode());
            context.log(" Assigning new engine to " + appid);
            try {
                if (props == null) {
                    props = PropertyReader.loadWebAppProps((ServletContext)context);
                }
                engine = new WikiEngine(context, appid, props);
                context.setAttribute(ATTR_WIKIENGINE, (Object)engine);
            }
            catch (Exception e) {
                context.log("ERROR: Failed to create a Wiki engine: " + e.getMessage());
                log.error((Object)"ERROR: Failed to create a Wiki engine, stacktrace follows ", (Throwable)e);
                throw new InternalWikiException("No wiki engine, check logs.", e);
            }
        }
        return engine;
    }

    public WikiEngine(Properties properties) throws WikiException {
        this.initialize(properties);
    }

    protected WikiEngine(ServletContext context, String appid, Properties props) throws WikiException {
        this.m_servletContext = context;
        this.m_appid = appid;
        if (context != null) {
            context.setAttribute(ATTR_WIKIENGINE, (Object)this);
            this.m_rootPath = context.getRealPath("/");
        }
        try {
            this.initialize(props);
            log.info((Object)("Root path for this Wiki is: '" + this.m_rootPath + "'"));
        }
        catch (Exception e) {
            String msg = "JSPWiki: Unable to load and setup properties from jspwiki.properties. " + e.getMessage();
            if (context != null) {
                context.log(msg);
            }
            throw new WikiException(msg, e);
        }
    }

    private void initialize(Properties props) throws WikiException {
        this.m_startTime = new Date();
        this.m_properties = props;
        if (!c_configured) {
            String useExternalLogConfig = TextUtil.getStringProperty((Properties)props, (String)"jspwiki.use.external.logconfig", (String)"false");
            if (useExternalLogConfig == null || useExternalLogConfig.equals("false")) {
                PropertyConfigurator.configure((Properties)props);
            }
            c_configured = true;
        }
        log.info((Object)"*******************************************");
        log.info((Object)("JSPWiki " + Release.getVersionString() + " starting. Whee!"));
        this.fireEvent(-1);
        log.debug((Object)("Java version: " + System.getProperty("java.runtime.version")));
        log.debug((Object)("Java vendor: " + System.getProperty("java.vm.vendor")));
        log.debug((Object)("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch")));
        log.debug((Object)("Default server locale: " + Locale.getDefault()));
        log.debug((Object)("Default server timezone: " + TimeZone.getDefault().getDisplayName(true, 1)));
        if (this.m_servletContext != null) {
            log.info((Object)("Servlet container: " + this.m_servletContext.getServerInfo()));
            if (this.m_servletContext.getMajorVersion() < 2 || this.m_servletContext.getMajorVersion() == 2 && this.m_servletContext.getMinorVersion() < 4) {
                throw new InternalWikiException("I require a container which supports at least version 2.4 of Servlet specification");
            }
        }
        log.debug((Object)"Configuring WikiEngine...");
        this.m_commandResolver = new CommandResolver(this, props);
        this.m_workDir = TextUtil.getStringProperty((Properties)props, (String)PROP_WORKDIR, null);
        if (this.m_workDir == null) {
            this.m_workDir = System.getProperty("java.io.tmpdir", ".");
            this.m_workDir = this.m_workDir + File.separator + "JSPWiki" + "-" + this.m_appid;
        }
        try {
            File f = new File(this.m_workDir);
            f.mkdirs();
            if (!f.exists()) {
                throw new WikiException("Work directory does not exist: " + this.m_workDir);
            }
            if (!f.canRead()) {
                throw new WikiException("No permission to read work directory: " + this.m_workDir);
            }
            if (!f.canWrite()) {
                throw new WikiException("No permission to write to work directory: " + this.m_workDir);
            }
            if (!f.isDirectory()) {
                throw new WikiException("jspwiki.workDir does not point to a directory: " + this.m_workDir);
            }
        }
        catch (SecurityException e) {
            log.fatal((Object)("Unable to find or create the working directory: " + this.m_workDir), (Throwable)e);
            throw new IllegalArgumentException("Unable to find or create the working dir: " + this.m_workDir, e);
        }
        log.info((Object)("JSPWiki working directory is '" + this.m_workDir + "'"));
        this.m_saveUserInfo = TextUtil.getBooleanProperty((Properties)props, (String)PROP_STOREUSERNAME, (boolean)this.m_saveUserInfo);
        this.m_useUTF8 = StandardCharsets.UTF_8.name().equals(TextUtil.getStringProperty((Properties)props, (String)PROP_ENCODING, (String)StandardCharsets.ISO_8859_1.name()));
        this.m_beautifyTitle = TextUtil.getBooleanProperty((Properties)props, (String)PROP_BEAUTIFYTITLE, (boolean)this.m_beautifyTitle);
        this.m_templateDir = TextUtil.getStringProperty((Properties)props, (String)PROP_TEMPLATEDIR, (String)DEFAULT_TEMPLATE_NAME);
        this.enforceValidTemplateDirectory();
        this.m_frontPage = TextUtil.getStringProperty((Properties)props, (String)PROP_FRONTPAGE, (String)"Main");
        try {
            Class urlclass = ClassUtil.findClass((String)"org.apache.wiki.url", (String)TextUtil.getStringProperty((Properties)props, (String)PROP_URLCONSTRUCTOR, (String)"DefaultURLConstructor"));
            this.m_urlConstructor = (URLConstructor)urlclass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.m_urlConstructor.initialize(this, props);
            this.m_pageManager = (PageManager)ClassUtil.getMappedObject((String)PageManager.class.getName(), (Object[])new Object[]{this, props});
            this.m_pluginManager = (PluginManager)ClassUtil.getMappedObject((String)PluginManager.class.getName(), (Object[])new Object[]{this, props});
            this.m_differenceManager = (DifferenceManager)ClassUtil.getMappedObject((String)DifferenceManager.class.getName(), (Object[])new Object[]{this, props});
            this.m_attachmentManager = (AttachmentManager)ClassUtil.getMappedObject((String)AttachmentManager.class.getName(), (Object[])new Object[]{this, props});
            this.m_variableManager = (VariableManager)ClassUtil.getMappedObject((String)VariableManager.class.getName(), (Object[])new Object[]{props});
            this.m_renderingManager = (RenderingManager)ClassUtil.getMappedObject((String)RenderingManager.class.getName());
            this.m_searchManager = (SearchManager)ClassUtil.getMappedObject((String)SearchManager.class.getName(), (Object[])new Object[]{this, props});
            this.m_authenticationManager = (AuthenticationManager)ClassUtil.getMappedObject((String)AuthenticationManager.class.getName());
            this.m_authorizationManager = (AuthorizationManager)ClassUtil.getMappedObject((String)AuthorizationManager.class.getName());
            this.m_userManager = (UserManager)ClassUtil.getMappedObject((String)UserManager.class.getName());
            this.m_groupManager = (GroupManager)ClassUtil.getMappedObject((String)GroupManager.class.getName());
            this.m_editorManager = (EditorManager)ClassUtil.getMappedObject((String)EditorManager.class.getName(), (Object[])new Object[]{this});
            this.m_editorManager.initialize(props);
            this.m_progressManager = new ProgressManager();
            this.m_authenticationManager.initialize(this, props);
            this.m_authorizationManager.initialize(this, props);
            this.m_userManager.initialize(this, props);
            this.m_groupManager.initialize(this, props);
            this.m_aclManager = this.getAclManager();
            this.m_workflowMgr = (WorkflowManager)ClassUtil.getMappedObject((String)WorkflowManager.class.getName());
            this.m_workflowMgr.initialize(this, props);
            this.m_tasksManager = (TasksManager)ClassUtil.getMappedObject((String)TasksManager.class.getName());
            this.m_internationalizationManager = (InternationalizationManager)ClassUtil.getMappedObject((String)InternationalizationManager.class.getName(), (Object[])new Object[]{this});
            this.m_templateManager = (TemplateManager)ClassUtil.getMappedObject((String)TemplateManager.class.getName(), (Object[])new Object[]{this, props});
            this.m_filterManager = (FilterManager)ClassUtil.getMappedObject((String)FilterManager.class.getName(), (Object[])new Object[]{this, props});
            this.m_adminBeanManager = (AdminBeanManager)ClassUtil.getMappedObject((String)AdminBeanManager.class.getName(), (Object[])new Object[]{this});
            this.m_renderingManager.initialize(this, props);
            this.initReferenceManager();
            this.m_filterManager.addPageFilter(this.m_referenceManager, -1001);
            this.m_filterManager.addPageFilter(this.m_searchManager, -1002);
        }
        catch (RuntimeException e) {
            log.fatal((Object)"Failed to start managers.", (Throwable)e);
            throw new WikiException("Failed to start managers: " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            log.fatal((Object)("JSPWiki could not start, URLConstructor was not found: " + e.getMessage()), (Throwable)e);
            throw new WikiException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            log.fatal((Object)("JSPWiki could not start, URLConstructor could not be instantiated: " + e.getMessage()), (Throwable)e);
            throw new WikiException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            log.fatal((Object)("JSPWiki could not start, URLConstructor cannot be accessed: " + e.getMessage()), (Throwable)e);
            throw new WikiException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.fatal((Object)"JSPWiki could not start, due to an unknown exception when starting.", (Throwable)e);
            throw new WikiException("Failed to start. Caused by: " + e.getMessage() + "; please check log files for better information.", e);
        }
        try {
            if (TextUtil.getBooleanProperty((Properties)props, (String)"jspwiki.rss.generate", (boolean)false)) {
                this.m_rssGenerator = (RSSGenerator)ClassUtil.getMappedObject((String)RSSGenerator.class.getName(), (Object[])new Object[]{this, props});
            }
            this.m_pageRenamer = (PageRenamer)ClassUtil.getMappedObject((String)PageRenamer.class.getName(), (Object[])new Object[]{this, props});
        }
        catch (Exception e) {
            log.error((Object)"Unable to start RSS generator - JSPWiki will still work, but there will be no RSS feed.", (Throwable)e);
        }
        if (this.m_rssGenerator != null) {
            this.m_rssFile = TextUtil.getStringProperty((Properties)props, (String)"jspwiki.rss.fileName", (String)"rss.rdf");
            File rssFile = null;
            rssFile = this.m_rssFile.startsWith(File.separator) ? new File(this.m_rssFile) : new File(this.getRootPath(), this.m_rssFile);
            int rssInterval = TextUtil.getIntegerProperty((Properties)props, (String)"jspwiki.rss.interval", (int)3600);
            RSSThread rssThread = new RSSThread(this, rssFile, rssInterval);
            rssThread.start();
        }
        this.fireEvent(0);
        log.info((Object)"WikiEngine configured.");
        this.m_isConfigured = true;
    }

    void enforceValidTemplateDirectory() {
        if (this.m_servletContext != null) {
            String viewTemplate = "templates" + File.separator + this.getTemplateDir() + File.separator + "ViewTemplate.jsp";
            boolean exists = new File(this.m_servletContext.getRealPath("/") + viewTemplate).exists();
            if (!exists) {
                try {
                    URL url = this.m_servletContext.getResource(viewTemplate);
                    exists = url != null && StringUtils.isNotEmpty((CharSequence)url.getFile());
                }
                catch (MalformedURLException e) {
                    exists = false;
                }
            }
            if (!exists) {
                log.warn((Object)(this.getTemplateDir() + " template not found, updating WikiEngine's default template to " + DEFAULT_TEMPLATE_NAME));
                this.m_templateDir = DEFAULT_TEMPLATE_NAME;
            }
        }
    }

    public void initReferenceManager() throws WikiException {
        try {
            ArrayList<WikiPage> pages = new ArrayList<WikiPage>();
            pages.addAll(this.m_pageManager.getAllPages());
            pages.addAll(this.m_attachmentManager.getAllAttachments());
            if (this.m_referenceManager == null) {
                this.m_referenceManager = (ReferenceManager)ClassUtil.getMappedObject((String)ReferenceManager.class.getName(), (Object[])new Object[]{this});
                this.m_referenceManager.initialize(pages);
            }
        }
        catch (ProviderException e) {
            log.fatal((Object)"PageProvider is unable to list pages: ", (Throwable)e);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new WikiException("Could not instantiate ReferenceManager: " + e.getMessage(), e);
        }
    }

    public Properties getWikiProperties() {
        return this.m_properties;
    }

    public String getWorkDir() {
        return this.m_workDir;
    }

    public String getTemplateDir() {
        return this.m_templateDir;
    }

    public TemplateManager getTemplateManager() {
        return this.m_templateManager;
    }

    public String getBaseURL() {
        return this.m_servletContext.getContextPath();
    }

    public Date getStartTime() {
        return (Date)this.m_startTime.clone();
    }

    public String getViewURL(String pageName) {
        if (pageName == null) {
            pageName = this.getFrontPage();
        }
        return this.getURLConstructor().makeURL(WikiContext.VIEW, pageName, "absolute".equals(PROP_REFSTYLE), null);
    }

    public String getURL(String context, String pageName, String params, boolean absolute) {
        if (pageName == null) {
            pageName = this.getFrontPage();
        }
        return this.m_urlConstructor.makeURL(context, pageName, absolute, params);
    }

    public String getFrontPage() {
        return this.m_frontPage;
    }

    public ServletContext getServletContext() {
        return this.m_servletContext;
    }

    public String safeGetQueryString(HttpServletRequest request) {
        int pos1;
        if (request == null) {
            return "";
        }
        String res = request.getQueryString();
        if (res != null && (pos1 = (res = new String(res.getBytes(StandardCharsets.ISO_8859_1), this.getContentEncoding())).indexOf("page=")) >= 0) {
            String tmpRes = res.substring(0, pos1);
            int pos2 = res.indexOf("&", pos1) + 1;
            if (pos2 > 0 && pos2 < res.length()) {
                tmpRes = tmpRes + res.substring(pos2);
            }
            res = tmpRes;
        }
        return res;
    }

    public String getInterWikiURL(String wikiName) {
        return TextUtil.getStringProperty((Properties)this.m_properties, (String)(PROP_INTERWIKIREF + wikiName), null);
    }

    public Collection<String> getAllInterWikiLinks() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<?> i = this.m_properties.propertyNames();
        while (i.hasMoreElements()) {
            String prop = (String)i.nextElement();
            if (!prop.startsWith(PROP_INTERWIKIREF)) continue;
            list.add(prop.substring(prop.lastIndexOf(".") + 1));
        }
        return list;
    }

    public Collection<String> getAllInlinedImagePatterns() {
        Properties props = this.getWikiProperties();
        ArrayList<String> ptrnlist = new ArrayList<String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(PROP_INLINEIMAGEPTRN)) continue;
            String ptrn = TextUtil.getStringProperty((Properties)props, (String)name, null);
            ptrnlist.add(ptrn);
        }
        if (ptrnlist.size() == 0) {
            ptrnlist.add(DEFAULT_INLINEPATTERN);
        }
        return ptrnlist;
    }

    public String getSpecialPageReference(String original) {
        return this.m_commandResolver.getSpecialPageReference(original);
    }

    public String getApplicationName() {
        String appName = TextUtil.getStringProperty((Properties)this.m_properties, (String)PROP_APPNAME, (String)"JSPWiki");
        return MarkupParser.cleanLink(appName);
    }

    public String beautifyTitle(String title) {
        if (this.m_beautifyTitle) {
            try {
                Attachment att = this.m_attachmentManager.getAttachmentInfo(title);
                if (att == null) {
                    return TextUtil.beautifyString((String)title);
                }
                String parent = TextUtil.beautifyString((String)att.getParentName());
                return parent + "/" + att.getFileName();
            }
            catch (ProviderException e) {
                return title;
            }
        }
        return title;
    }

    public String beautifyTitleNoBreak(String title) {
        if (this.m_beautifyTitle) {
            return TextUtil.beautifyString((String)title, (String)"&nbsp;");
        }
        return title;
    }

    public boolean pageExists(String page) {
        Attachment att = null;
        try {
            if (this.m_commandResolver.getSpecialPageReference(page) != null) {
                return true;
            }
            if (this.getFinalPageName(page) != null) {
                return true;
            }
            att = this.getAttachmentManager().getAttachmentInfo((WikiContext)null, page);
        }
        catch (ProviderException e) {
            log.debug((Object)"pageExists() failed to find attachments", (Throwable)e);
        }
        return att != null;
    }

    public boolean pageExists(String page, int version) throws ProviderException {
        if (this.m_commandResolver.getSpecialPageReference(page) != null) {
            return true;
        }
        String finalName = this.getFinalPageName(page);
        boolean isThere = false;
        if (finalName != null) {
            isThere = this.m_pageManager.pageExists(finalName, version);
        }
        if (!isThere) {
            try {
                isThere = this.getAttachmentManager().getAttachmentInfo(null, page, version) != null;
            }
            catch (ProviderException e) {
                log.debug((Object)"pageExists() failed to find attachments", (Throwable)e);
            }
        }
        return isThere;
    }

    public boolean pageExists(WikiPage page) throws ProviderException {
        if (page != null) {
            return this.pageExists(page.getName(), page.getVersion());
        }
        return false;
    }

    public String getFinalPageName(String page) throws ProviderException {
        return this.m_commandResolver.getFinalPageName(page);
    }

    public String encodeName(String pagename) {
        try {
            return URLEncoder.encode(pagename, this.m_useUTF8 ? "UTF-8" : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalWikiException("ISO-8859-1 not a supported encoding!?!  Your platform is borked.", e);
        }
    }

    public String decodeName(String pagerequest) {
        try {
            return URLDecoder.decode(pagerequest, this.m_useUTF8 ? "UTF-8" : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalWikiException("ISO-8859-1 not a supported encoding!?!  Your platform is borked.", e);
        }
    }

    public Charset getContentEncoding() {
        if (this.m_useUTF8) {
            return StandardCharsets.UTF_8;
        }
        return StandardCharsets.ISO_8859_1;
    }

    public WorkflowManager getWorkflowManager() {
        return this.m_workflowMgr;
    }

    public String getText(String page) {
        return this.getText(page, -1);
    }

    public String getText(String page, int version) {
        String result = this.getPureText(page, version);
        result = TextUtil.replaceEntities((String)result);
        return result;
    }

    public String getText(WikiContext context, WikiPage page) {
        return this.getText(page.getName(), page.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPureText(String page, int version) {
        String result = null;
        try {
            result = this.m_pageManager.getPageText(page, version);
        }
        catch (ProviderException providerException) {
        }
        finally {
            if (result == null) {
                result = "";
            }
        }
        return result;
    }

    public String getPureText(WikiPage page) {
        return this.getPureText(page.getName(), page.getVersion());
    }

    public String getHTML(WikiContext context, WikiPage page) {
        String pagedata = null;
        pagedata = this.getPureText(page.getName(), page.getVersion());
        String res = this.textToHTML(context, pagedata);
        return res;
    }

    public String getHTML(String page) {
        return this.getHTML(page, -1);
    }

    public String getHTML(String pagename, int version) {
        WikiPage page = this.getPage(pagename, version);
        WikiContext context = new WikiContext(this, page);
        context.setRequestContext(WikiContext.NONE);
        String res = this.getHTML(context, page);
        return res;
    }

    public String textToHTML(WikiContext context, String pagedata) {
        String result = "";
        boolean runFilters = "true".equals(this.m_variableManager.getValue(context, PROP_RUNFILTERS, "true"));
        StopWatch sw = new StopWatch();
        sw.start();
        try {
            if (runFilters) {
                pagedata = this.m_filterManager.doPreTranslateFiltering(context, pagedata);
            }
            result = this.m_renderingManager.getHTML(context, pagedata);
            if (runFilters) {
                result = this.m_filterManager.doPostTranslateFiltering(context, result);
            }
        }
        catch (FilterException filterException) {
            // empty catch block
        }
        sw.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Page " + context.getRealPage().getName() + " rendered, took " + sw));
        }
        return result;
    }

    protected void shutdown() {
        this.fireEvent(1);
        this.m_filterManager.destroy();
    }

    public Collection<String> scanWikiLinks(WikiPage page, String pagedata) {
        LinkCollector localCollector = new LinkCollector();
        this.textToHTML(new WikiContext(this, page), pagedata, localCollector, null, localCollector, false, true);
        return localCollector.getLinks();
    }

    public String textToHTML(WikiContext context, String pagedata, StringTransmutator localLinkHook, StringTransmutator extLinkHook) {
        return this.textToHTML(context, pagedata, localLinkHook, extLinkHook, null, true, false);
    }

    public String textToHTML(WikiContext context, String pagedata, StringTransmutator localLinkHook, StringTransmutator extLinkHook, StringTransmutator attLinkHook) {
        return this.textToHTML(context, pagedata, localLinkHook, extLinkHook, attLinkHook, true, false);
    }

    private String textToHTML(WikiContext context, String pagedata, StringTransmutator localLinkHook, StringTransmutator extLinkHook, StringTransmutator attLinkHook, boolean parseAccessRules, boolean justParse) {
        String result = "";
        if (pagedata == null) {
            log.error((Object)"NULL pagedata to textToHTML()");
            return null;
        }
        boolean runFilters = "true".equals(this.m_variableManager.getValue(context, PROP_RUNFILTERS, "true"));
        try {
            StopWatch sw = new StopWatch();
            sw.start();
            if (runFilters && this.m_filterManager != null) {
                pagedata = this.m_filterManager.doPreTranslateFiltering(context, pagedata);
            }
            MarkupParser mp = this.m_renderingManager.getParser(context, pagedata);
            mp.addLocalLinkHook(localLinkHook);
            mp.addExternalLinkHook(extLinkHook);
            mp.addAttachmentLinkHook(attLinkHook);
            if (!parseAccessRules) {
                mp.disableAccessRules();
            }
            WikiDocument doc = mp.parse();
            if (!justParse) {
                result = this.m_renderingManager.getHTML(context, doc);
                if (runFilters && this.m_filterManager != null) {
                    result = this.m_filterManager.doPostTranslateFiltering(context, result);
                }
            }
            sw.stop();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Page " + context.getRealPage().getName() + " rendered, took " + sw));
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to scan page data: ", (Throwable)e);
        }
        catch (FilterException e) {
            log.error((Object)"page filter threw exception: ", (Throwable)e);
        }
        return result;
    }

    public void updateReferences(WikiPage page) {
        String pageData = this.getPureText(page.getName(), -1);
        this.m_referenceManager.updateReferences(page.getName(), this.scanWikiLinks(page, pageData));
    }

    public void saveText(WikiContext context, String text) throws WikiException {
        WikiPage page = context.getPage();
        String oldText = this.getPureText(page);
        String proposedText = TextUtil.normalizePostData((String)text);
        if (oldText != null && oldText.equals(proposedText)) {
            return;
        }
        boolean allowEmpty = TextUtil.getBooleanProperty((Properties)this.m_properties, (String)PROP_ALLOW_CREATION_OF_EMPTY_PAGES, (boolean)false);
        if (!allowEmpty && !this.pageExists(page) && text.trim().equals("")) {
            return;
        }
        WorkflowBuilder builder = WorkflowBuilder.getBuilder(this);
        Principal submitter = context.getCurrentUser();
        Step prepTask = this.m_tasksManager.buildPreSaveWikiPageTask(context, proposedText);
        Step completionTask = this.m_tasksManager.buildSaveWikiPageTask();
        String diffText = this.m_differenceManager.makeDiff(context, oldText, proposedText);
        boolean isAuthenticated = context.getWikiSession().isAuthenticated();
        Fact[] facts = new Fact[]{new Fact("fact.pageName", (Serializable)((Object)page.getName())), new Fact("fact.diffText", (Serializable)((Object)diffText)), new Fact("fact.proposedText", (Serializable)((Object)proposedText)), new Fact("fact.currentText", (Serializable)((Object)oldText)), new Fact("fact.isAuthenticated", Boolean.valueOf(isAuthenticated))};
        String rejectKey = isAuthenticated ? "notification.saveWikiPage.reject" : null;
        Workflow workflow = builder.buildApprovalWorkflow(submitter, "workflow.saveWikiPage", prepTask, "decision.saveWikiPage", facts, completionTask, rejectKey);
        this.m_workflowMgr.start(workflow);
        if (workflow.getCurrentStep() instanceof Decision) {
            throw new DecisionRequiredException("The page contents must be approved before they become active.");
        }
    }

    public int getPageCount() {
        return this.m_pageManager.getTotalPageCount();
    }

    public String getCurrentProvider() {
        return this.m_pageManager.getProvider().getClass().getName();
    }

    public String getCurrentProviderInfo() {
        return this.m_pageManager.getProviderDescription();
    }

    public Set<WikiPage> getRecentChanges() {
        try {
            Collection<WikiPage> pages = this.m_pageManager.getAllPages();
            Collection<Attachment> atts = this.m_attachmentManager.getAllAttachments();
            TreeSet<WikiPage> sortedPages = new TreeSet<WikiPage>(new PageTimeComparator());
            sortedPages.addAll(pages);
            sortedPages.addAll(atts);
            return sortedPages;
        }
        catch (ProviderException e) {
            log.error((Object)"Unable to fetch all pages: ", (Throwable)e);
            return null;
        }
    }

    public WikiPage getPage(String pagereq) {
        return this.getPage(pagereq, -1);
    }

    public WikiPage getPage(String pagereq, int version) {
        try {
            WikiPage p = this.m_pageManager.getPageInfo(pagereq, version);
            if (p == null) {
                p = this.m_attachmentManager.getAttachmentInfo((WikiContext)null, pagereq);
            }
            return p;
        }
        catch (ProviderException e) {
            log.error((Object)"Unable to fetch page info", (Throwable)e);
            return null;
        }
    }

    public List<? extends WikiPage> getVersionHistory(String page) {
        List<WikiPage> c = null;
        try {
            c = this.m_pageManager.getVersionHistory(page);
            if (c == null) {
                c = this.m_attachmentManager.getVersionHistory(page);
            }
        }
        catch (ProviderException e) {
            log.error((Object)"FIXME", (Throwable)e);
        }
        return c;
    }

    public String getDiff(WikiContext context, int version1, int version2) {
        String page = context.getPage().getName();
        String page1 = this.getPureText(page, version1);
        String page2 = this.getPureText(page, version2);
        if (version1 == -1) {
            page1 = "";
        }
        String diff = this.m_differenceManager.makeDiff(context, page1, page2);
        return diff;
    }

    public ReferenceManager getReferenceManager() {
        return this.m_referenceManager;
    }

    public RenderingManager getRenderingManager() {
        return this.m_renderingManager;
    }

    public <T extends PluginManager> T getPluginManager() {
        return (T)this.m_pluginManager;
    }

    public VariableManager getVariableManager() {
        return this.m_variableManager;
    }

    public String getVariable(WikiContext context, String name) {
        try {
            return this.m_variableManager.getValue(context, name);
        }
        catch (NoSuchVariableException e) {
            return null;
        }
    }

    public String getRequiredProperty(Properties props, String key) throws NoRequiredPropertyException {
        String value = TextUtil.getStringProperty((Properties)props, (String)key, null);
        if (value == null) {
            throw new NoRequiredPropertyException("Required property not found", key);
        }
        return value;
    }

    public PageManager getPageManager() {
        return this.m_pageManager;
    }

    public CommandResolver getCommandResolver() {
        return this.m_commandResolver;
    }

    public AttachmentManager getAttachmentManager() {
        return this.m_attachmentManager;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.m_authorizationManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.m_authenticationManager;
    }

    public <T extends FilterManager> T getFilterManager() {
        return (T)this.m_filterManager;
    }

    public SearchManager getSearchManager() {
        return this.m_searchManager;
    }

    public ProgressManager getProgressManager() {
        return this.m_progressManager;
    }

    public String getRedirectURL(WikiContext context) {
        return context.getRedirectURL();
    }

    public WikiContext createContext(HttpServletRequest request, String requestContext) {
        if (!this.m_isConfigured) {
            throw new InternalWikiException("WikiEngine has not been properly started.  It is likely that the configuration is faulty.  Please check all logs for the possible reason.");
        }
        Command command = this.m_commandResolver.findCommand(request, requestContext);
        return new WikiContext(this, request, command);
    }

    public void deletePage(String pageName) throws ProviderException {
        WikiPage p = this.getPage(pageName);
        if (p != null) {
            if (p instanceof Attachment) {
                this.m_attachmentManager.deleteAttachment((Attachment)p);
            } else {
                Collection<String> refTo = this.m_referenceManager.findRefersTo(pageName);
                if (this.m_attachmentManager.hasAttachments(p)) {
                    List<Attachment> attachments = this.m_attachmentManager.listAttachments(p);
                    for (Attachment attachment : attachments) {
                        if (refTo != null) {
                            refTo.remove(attachment.getName());
                        }
                        this.m_attachmentManager.deleteAttachment(attachment);
                    }
                }
                this.m_pageManager.deletePage(p);
                this.firePageEvent(27, pageName);
            }
        }
    }

    public void deleteVersion(WikiPage page) throws ProviderException {
        if (page instanceof Attachment) {
            this.m_attachmentManager.deleteVersion((Attachment)page);
        } else {
            this.m_pageManager.deleteVersion(page);
        }
    }

    public String getGlobalRSSURL() {
        if (this.m_rssGenerator != null && this.m_rssGenerator.isEnabled()) {
            return this.getBaseURL() + "/" + this.m_rssFile;
        }
        return null;
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public URLConstructor getURLConstructor() {
        return this.m_urlConstructor;
    }

    public RSSGenerator getRSSGenerator() {
        return this.m_rssGenerator;
    }

    public String renamePage(WikiContext context, String renameFrom, String renameTo, boolean changeReferrers) throws WikiException {
        String newPageName = this.m_pageRenamer.renamePage(context, renameFrom, renameTo, changeReferrers);
        this.firePageRenameEvent(renameFrom, newPageName);
        return newPageName;
    }

    public PageRenamer getPageRenamer() {
        return this.m_pageRenamer;
    }

    public UserManager getUserManager() {
        return this.m_userManager;
    }

    public TasksManager getTasksManager() {
        return this.m_tasksManager;
    }

    public GroupManager getGroupManager() {
        return this.m_groupManager;
    }

    public AdminBeanManager getAdminBeanManager() {
        return this.m_adminBeanManager;
    }

    public AclManager getAclManager() {
        if (this.m_aclManager == null) {
            try {
                String s = this.m_properties.getProperty(PROP_ACL_MANAGER_IMPL, ClassUtil.getMappedClass((String)AclManager.class.getName()).getName());
                this.m_aclManager = (AclManager)ClassUtil.getMappedObject((String)s);
                this.m_aclManager.initialize(this, this.m_properties);
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                log.fatal((Object)("unable to instantiate class for AclManager: " + e.getMessage()));
                throw new InternalWikiException("Cannot instantiate AclManager, please check logs.", e);
            }
        }
        return this.m_aclManager;
    }

    public DifferenceManager getDifferenceManager() {
        return this.m_differenceManager;
    }

    public EditorManager getEditorManager() {
        return this.m_editorManager;
    }

    public InternationalizationManager getInternationalizationManager() {
        return this.m_internationalizationManager;
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiEngineEvent(this, type));
        }
    }

    protected final void firePageEvent(int type, String pageName) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiPageEvent(this, type, pageName));
        }
    }

    protected final void firePageRenameEvent(String oldName, String newName) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiPageRenameEvent((Object)this, oldName, newName));
        }
    }

    public void setAttribute(String key, Object value) {
        this.m_attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.m_attributes.get(key);
    }

    public Object removeAttribute(String key) {
        return this.m_attributes.remove(key);
    }

    public WatchDog getCurrentWatchDog() {
        return WatchDog.getCurrentWatchDog(this);
    }
}

