/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.CacheManager;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.url.DefaultURLConstructor;

public class WikiServlet
extends HttpServlet {
    private static final long serialVersionUID = 3258410651167633973L;
    private WikiEngine m_engine;
    static final Logger log = Logger.getLogger((String)WikiServlet.class.getName());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_engine = WikiEngine.getInstance(config);
        log.info((Object)"WikiServlet initialized.");
    }

    public void destroy() {
        log.info((Object)"WikiServlet shutdown.");
        CacheManager.getInstance().shutdown();
        this.m_engine.shutdown();
        super.destroy();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String pageName = DefaultURLConstructor.parsePageFromURL(req, this.m_engine.getContentEncoding());
        log.info((Object)("Request for page: " + pageName));
        if (pageName == null) {
            pageName = this.m_engine.getFrontPage();
        }
        String jspPage = this.m_engine.getURLConstructor().getForwardPage(req);
        RequestDispatcher dispatcher = req.getRequestDispatcher("/" + jspPage + "?page=" + this.m_engine.encodeName(pageName) + "&" + req.getQueryString());
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
    }
}

