/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.security.AccessControlException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.GroupPrincipal;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.SessionMonitor;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.authorize.Group;
import org.apache.wiki.auth.authorize.GroupManager;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiSecurityEvent;

public final class WikiSession
implements WikiEventListener {
    public static final String ANONYMOUS = "anonymous";
    public static final String ASSERTED = "asserted";
    public static final String AUTHENTICATED = "authenticated";
    private static final int ONE = 48;
    private static final int NINE = 57;
    private static final int DOT = 46;
    private static final Logger log = Logger.getLogger(WikiSession.class);
    private static final String ALL = "*";
    private static ThreadLocal<WikiSession> c_guestSession = new ThreadLocal();
    private final Subject m_subject = new Subject();
    private final Map<String, Set<String>> m_messages = new HashMap<String, Set<String>>();
    private WikiEngine m_engine = null;
    private String m_status = "anonymous";
    private Principal m_userPrincipal = WikiPrincipal.GUEST;
    private Principal m_loginPrincipal = WikiPrincipal.GUEST;
    private Locale m_cachedLocale = Locale.getDefault();

    protected boolean isInGroup(Group group) {
        for (Principal principal : this.getPrincipals()) {
            if (!this.isAuthenticated() || !group.isMember(principal)) continue;
            return true;
        }
        return false;
    }

    private WikiSession() {
    }

    public boolean isAsserted() {
        return this.m_subject.getPrincipals().contains(Role.ASSERTED);
    }

    public boolean isAuthenticated() {
        if (this.m_subject.getPrincipals().contains(Role.AUTHENTICATED)) {
            return true;
        }
        if (!this.isAnonymous() && !this.isAsserted()) {
            this.m_subject.getPrincipals().add(Role.AUTHENTICATED);
            return true;
        }
        return false;
    }

    public boolean isAnonymous() {
        Set<Principal> principals = this.m_subject.getPrincipals();
        return principals.contains(Role.ANONYMOUS) || principals.contains(WikiPrincipal.GUEST) || WikiSession.isIPV4Address(this.getUserPrincipal().getName());
    }

    public Principal getLoginPrincipal() {
        return this.m_loginPrincipal;
    }

    public Principal getUserPrincipal() {
        return this.m_userPrincipal;
    }

    public Locale getLocale() {
        return this.m_cachedLocale;
    }

    public void addMessage(String message) {
        this.addMessage(ALL, message);
    }

    public void addMessage(String topic, String message) {
        if (topic == null) {
            throw new IllegalArgumentException("addMessage: topic cannot be null.");
        }
        Set<String> messages = this.m_messages.get(topic);
        if (messages == null) {
            messages = new LinkedHashSet<String>();
            this.m_messages.put(topic, messages);
        }
        messages.add(StringUtils.defaultString((String)message));
    }

    public void clearMessages() {
        this.m_messages.clear();
    }

    public void clearMessages(String topic) {
        Set<String> messages = this.m_messages.get(topic);
        if (messages != null) {
            this.m_messages.clear();
        }
    }

    public String[] getMessages() {
        return this.getMessages(ALL);
    }

    public String[] getMessages(String topic) {
        Set<String> messages = this.m_messages.get(topic);
        if (messages == null || messages.size() == 0) {
            return new String[0];
        }
        return messages.toArray(new String[messages.size()]);
    }

    public Principal[] getPrincipals() {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        for (Principal principal : this.m_subject.getPrincipals()) {
            if (!AuthenticationManager.isUserPrincipal(principal)) continue;
            principals.add(principal);
        }
        return principals.toArray(new Principal[principals.size()]);
    }

    public Principal[] getRoles() {
        HashSet<Principal> roles = new HashSet<Principal>();
        roles.addAll(this.m_subject.getPrincipals(Role.class));
        roles.addAll(this.m_subject.getPrincipals(GroupPrincipal.class));
        Principal[] roleArray = roles.toArray(new Principal[roles.size()]);
        Arrays.sort(roleArray, WikiPrincipal.COMPARATOR);
        return roleArray;
    }

    public static void removeWikiSession(WikiEngine engine, HttpServletRequest request) {
        if (engine == null || request == null) {
            throw new IllegalArgumentException("Request or engine cannot be null.");
        }
        SessionMonitor monitor = SessionMonitor.getInstance(engine);
        monitor.remove(request.getSession());
    }

    public boolean hasPrincipal(Principal principal) {
        return this.m_subject.getPrincipals().contains(principal);
    }

    @Override
    public void actionPerformed(WikiEvent event) {
        WikiSecurityEvent e;
        if (event instanceof WikiSecurityEvent && (e = (WikiSecurityEvent)event).getTarget() != null) {
            switch (e.getType()) {
                case 46: {
                    Group group = (Group)e.getTarget();
                    if (!this.isInGroup(group)) break;
                    this.m_subject.getPrincipals().add(group.getPrincipal());
                    break;
                }
                case 47: {
                    Group group = (Group)e.getTarget();
                    if (!this.m_subject.getPrincipals().contains(group.getPrincipal())) break;
                    this.m_subject.getPrincipals().remove(group.getPrincipal());
                    break;
                }
                case 48: {
                    this.m_subject.getPrincipals().removeAll(this.m_subject.getPrincipals(GroupPrincipal.class));
                    break;
                }
                case 30: {
                    break;
                }
                case 35: {
                    WikiSession target = (WikiSession)e.getTarget();
                    if (!this.equals(target) || this.m_status != AUTHENTICATED) break;
                    Set<Principal> principals = this.m_subject.getPrincipals();
                    principals.add((Principal)e.getPrincipal());
                    break;
                }
                case 31: {
                    WikiSession target = (WikiSession)e.getTarget();
                    if (!this.equals(target)) break;
                    this.m_status = ANONYMOUS;
                    Set<Principal> principals = this.m_subject.getPrincipals();
                    this.m_userPrincipal = this.m_loginPrincipal = (Principal)e.getPrincipal();
                    principals.clear();
                    principals.add(this.m_loginPrincipal);
                    principals.add(Role.ALL);
                    principals.add(Role.ANONYMOUS);
                    break;
                }
                case 32: {
                    WikiSession target = (WikiSession)e.getTarget();
                    if (!this.equals(target)) break;
                    this.m_status = ASSERTED;
                    Set<Principal> principals = this.m_subject.getPrincipals();
                    this.m_userPrincipal = this.m_loginPrincipal = (Principal)e.getPrincipal();
                    principals.clear();
                    principals.add(this.m_loginPrincipal);
                    principals.add(Role.ALL);
                    principals.add(Role.ASSERTED);
                    break;
                }
                case 40: {
                    WikiSession target = (WikiSession)e.getTarget();
                    if (!this.equals(target)) break;
                    this.m_status = AUTHENTICATED;
                    Set<Principal> principals = this.m_subject.getPrincipals();
                    this.m_userPrincipal = this.m_loginPrincipal = (Principal)e.getPrincipal();
                    principals.clear();
                    principals.add(this.m_loginPrincipal);
                    principals.add(Role.ALL);
                    principals.add(Role.AUTHENTICATED);
                    this.injectUserProfilePrincipals();
                    this.injectGroupPrincipals();
                    break;
                }
                case 53: {
                    WikiSession source = (WikiSession)e.getSrc();
                    if (!this.equals(source)) break;
                    this.injectUserProfilePrincipals();
                    this.injectGroupPrincipals();
                    break;
                }
                case 54: {
                    WikiSession source = (WikiSession)e.getSrc();
                    if (!this.equals(source) || this.m_status != AUTHENTICATED) break;
                    UserProfile[] profiles = (UserProfile[])e.getTarget();
                    UserProfile newProfile = profiles[1];
                    if (newProfile.getFullname() == null) {
                        throw new IllegalStateException("User profile FullName cannot be null.");
                    }
                    Set<Principal> principals = this.m_subject.getPrincipals();
                    this.m_loginPrincipal = new WikiPrincipal(newProfile.getLoginName());
                    principals.clear();
                    principals.add(this.m_loginPrincipal);
                    principals.add(Role.ALL);
                    principals.add(Role.AUTHENTICATED);
                    this.injectUserProfilePrincipals();
                    this.injectGroupPrincipals();
                    break;
                }
            }
        }
    }

    public void invalidate() {
        this.m_subject.getPrincipals().clear();
        this.m_subject.getPrincipals().add(WikiPrincipal.GUEST);
        this.m_subject.getPrincipals().add(Role.ANONYMOUS);
        this.m_subject.getPrincipals().add(Role.ALL);
        this.m_userPrincipal = WikiPrincipal.GUEST;
        this.m_loginPrincipal = WikiPrincipal.GUEST;
    }

    protected void injectGroupPrincipals() {
        this.m_subject.getPrincipals().removeAll(this.m_subject.getPrincipals(GroupPrincipal.class));
        GroupManager manager = this.m_engine.getGroupManager();
        for (Principal group : manager.getRoles()) {
            if (!manager.isUserInRole(this, group)) continue;
            this.m_subject.getPrincipals().add(group);
        }
    }

    protected void injectUserProfilePrincipals() {
        String searchId = this.m_loginPrincipal.getName();
        if (searchId == null) {
            log.info((Object)"Refresh principals failed because WikiSession had no user Principal; maybe not logged in?");
            return;
        }
        UserDatabase database = this.m_engine.getUserManager().getUserDatabase();
        if (database == null) {
            throw new IllegalStateException("User database cannot be null.");
        }
        try {
            Principal[] principals;
            UserProfile profile = database.find(searchId);
            for (Principal principal : principals = database.getPrincipals(profile.getLoginName())) {
                boolean isFullNamePrincipal;
                this.m_subject.getPrincipals().add(principal);
                boolean bl = isFullNamePrincipal = principal instanceof WikiPrincipal && ((WikiPrincipal)principal).getType() == "fullName";
                if (isFullNamePrincipal) {
                    this.m_userPrincipal = principal;
                    continue;
                }
                if (this.m_userPrincipal instanceof WikiPrincipal) continue;
                this.m_userPrincipal = principal;
            }
        }
        catch (NoSuchPrincipalException e) {
            log.warn((Object)("User profile '" + searchId + "' not found. This is normal for container-auth users who haven't set up a profile yet."));
        }
    }

    public String getStatus() {
        return this.m_status;
    }

    public static WikiSession getWikiSession(WikiEngine engine, HttpServletRequest request) {
        if (request == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Looking up WikiSession for NULL HttpRequest: returning guestSession()");
            }
            return WikiSession.staticGuestSession(engine);
        }
        HttpSession session = request.getSession();
        SessionMonitor monitor = SessionMonitor.getInstance(engine);
        WikiSession wikiSession = monitor.find(session);
        wikiSession.m_engine = engine;
        wikiSession.m_cachedLocale = request.getLocale();
        return wikiSession;
    }

    public static WikiSession guestSession(WikiEngine engine) {
        WikiSession session = new WikiSession();
        session.m_engine = engine;
        session.invalidate();
        GroupManager groupMgr = engine.getGroupManager();
        AuthenticationManager authMgr = engine.getAuthenticationManager();
        UserManager userMgr = engine.getUserManager();
        groupMgr.addWikiEventListener(session);
        authMgr.addWikiEventListener(session);
        userMgr.addWikiEventListener(session);
        return session;
    }

    private static WikiSession staticGuestSession(WikiEngine engine) {
        WikiSession session = c_guestSession.get();
        if (session == null) {
            session = WikiSession.guestSession(engine);
            c_guestSession.set(session);
        }
        return session;
    }

    public static int sessions(WikiEngine engine) {
        SessionMonitor monitor = SessionMonitor.getInstance(engine);
        return monitor.sessions();
    }

    public static Principal[] userPrincipals(WikiEngine engine) {
        SessionMonitor monitor = SessionMonitor.getInstance(engine);
        return monitor.userPrincipals();
    }

    public static Object doPrivileged(WikiSession session, PrivilegedAction<?> action) throws AccessControlException {
        return Subject.doAsPrivileged(session.m_subject, action, null);
    }

    protected static boolean isIPV4Address(String name) {
        if (name.charAt(0) == '.' || name.charAt(name.length() - 1) == '.') {
            return false;
        }
        int[] addr = new int[]{0, 0, 0, 0};
        int currentOctet = 0;
        for (int i = 0; i < name.length(); ++i) {
            boolean isDot;
            char ch = name.charAt(i);
            boolean isDigit = ch >= '0' && ch <= '9';
            boolean bl = isDot = ch == '.';
            if (!isDigit && !isDot) {
                return false;
            }
            if (isDigit) {
                addr[currentOctet] = 10 * addr[currentOctet] + (ch - 48);
                if (addr[currentOctet] <= 255) continue;
                return false;
            }
            if (name.charAt(i - 1) == '.') {
                return false;
            }
            ++currentOctet;
        }
        return currentOctet == 3;
    }
}

