/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.Authorizer;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.acl.Acl;
import org.apache.wiki.auth.acl.AclEntry;
import org.apache.wiki.auth.acl.UnresolvedPrincipal;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.auth.permissions.AllPermission;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.ClassUtil;
import org.freshcookies.security.policy.LocalPolicy;

public class AuthorizationManager {
    private static final Logger log = Logger.getLogger(AuthorizationManager.class);
    public static final String DEFAULT_AUTHORIZER = "org.apache.wiki.auth.authorize.WebContainerAuthorizer";
    protected static final String POLICY = "jspwiki.policy.file";
    protected static final String DEFAULT_POLICY = "jspwiki.policy";
    public static final String PROP_AUTHORIZER = "jspwiki.authorizer";
    private Authorizer m_authorizer = null;
    private Map<Principal, ProtectionDomain> m_cachedPds = new WeakHashMap<Principal, ProtectionDomain>();
    private WikiEngine m_engine = null;
    private LocalPolicy m_localPolicy = null;

    public boolean checkPermission(WikiSession session, Permission permission) {
        Acl acl;
        if (session == null || permission == null) {
            this.fireEvent(52, null, permission);
            return false;
        }
        Principal user = session.getLoginPrincipal();
        AllPermission allPermission = new AllPermission(this.m_engine.getApplicationName());
        boolean hasAllPermission = this.checkStaticPermission(session, allPermission);
        if (hasAllPermission) {
            this.fireEvent(51, user, permission);
            return true;
        }
        boolean hasPolicyPermission = this.checkStaticPermission(session, permission);
        if (!hasPolicyPermission) {
            this.fireEvent(52, user, permission);
            return false;
        }
        if (!(permission instanceof PagePermission)) {
            this.fireEvent(51, user, permission);
            return true;
        }
        String pageName = ((PagePermission)permission).getPage();
        WikiPage page = this.m_engine.getPage(pageName);
        Acl acl2 = acl = page == null ? null : this.m_engine.getAclManager().getPermissions(page);
        if (page == null || acl == null || acl.isEmpty()) {
            this.fireEvent(51, user, permission);
            return true;
        }
        Object[] aclPrincipals = acl.findPrincipals(permission);
        log.debug((Object)"Checking ACL entries...");
        log.debug((Object)("Acl for this page is: " + acl));
        log.debug((Object)("Checking for principal: " + Arrays.toString(aclPrincipals)));
        log.debug((Object)("Permission: " + permission));
        for (Object aclPrincipal : aclPrincipals) {
            if (aclPrincipal instanceof UnresolvedPrincipal) {
                AclEntry aclEntry = acl.getEntry((Principal)aclPrincipal);
                aclPrincipal = this.resolvePrincipal(aclPrincipal.getName());
                if (aclEntry != null && !(aclPrincipal instanceof UnresolvedPrincipal)) {
                    aclEntry.setPrincipal((Principal)aclPrincipal);
                }
            }
            if (!this.hasRoleOrPrincipal(session, (Principal)aclPrincipal)) continue;
            this.fireEvent(51, user, permission);
            return true;
        }
        this.fireEvent(52, user, permission);
        return false;
    }

    public boolean isUserInRole(WikiSession session, Principal principal) {
        if (session == null || principal == null || AuthenticationManager.isUserPrincipal(principal)) {
            return false;
        }
        if (principal instanceof Role && Role.isBuiltInRole((Role)principal)) {
            return session.hasPrincipal(principal);
        }
        if (session.isAuthenticated() && AuthenticationManager.isRolePrincipal(principal)) {
            return session.hasPrincipal(principal);
        }
        return false;
    }

    public Authorizer getAuthorizer() throws WikiSecurityException {
        if (this.m_authorizer != null) {
            return this.m_authorizer;
        }
        throw new WikiSecurityException("Authorizer did not initialize properly. Check the logs.");
    }

    protected boolean hasRoleOrPrincipal(WikiSession session, Principal principal) {
        if (session == null || principal == null) {
            return false;
        }
        if (AuthenticationManager.isRolePrincipal(principal)) {
            return this.isUserInRole(session, principal);
        }
        if (session.isAuthenticated() && AuthenticationManager.isUserPrincipal(principal)) {
            Principal[] userPrincipals;
            String principalName = principal.getName();
            for (Principal userPrincipal : userPrincipals = session.getPrincipals()) {
                if (!userPrincipal.getName().equals(principalName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAccess(WikiContext context, HttpServletResponse response) throws IOException {
        return this.hasAccess(context, response, true);
    }

    public boolean hasAccess(WikiContext context, HttpServletResponse response, boolean redirect) throws IOException {
        boolean allowed = this.checkPermission(context.getWikiSession(), context.requiredPermission());
        ResourceBundle rb = Preferences.getBundle(context, "CoreResources");
        if (context.getHttpRequest() != null && context.getHttpRequest().getAttribute("jspwiki.context") == null) {
            context.getHttpRequest().setAttribute("jspwiki.context", (Object)context);
        }
        if (!allowed && redirect) {
            Principal currentUser = context.getWikiSession().getUserPrincipal();
            String pageurl = context.getPage().getName();
            if (context.getWikiSession().isAuthenticated()) {
                log.info((Object)("User " + currentUser.getName() + " has no access - forbidden (permission=" + context.requiredPermission() + ")"));
                context.getWikiSession().addMessage(MessageFormat.format(rb.getString("security.error.noaccess.logged"), context.getName()));
            } else {
                log.info((Object)("User " + currentUser.getName() + " has no access - redirecting (permission=" + context.requiredPermission() + ")"));
                context.getWikiSession().addMessage(MessageFormat.format(rb.getString("security.error.noaccess"), context.getName()));
            }
            response.sendRedirect(this.m_engine.getURL(WikiContext.LOGIN, pageurl, null, false));
        }
        return allowed;
    }

    public void initialize(WikiEngine engine, Properties properties) throws WikiException {
        this.m_engine = engine;
        this.m_authorizer = this.getAuthorizerImplementation(properties);
        this.m_authorizer.initialize(engine, properties);
        try {
            String policyFileName = properties.getProperty(POLICY, DEFAULT_POLICY);
            URL policyURL = AuthenticationManager.findConfigFile(engine, policyFileName);
            if (policyURL == null) {
                String sb = "JSPWiki was unable to initialize the default security policy (WEB-INF/jspwiki.policy) file. Please ensure that the jspwiki.policy file exists in the default location. This file should exist regardless of the existance of a global policy file. The global policy file is identified by the java.security.policy variable. ";
                WikiSecurityException wse = new WikiSecurityException("JSPWiki was unable to initialize the default security policy (WEB-INF/jspwiki.policy) file. Please ensure that the jspwiki.policy file exists in the default location. This file should exist regardless of the existance of a global policy file. The global policy file is identified by the java.security.policy variable. ");
                log.fatal((Object)"JSPWiki was unable to initialize the default security policy (WEB-INF/jspwiki.policy) file. Please ensure that the jspwiki.policy file exists in the default location. This file should exist regardless of the existance of a global policy file. The global policy file is identified by the java.security.policy variable. ", (Throwable)wse);
                throw wse;
            }
            File policyFile = new File(policyURL.toURI().getPath());
            log.info((Object)("We found security policy URL: " + policyURL + " and transformed it to file " + policyFile.getAbsolutePath()));
            this.m_localPolicy = new LocalPolicy(policyFile, engine.getContentEncoding().displayName());
            this.m_localPolicy.refresh();
            log.info((Object)("Initialized default security policy: " + policyFile.getAbsolutePath()));
        }
        catch (Exception e) {
            log.error((Object)("Could not initialize local security policy: " + e.getMessage()));
            throw new WikiException("Could not initialize local security policy: " + e.getMessage(), e);
        }
    }

    private Authorizer getAuthorizerImplementation(Properties props) throws WikiException {
        String authClassName = props.getProperty(PROP_AUTHORIZER, DEFAULT_AUTHORIZER);
        return (Authorizer)this.locateImplementation(authClassName);
    }

    private Object locateImplementation(String clazz) throws WikiException {
        if (clazz != null) {
            try {
                Class authClass = ClassUtil.findClass((String)"org.apache.wiki.auth.authorize", (String)clazz);
                Object impl = authClass.newInstance();
                return impl;
            }
            catch (ClassNotFoundException e) {
                log.fatal((Object)("Authorizer " + clazz + " cannot be found"), (Throwable)e);
                throw new WikiException("Authorizer " + clazz + " cannot be found", e);
            }
            catch (InstantiationException e) {
                log.fatal((Object)("Authorizer " + clazz + " cannot be created"), (Throwable)e);
                throw new WikiException("Authorizer " + clazz + " cannot be created", e);
            }
            catch (IllegalAccessException e) {
                log.fatal((Object)"You are not allowed to access this authorizer class", (Throwable)e);
                throw new WikiException("You are not allowed to access this authorizer class", e);
            }
        }
        throw new NoRequiredPropertyException("Unable to find a jspwiki.authorizer entry in the properties.", PROP_AUTHORIZER);
    }

    protected boolean allowedByLocalPolicy(Principal[] principals, Permission permission) {
        for (Principal principal : principals) {
            ProtectionDomain pd = this.m_cachedPds.get(principal);
            if (pd == null) {
                ClassLoader cl = this.getClass().getClassLoader();
                CodeSource cs = new CodeSource(null, (Certificate[])null);
                pd = new ProtectionDomain(cs, null, cl, new Principal[]{principal});
                this.m_cachedPds.put(principal, pd);
            }
            if (!this.m_localPolicy.implies(pd, permission)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkStaticPermission(final WikiSession session, final Permission permission) {
        Boolean allowed = (Boolean)WikiSession.doPrivileged(session, new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    AccessController.checkPermission(permission);
                    return Boolean.TRUE;
                }
                catch (AccessControlException accessControlException) {
                    if (AuthorizationManager.this.allowedByLocalPolicy(session.getRoles(), permission) || AuthorizationManager.this.allowedByLocalPolicy(session.getPrincipals(), permission)) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            }
        });
        return allowed;
    }

    public Principal resolvePrincipal(String name) {
        Role role = new Role(name);
        if (Role.isBuiltInRole(role)) {
            return role;
        }
        Principal principal = this.m_authorizer.findRole(name);
        if (principal != null) {
            return principal;
        }
        principal = this.m_engine.getGroupManager().findRole(name);
        if (principal != null) {
            return principal;
        }
        Principal[] principals = null;
        UserProfile profile = null;
        UserDatabase db = this.m_engine.getUserManager().getUserDatabase();
        try {
            profile = db.find(name);
            principals = db.getPrincipals(profile.getLoginName());
            for (int i = 0; i < principals.length; ++i) {
                principal = principals[i];
                if (!principal.getName().equals(name)) continue;
                return principal;
            }
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        return new UnresolvedPrincipal(name);
    }

    public synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected void fireEvent(int type, Principal user, Object permission) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent(this, type, user, permission));
        }
    }
}

