/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.ajax.AjaxUtil;
import org.apache.wiki.ajax.WikiAjaxDispatcherServlet;
import org.apache.wiki.ajax.WikiAjaxServlet;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.api.filters.PageFilter;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.permissions.AllPermission;
import org.apache.wiki.auth.permissions.WikiPermission;
import org.apache.wiki.auth.user.AbstractUserDatabase;
import org.apache.wiki.auth.user.DuplicateUserException;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.filters.SpamFilter;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.ui.InputValidator;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.workflow.Decision;
import org.apache.wiki.workflow.DecisionRequiredException;
import org.apache.wiki.workflow.Fact;
import org.apache.wiki.workflow.Step;
import org.apache.wiki.workflow.Workflow;
import org.apache.wiki.workflow.WorkflowBuilder;

public class UserManager {
    private static final String USERDATABASE_PACKAGE = "org.apache.wiki.auth.user";
    private static final String SESSION_MESSAGES = "profile";
    private static final String PARAM_EMAIL = "email";
    private static final String PARAM_FULLNAME = "fullname";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_LOGINNAME = "loginname";
    private static final String UNKNOWN_CLASS = "<unknown>";
    private WikiEngine m_engine;
    private static final Logger log = Logger.getLogger(UserManager.class);
    private static final String PROP_DATABASE = "jspwiki.userdatabase";
    public static final String JSON_USERS = "users";
    private final Map<WikiSession, UserProfile> m_profiles = new WeakHashMap<WikiSession, UserProfile>();
    private UserDatabase m_database;

    public void initialize(WikiEngine engine, Properties props) {
        this.m_engine = engine;
        this.addWikiEventListener(engine.getPageManager());
        WikiAjaxDispatcherServlet.registerServlet(JSON_USERS, new JSONUserModule(this), new AllPermission(null));
    }

    public UserDatabase getUserDatabase() {
        if (this.m_database != null) {
            return this.m_database;
        }
        String dbClassName = UNKNOWN_CLASS;
        try {
            dbClassName = this.m_engine.getRequiredProperty(this.m_engine.getWikiProperties(), PROP_DATABASE);
            log.info((Object)("Attempting to load user database class " + dbClassName));
            Class dbClass = ClassUtil.findClass((String)USERDATABASE_PACKAGE, (String)dbClassName);
            this.m_database = (UserDatabase)dbClass.newInstance();
            this.m_database.initialize(this.m_engine, this.m_engine.getWikiProperties());
            log.info((Object)"UserDatabase initialized.");
        }
        catch (NoRequiredPropertyException e) {
            log.error((Object)"You have not set the 'jspwiki.userdatabase'. You need to do this if you want to enable user management by JSPWiki.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("UserDatabase class " + dbClassName + " cannot be found"), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)("UserDatabase class " + dbClassName + " cannot be created"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"You are not allowed to access this user database class", (Throwable)e);
        }
        catch (WikiSecurityException e) {
            log.error((Object)("Exception initializing user database: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (this.m_database == null) {
                log.info((Object)"I could not create a database object you specified (or didn't specify), so I am falling back to a default.");
                this.m_database = new DummyUserDatabase();
            }
        }
        return this.m_database;
    }

    public UserProfile getUserProfile(WikiSession session) {
        UserProfile profile = this.m_profiles.get(session);
        boolean newProfile = profile == null;
        Principal user = null;
        if (session.isAuthenticated()) {
            user = session.getUserPrincipal();
            try {
                profile = this.getUserDatabase().find(user.getName());
                newProfile = false;
            }
            catch (NoSuchPrincipalException noSuchPrincipalException) {
                // empty catch block
            }
        }
        if (newProfile) {
            profile = this.getUserDatabase().newProfile();
            if (user != null) {
                profile.setLoginName(user.getName());
            }
            if (!profile.isNew()) {
                throw new IllegalStateException("New profile should be marked 'new'. Check your UserProfile implementation.");
            }
        }
        this.m_profiles.put(session, profile);
        return profile;
    }

    public void setUserProfile(WikiSession session, UserProfile profile) throws DuplicateUserException, WikiException {
        UserProfile otherProfile;
        WikiPermission p = new WikiPermission(this.m_engine.getApplicationName(), "editProfile");
        if (!this.m_engine.getAuthorizationManager().checkPermission(session, p)) {
            throw new WikiSecurityException("You are not allowed to save wiki profiles.");
        }
        boolean newProfile = profile.isNew();
        UserProfile oldProfile = this.getUserProfile(session);
        boolean nameChanged = oldProfile == null || oldProfile.getFullname() == null ? false : !oldProfile.getFullname().equals(profile.getFullname()) || !oldProfile.getLoginName().equals(profile.getLoginName());
        try {
            otherProfile = this.getUserDatabase().findByLoginName(profile.getLoginName());
            if (otherProfile != null && !otherProfile.equals(oldProfile)) {
                throw new DuplicateUserException("security.error.login.taken", profile.getLoginName());
            }
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        try {
            otherProfile = this.getUserDatabase().findByFullName(profile.getFullname());
            if (otherProfile != null && !otherProfile.equals(oldProfile)) {
                throw new DuplicateUserException("security.error.fullname.taken", profile.getFullname());
            }
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        if (newProfile && oldProfile != null && oldProfile.isNew()) {
            this.startUserProfileCreationWorkflow(session, profile);
            try {
                AuthenticationManager mgr = this.m_engine.getAuthenticationManager();
                if (newProfile && !mgr.isContainerAuthenticated()) {
                    mgr.login(session, null, profile.getLoginName(), profile.getPassword());
                }
            }
            catch (WikiException e) {
                throw new WikiSecurityException(e.getMessage(), e);
            }
            this.fireEvent(53, session, profile);
        } else {
            if (nameChanged && oldProfile != null && !oldProfile.getLoginName().equals(profile.getLoginName())) {
                this.getUserDatabase().rename(oldProfile.getLoginName(), profile.getLoginName());
            }
            this.getUserDatabase().save(profile);
            if (nameChanged) {
                UserProfile[] profiles = new UserProfile[]{oldProfile, profile};
                this.fireEvent(54, session, profiles);
            } else {
                this.fireEvent(53, session, profile);
            }
        }
    }

    public void startUserProfileCreationWorkflow(WikiSession session, UserProfile profile) throws WikiException {
        WorkflowBuilder builder = WorkflowBuilder.getBuilder(this.m_engine);
        Principal submitter = session.getUserPrincipal();
        Step completionTask = this.m_engine.getTasksManager().buildSaveUserProfileTask(this.m_engine, session.getLocale());
        boolean hasEmail = profile.getEmail() != null;
        Fact[] facts = new Fact[hasEmail ? 4 : 3];
        facts[0] = new Fact("prefs.fullname", (Serializable)((Object)profile.getFullname()));
        facts[1] = new Fact("prefs.loginname", (Serializable)((Object)profile.getLoginName()));
        facts[2] = new Fact("fact.submitter", (Serializable)((Object)submitter.getName()));
        if (hasEmail) {
            facts[3] = new Fact("prefs.email", (Serializable)((Object)profile.getEmail()));
        }
        Workflow workflow = builder.buildApprovalWorkflow(submitter, "workflow.createUserProfile", null, "decision.createUserProfile", facts, completionTask, null);
        workflow.setAttribute("userProfile", profile);
        this.m_engine.getWorkflowManager().start(workflow);
        boolean approvalRequired = workflow.getCurrentStep() instanceof Decision;
        if (approvalRequired) {
            throw new DecisionRequiredException("This profile must be approved before it becomes active");
        }
    }

    public UserProfile parseProfile(WikiContext context) {
        UserProfile profile = this.getUserProfile(context.getWikiSession());
        HttpServletRequest request = context.getHttpRequest();
        String loginName = request.getParameter(PARAM_LOGINNAME);
        String password = request.getParameter(PARAM_PASSWORD);
        String fullname = request.getParameter(PARAM_FULLNAME);
        String email = request.getParameter(PARAM_EMAIL);
        loginName = InputValidator.isBlank(loginName) ? null : loginName;
        password = InputValidator.isBlank(password) ? null : password;
        fullname = InputValidator.isBlank(fullname) ? null : fullname;
        String string = email = InputValidator.isBlank(email) ? null : email;
        if (this.m_engine.getAuthenticationManager().isContainerAuthenticated() && context.getWikiSession().isAuthenticated()) {
            loginName = context.getWikiSession().getLoginPrincipal().getName();
        }
        profile.setLoginName(loginName);
        profile.setEmail(email);
        profile.setFullname(fullname);
        profile.setPassword(password);
        return profile;
    }

    public void validateProfile(WikiContext context, UserProfile profile) {
        Object[] args2;
        UserProfile otherProfile;
        boolean isNew = profile.isNew();
        WikiSession session = context.getWikiSession();
        InputValidator validator = new InputValidator(SESSION_MESSAGES, context);
        ResourceBundle rb = Preferences.getBundle(context, "CoreResources");
        Object fm = this.m_engine.getFilterManager();
        List<PageFilter> ls = fm.getFilterList();
        for (PageFilter pf : ls) {
            if (!(pf instanceof SpamFilter)) continue;
            if (((SpamFilter)pf).isValidUserProfile(context, profile)) break;
            session.addMessage(SESSION_MESSAGES, "Invalid userprofile");
            return;
        }
        if (this.m_engine.getAuthenticationManager().isContainerAuthenticated() && !context.getWikiSession().isAuthenticated()) {
            session.addMessage(SESSION_MESSAGES, rb.getString("security.error.createprofilebeforelogin"));
        }
        validator.validateNotNull(profile.getLoginName(), rb.getString("security.user.loginname"));
        validator.validateNotNull(profile.getFullname(), rb.getString("security.user.fullname"));
        validator.validate(profile.getEmail(), rb.getString("security.user.email"), 1);
        if (!this.m_engine.getAuthenticationManager().isContainerAuthenticated()) {
            String password = profile.getPassword();
            if (password == null) {
                if (isNew) {
                    session.addMessage(SESSION_MESSAGES, rb.getString("security.error.blankpassword"));
                }
            } else {
                String password2;
                HttpServletRequest request = context.getHttpRequest();
                String string = password2 = request == null ? null : request.getParameter("password2");
                if (!password.equals(password2)) {
                    session.addMessage(SESSION_MESSAGES, rb.getString("security.error.passwordnomatch"));
                }
            }
        }
        String fullName = profile.getFullname();
        String loginName = profile.getLoginName();
        String email = profile.getEmail();
        try {
            otherProfile = this.getUserDatabase().find(fullName);
            if (otherProfile != null && !profile.equals(otherProfile) && !fullName.equals(otherProfile.getFullname())) {
                args2 = new Object[]{fullName};
                session.addMessage(SESSION_MESSAGES, MessageFormat.format(rb.getString("security.error.illegalfullname"), args2));
            }
        }
        catch (NoSuchPrincipalException args2) {
            // empty catch block
        }
        try {
            otherProfile = this.getUserDatabase().find(loginName);
            if (otherProfile != null && !profile.equals(otherProfile) && !loginName.equals(otherProfile.getLoginName())) {
                args2 = new Object[]{loginName};
                session.addMessage(SESSION_MESSAGES, MessageFormat.format(rb.getString("security.error.illegalloginname"), args2));
            }
        }
        catch (NoSuchPrincipalException args3) {
            // empty catch block
        }
        try {
            otherProfile = this.getUserDatabase().findByEmail(email);
            if (otherProfile != null && !profile.getUid().equals(otherProfile.getUid()) && !profile.equals(otherProfile) && StringUtils.lowerCase((String)email).equals(StringUtils.lowerCase((String)otherProfile.getEmail()))) {
                args2 = new Object[]{email};
                session.addMessage(SESSION_MESSAGES, MessageFormat.format(rb.getString("security.error.email.taken"), args2));
            }
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
    }

    public Principal[] listWikiNames() throws WikiSecurityException {
        return this.getUserDatabase().getWikiNames();
    }

    public synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected void fireEvent(int type, WikiSession session, Object profile) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent(session, type, profile));
        }
    }

    public static final class JSONUserModule
    implements WikiAjaxServlet {
        private volatile UserManager m_manager;

        public JSONUserModule(UserManager mgr) {
            this.m_manager = mgr;
        }

        @Override
        public String getServletMapping() {
            return UserManager.JSON_USERS;
        }

        @Override
        public void service(HttpServletRequest req, HttpServletResponse resp, String actionName, List<String> params) throws ServletException, IOException {
            try {
                String uid = null;
                if (params.size() < 1) {
                    return;
                }
                uid = params.get(0);
                log.debug((Object)("uid=" + uid));
                if (StringUtils.isNotBlank((CharSequence)uid)) {
                    UserProfile prof = this.getUserInfo(uid);
                    resp.getWriter().write(AjaxUtil.toJson(prof));
                }
            }
            catch (NoSuchPrincipalException e) {
                throw new ServletException((Throwable)e);
            }
        }

        public UserProfile getUserInfo(String uid) throws NoSuchPrincipalException {
            if (this.m_manager != null) {
                UserProfile prof = this.m_manager.getUserDatabase().find(uid);
                return prof;
            }
            throw new IllegalStateException("The manager is offline.");
        }
    }

    public static class DummyUserDatabase
    extends AbstractUserDatabase {
        @Override
        public void deleteByLoginName(String loginName) throws WikiSecurityException {
        }

        @Override
        public UserProfile findByEmail(String index) throws NoSuchPrincipalException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        @Override
        public UserProfile findByFullName(String index) throws NoSuchPrincipalException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        @Override
        public UserProfile findByLoginName(String index) throws NoSuchPrincipalException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        @Override
        public UserProfile findByUid(String uid) throws NoSuchPrincipalException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        @Override
        public UserProfile findByWikiName(String index) throws NoSuchPrincipalException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        @Override
        public Principal[] getWikiNames() throws WikiSecurityException {
            return new Principal[0];
        }

        @Override
        public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException {
        }

        @Override
        public void rename(String loginName, String newName) throws DuplicateUserException, WikiSecurityException {
            throw new NoSuchPrincipalException("No user profiles available");
        }

        @Override
        public void save(UserProfile profile) throws WikiSecurityException {
        }
    }
}

