/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.wiki.auth.PrincipalComparator;

public final class WikiPrincipal
implements Principal,
Comparable<Principal>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Principal GUEST = new WikiPrincipal("Guest");
    public static final String FULL_NAME = "fullName";
    public static final String LOGIN_NAME = "loginName";
    public static final String WIKI_NAME = "wikiName";
    public static final String UNSPECIFIED = "unspecified";
    public static final Comparator<Principal> COMPARATOR = new PrincipalComparator();
    private static final String[] VALID_TYPES = new String[]{"fullName", "loginName", "wikiName", "unspecified"};
    private final String m_name;
    private final String m_type;

    protected WikiPrincipal() {
        this(null);
    }

    public WikiPrincipal(String name) {
        this.m_name = name;
        this.m_type = UNSPECIFIED;
    }

    public WikiPrincipal(String name, String type) {
        this.m_name = name;
        if (Arrays.binarySearch(VALID_TYPES, type) < 0) {
            throw new IllegalArgumentException("Principal type '" + type + "' is invalid.");
        }
        this.m_type = type;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WikiPrincipal)) {
            return false;
        }
        return this.m_name.equals(((WikiPrincipal)obj).getName());
    }

    @Override
    public int hashCode() {
        return this.m_name.hashCode();
    }

    public String getType() {
        return this.m_type;
    }

    @Override
    public String toString() {
        return "[WikiPrincipal (" + this.m_type + "): " + this.getName() + "]";
    }

    @Override
    public int compareTo(Principal o) {
        return this.getName().compareTo(o.getName());
    }

    static {
        Arrays.sort(VALID_TYPES);
    }
}

