/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.acl;

import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.PrincipalComparator;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.acl.Acl;
import org.apache.wiki.auth.acl.AclEntry;
import org.apache.wiki.auth.acl.AclEntryImpl;
import org.apache.wiki.auth.acl.AclImpl;
import org.apache.wiki.auth.acl.AclManager;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.pages.PageLock;
import org.apache.wiki.pages.PageManager;

public class DefaultAclManager
implements AclManager {
    private static final Logger log = Logger.getLogger(DefaultAclManager.class);
    private AuthorizationManager m_auth = null;
    private WikiEngine m_engine = null;
    private static final String PERM_REGEX = "(comment|delete|edit|modify|rename|upload|view)";
    private static final String ACL_REGEX = "\\[\\{\\s*ALLOW\\s+(comment|delete|edit|modify|rename|upload|view)\\s*(.*?)\\s*\\}\\]";
    public static final Pattern ACL_PATTERN = Pattern.compile("\\[\\{\\s*ALLOW\\s+(comment|delete|edit|modify|rename|upload|view)\\s*(.*?)\\s*\\}\\]");

    @Override
    public void initialize(WikiEngine engine, Properties props) {
        this.m_auth = engine.getAuthorizationManager();
        this.m_engine = engine;
    }

    @Override
    public Acl parseAcl(WikiPage page, String ruleLine) throws WikiSecurityException {
        Acl acl = page.getAcl();
        if (acl == null) {
            acl = new AclImpl();
        }
        try {
            StringTokenizer fieldToks = new StringTokenizer(ruleLine);
            fieldToks.nextToken();
            String actions = fieldToks.nextToken();
            page.getName();
            while (fieldToks.hasMoreTokens()) {
                String principalName = fieldToks.nextToken(",").trim();
                Principal principal = this.m_auth.resolvePrincipal(principalName);
                AclEntry oldEntry = acl.getEntry(principal);
                if (oldEntry != null) {
                    log.debug((Object)("Adding to old acl list: " + principal + ", " + actions));
                    oldEntry.addPermission(PermissionFactory.getPagePermission(page, actions));
                    continue;
                }
                log.debug((Object)("Adding new acl entry for " + actions));
                AclEntryImpl entry = new AclEntryImpl();
                entry.setPrincipal(principal);
                entry.addPermission(PermissionFactory.getPagePermission(page, actions));
                acl.addEntry(entry);
            }
            page.setAcl(acl);
            log.debug((Object)acl.toString());
        }
        catch (NoSuchElementException nsee) {
            log.warn((Object)("Invalid access rule: " + ruleLine + " - defaults will be used."));
            throw new WikiSecurityException("Invalid access rule: " + ruleLine, nsee);
        }
        catch (IllegalArgumentException iae) {
            throw new WikiSecurityException("Invalid permission type: " + ruleLine, iae);
        }
        return acl;
    }

    @Override
    public Acl getPermissions(WikiPage page) {
        Acl acl = page.getAcl();
        log.debug((Object)("page=" + page.getName() + "\n" + acl));
        if (acl == null) {
            if (page instanceof Attachment) {
                WikiPage parent = this.m_engine.getPage(((Attachment)page).getParentName());
                acl = this.getPermissions(parent);
            } else {
                WikiContext ctx = new WikiContext(this.m_engine, page);
                ctx.setVariable("_PluginContent.execute", Boolean.FALSE);
                this.m_engine.getHTML(ctx, page);
                if (page.getAcl() == null) {
                    page.setAcl(new AclImpl());
                }
                acl = page.getAcl();
            }
        }
        return acl;
    }

    @Override
    public void setPermissions(WikiPage page, Acl acl) throws WikiSecurityException {
        PageManager pageManager = this.m_engine.getPageManager();
        PageLock lock = pageManager.getCurrentLock(page);
        if (lock != null) {
            pageManager.unlockPage(lock);
        }
        String pageText = this.m_engine.getPureText(page);
        Matcher matcher = ACL_PATTERN.matcher(pageText);
        String cleansedText = matcher.replaceAll("");
        String newText = DefaultAclManager.printAcl(page.getAcl()) + cleansedText;
        try {
            pageManager.putPageText(page, newText);
        }
        catch (ProviderException e) {
            throw new WikiSecurityException("Could not set Acl. Reason: ProviderExcpetion " + e.getMessage(), e);
        }
    }

    protected static String printAcl(Acl acl) {
        ArrayList<Principal> principals;
        TreeMap<String, ArrayList<Principal>> permissionPrincipals = new TreeMap<String, ArrayList<Principal>>();
        Enumeration<AclEntry> entries = acl.entries();
        while (entries.hasMoreElements()) {
            AclEntry entry = entries.nextElement();
            Principal principal = entry.getPrincipal();
            Enumeration<Permission> permissions = entry.permissions();
            while (permissions.hasMoreElements()) {
                Permission permission = permissions.nextElement();
                principals = (ArrayList<Principal>)permissionPrincipals.get(permission.getActions());
                if (principals == null) {
                    principals = new ArrayList<Principal>();
                    String action = permission.getActions();
                    if (action.indexOf(44) != -1) {
                        throw new IllegalStateException("AclEntry permission cannot have multiple targets.");
                    }
                    permissionPrincipals.put(action, principals);
                }
                principals.add(principal);
            }
        }
        StringBuilder s = new StringBuilder();
        for (Map.Entry entry : permissionPrincipals.entrySet()) {
            String action = (String)entry.getKey();
            principals = (List)entry.getValue();
            Collections.sort(principals, new PrincipalComparator());
            s.append("[{ALLOW ");
            s.append(action);
            s.append(" ");
            for (int i = 0; i < principals.size(); ++i) {
                Principal principal = (Principal)principals.get(i);
                s.append(principal.getName());
                if (i >= principals.size() - 1) continue;
                s.append(",");
            }
            s.append("}]\n");
        }
        return s.toString();
    }
}

