/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.authorize;

import java.security.Principal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Group;
import org.apache.wiki.auth.authorize.GroupDatabase;

public class JDBCGroupDatabase
implements GroupDatabase {
    public static final String DEFAULT_GROUPDB_DATASOURCE = "jdbc/GroupDatabase";
    public static final String DEFAULT_GROUPDB_TABLE = "groups";
    public static final String DEFAULT_GROUPDB_MEMBER_TABLE = "group_members";
    public static final String DEFAULT_GROUPDB_CREATED = "created";
    public static final String DEFAULT_GROUPDB_CREATOR = "creator";
    public static final String DEFAULT_GROUPDB_NAME = "name";
    public static final String DEFAULT_GROUPDB_MEMBER = "member";
    public static final String DEFAULT_GROUPDB_MODIFIED = "modified";
    public static final String DEFAULT_GROUPDB_MODIFIER = "modifier";
    public static final String PROP_GROUPDB_DATASOURCE = "jspwiki.groupdatabase.datasource";
    public static final String PROP_GROUPDB_TABLE = "jspwiki.groupdatabase.table";
    public static final String PROP_GROUPDB_MEMBER_TABLE = "jspwiki.groupdatabase.membertable";
    public static final String PROP_GROUPDB_CREATED = "jspwiki.groupdatabase.created";
    public static final String PROP_GROUPDB_CREATOR = "jspwiki.groupdatabase.creator";
    public static final String PROP_GROUPDB_NAME = "jspwiki.groupdatabase.name";
    public static final String PROP_GROUPDB_MEMBER = "jspwiki.groupdatabase.member";
    public static final String PROP_GROUPDB_MODIFIED = "jspwiki.groupdatabase.modified";
    public static final String PROP_GROUPDB_MODIFIER = "jspwiki.groupdatabase.modifier";
    protected static final Logger log = Logger.getLogger(JDBCGroupDatabase.class);
    private DataSource m_ds = null;
    private String m_created = null;
    private String m_creator = null;
    private String m_name = null;
    private String m_member = null;
    private String m_modified = null;
    private String m_modifier = null;
    private String m_findAll = null;
    private String m_findGroup = null;
    private String m_findMembers = null;
    private String m_insertGroup = null;
    private String m_insertGroupMembers = null;
    private String m_updateGroup = null;
    private String m_deleteGroup = null;
    private String m_deleteGroupMembers = null;
    private boolean m_supportsCommits = false;
    private WikiEngine m_engine = null;

    @Override
    public void delete(Group group) throws WikiSecurityException {
        if (!this.exists(group)) {
            throw new NoSuchPrincipalException("Not in database: " + group.getName());
        }
        String groupName = group.getName();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.m_ds.getConnection();
            if (this.m_supportsCommits) {
                conn.setAutoCommit(false);
            }
            ps = conn.prepareStatement(this.m_deleteGroup);
            ps.setString(1, groupName);
            ps.execute();
            ps.close();
            ps = conn.prepareStatement(this.m_deleteGroupMembers);
            ps.setString(1, groupName);
            ps.execute();
            if (this.m_supportsCommits) {
                conn.commit();
            }
            this.closeQuietly(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                this.closeQuietly(conn, ps, null);
                throw new WikiSecurityException("Could not delete group " + groupName + ": " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(conn, ps, null);
                throw throwable;
            }
        }
    }

    @Override
    public Group[] groups() throws WikiSecurityException {
        HashSet<Group> groups = new HashSet<Group>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.m_ds.getConnection();
            ps = conn.prepareStatement(this.m_findAll);
            rs = ps.executeQuery();
            while (rs.next()) {
                String groupName = rs.getString(this.m_name);
                if (groupName == null) {
                    log.warn((Object)"Detected null group name in JDBCGroupDataBase. Check your group database.");
                    continue;
                }
                Group group = new Group(groupName, this.m_engine.getApplicationName());
                group.setCreated(rs.getTimestamp(this.m_created));
                group.setCreator(rs.getString(this.m_creator));
                group.setLastModified(rs.getTimestamp(this.m_modified));
                group.setModifier(rs.getString(this.m_modifier));
                this.populateGroup(group);
                groups.add(group);
            }
            this.closeQuietly(conn, ps, rs);
        }
        catch (SQLException e) {
            try {
                this.closeQuietly(conn, ps, rs);
                throw new WikiSecurityException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(conn, ps, rs);
                throw throwable;
            }
        }
        return groups.toArray(new Group[groups.size()]);
    }

    @Override
    public void save(Group group, Principal modifier) throws WikiSecurityException {
        if (group == null || modifier == null) {
            throw new IllegalArgumentException("Group or modifier cannot be null.");
        }
        boolean exists = this.exists(group);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.m_ds.getConnection();
            if (this.m_supportsCommits) {
                conn.setAutoCommit(false);
            }
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            Date modDate = new Date(ts.getTime());
            if (!exists) {
                ps = conn.prepareStatement(this.m_insertGroup);
                ps.setString(1, group.getName());
                ps.setTimestamp(2, ts);
                ps.setString(3, modifier.getName());
                ps.setTimestamp(4, ts);
                ps.setString(5, modifier.getName());
                ps.execute();
                group.setCreated(modDate);
                group.setCreator(modifier.getName());
                ps.close();
            } else {
                ps = conn.prepareStatement(this.m_updateGroup);
                ps.setTimestamp(1, ts);
                ps.setString(2, modifier.getName());
                ps.setString(3, group.getName());
                ps.execute();
                ps.close();
            }
            group.setLastModified(modDate);
            group.setModifier(modifier.getName());
            ps = conn.prepareStatement(this.m_deleteGroupMembers);
            ps.setString(1, group.getName());
            ps.execute();
            ps.close();
            ps = conn.prepareStatement(this.m_insertGroupMembers);
            Principal[] members = group.members();
            for (int i = 0; i < members.length; ++i) {
                Principal member = members[i];
                ps.setString(1, group.getName());
                ps.setString(2, member.getName());
                ps.execute();
            }
            if (this.m_supportsCommits) {
                conn.commit();
            }
            this.closeQuietly(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                this.closeQuietly(conn, ps, null);
                throw new WikiSecurityException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(conn, ps, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException, WikiSecurityException {
        this.m_engine = engine;
        String jndiName = props.getProperty(PROP_GROUPDB_DATASOURCE, DEFAULT_GROUPDB_DATASOURCE);
        try {
            InitialContext initCtx = new InitialContext();
            Context ctx = (Context)initCtx.lookup("java:comp/env");
            this.m_ds = (DataSource)ctx.lookup(jndiName);
            String table = props.getProperty(PROP_GROUPDB_TABLE, DEFAULT_GROUPDB_TABLE);
            String memberTable = props.getProperty(PROP_GROUPDB_MEMBER_TABLE, DEFAULT_GROUPDB_MEMBER_TABLE);
            this.m_name = props.getProperty(PROP_GROUPDB_NAME, DEFAULT_GROUPDB_NAME);
            this.m_created = props.getProperty(PROP_GROUPDB_CREATED, DEFAULT_GROUPDB_CREATED);
            this.m_creator = props.getProperty(PROP_GROUPDB_CREATOR, DEFAULT_GROUPDB_CREATOR);
            this.m_modifier = props.getProperty(PROP_GROUPDB_MODIFIER, DEFAULT_GROUPDB_MODIFIER);
            this.m_modified = props.getProperty(PROP_GROUPDB_MODIFIED, DEFAULT_GROUPDB_MODIFIED);
            this.m_member = props.getProperty(PROP_GROUPDB_MEMBER, DEFAULT_GROUPDB_MEMBER);
            this.m_findAll = "SELECT DISTINCT * FROM " + table;
            this.m_findGroup = "SELECT DISTINCT * FROM " + table + " WHERE " + this.m_name + "=?";
            this.m_findMembers = "SELECT * FROM " + memberTable + " WHERE " + this.m_name + "=?";
            this.m_insertGroup = "INSERT INTO " + table + " (" + this.m_name + "," + this.m_modified + "," + this.m_modifier + "," + this.m_created + "," + this.m_creator + ") VALUES (?,?,?,?,?)";
            this.m_updateGroup = "UPDATE " + table + " SET " + this.m_modified + "=?," + this.m_modifier + "=? WHERE " + this.m_name + "=?";
            this.m_insertGroupMembers = "INSERT INTO " + memberTable + " (" + this.m_name + "," + this.m_member + ") VALUES (?,?)";
            this.m_deleteGroup = "DELETE FROM " + table + " WHERE " + this.m_name + "=?";
            this.m_deleteGroupMembers = "DELETE FROM " + memberTable + " WHERE " + this.m_name + "=?";
        }
        catch (NamingException e) {
            log.error((Object)("JDBCGroupDatabase initialization error: " + e));
            throw new NoRequiredPropertyException(PROP_GROUPDB_DATASOURCE, "JDBCGroupDatabase initialization error: " + e);
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.m_ds.getConnection();
            ps = conn.prepareStatement(this.m_findAll);
            ps.executeQuery();
            ps.close();
            this.closeQuietly(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                this.closeQuietly(conn, ps, null);
                log.error((Object)("DB connectivity error: " + e.getMessage()));
                throw new WikiSecurityException("DB connectivity error: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(conn, ps, null);
                throw throwable;
            }
        }
        log.info((Object)("JDBCGroupDatabase initialized from JNDI DataSource: " + jndiName));
        try {
            conn = this.m_ds.getConnection();
            DatabaseMetaData dmd = conn.getMetaData();
            if (dmd.supportsTransactions()) {
                this.m_supportsCommits = true;
                conn.setAutoCommit(false);
                log.info((Object)"JDBCGroupDatabase supports transactions. Good; we will use them.");
            }
        }
        catch (SQLException e) {
            this.closeQuietly(conn, null, null);
            log.warn((Object)("JDBCGroupDatabase warning: user database doesn't seem to support transactions. Reason: " + e));
        }
        finally {
            this.closeQuietly(conn, null, null);
        }
    }

    private boolean exists(Group group) {
        String index = group.getName();
        try {
            this.findGroup(index);
            return true;
        }
        catch (NoSuchPrincipalException e) {
            return false;
        }
    }

    private Group findGroup(String index) throws NoSuchPrincipalException {
        Group group = null;
        boolean found = false;
        boolean unique = true;
        ResultSet rs = null;
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            conn = this.m_ds.getConnection();
            ps = conn.prepareStatement(this.m_findGroup);
            ps.setString(1, index);
            rs = ps.executeQuery();
            while (rs.next()) {
                if (group != null) {
                    unique = false;
                    break;
                }
                group = new Group(index, this.m_engine.getApplicationName());
                group.setCreated(rs.getTimestamp(this.m_created));
                group.setCreator(rs.getString(this.m_creator));
                group.setLastModified(rs.getTimestamp(this.m_modified));
                group.setModifier(rs.getString(this.m_modifier));
                this.populateGroup(group);
                found = true;
            }
            this.closeQuietly(conn, ps, rs);
        }
        catch (SQLException e) {
            try {
                this.closeQuietly(conn, ps, rs);
                throw new NoSuchPrincipalException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.closeQuietly(conn, ps, rs);
                throw throwable;
            }
        }
        if (!found) {
            throw new NoSuchPrincipalException("Could not find group in database!");
        }
        if (!unique) {
            throw new NoSuchPrincipalException("More than one group in database!");
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Group populateGroup(Group group) {
        ResultSet rs = null;
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            conn = this.m_ds.getConnection();
            ps = conn.prepareStatement(this.m_findMembers);
            ps.setString(1, group.getName());
            rs = ps.executeQuery();
            while (true) {
                if (!rs.next()) {
                    this.closeQuietly(conn, ps, rs);
                    return group;
                }
                String memberName = rs.getString(this.m_member);
                if (memberName == null) continue;
                WikiPrincipal principal = new WikiPrincipal(memberName, "unspecified");
                group.add(principal);
            }
        }
        catch (SQLException sQLException) {
            return group;
        }
        finally {
            this.closeQuietly(conn, ps, rs);
        }
    }

    void closeQuietly(Connection conn, PreparedStatement ps, ResultSet rs) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

