/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.authorize;

import java.io.Serializable;
import java.security.Principal;

public final class Role
implements Principal,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Role ALL = new Role("All");
    public static final Role ANONYMOUS = new Role("Anonymous");
    public static final Role ASSERTED = new Role("Asserted");
    public static final Role AUTHENTICATED = new Role("Authenticated");
    private final String m_name;

    protected Role() {
        this(null);
    }

    public Role(String name) {
        this.m_name = name;
    }

    public static boolean isBuiltInRole(Role role) {
        return role.equals(ALL) || role.equals(ANONYMOUS) || role.equals(ASSERTED) || role.equals(AUTHENTICATED);
    }

    public static boolean isReservedName(String name) {
        return name.equals(Role.ALL.m_name) || name.equals(Role.ANONYMOUS.m_name) || name.equals(Role.ASSERTED.m_name) || name.equals(Role.AUTHENTICATED.m_name);
    }

    @Override
    public int hashCode() {
        return this.m_name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Role)) {
            return false;
        }
        return this.m_name.equals(((Role)obj).getName());
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getName() + ": " + this.m_name + "]";
    }
}

