/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.UUID;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.login.AbstractLoginModule;
import org.apache.wiki.auth.login.HttpRequestCallback;
import org.apache.wiki.auth.login.WikiEngineCallback;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.TextUtil;

public class CookieAuthenticationLoginModule
extends AbstractLoginModule {
    private static final Logger log = Logger.getLogger(CookieAuthenticationLoginModule.class);
    private static final String LOGIN_COOKIE_NAME = "JSPWikiUID";
    protected static final String COOKIE_DIR = "logincookies";
    public static final String PROP_LOGIN_EXPIRY_DAYS = "jspwiki.cookieAuthentication.expiry";
    private static final int DEFAULT_EXPIRY_DAYS = 14;
    private static long c_lastScrubTime = 0L;
    private static final long SCRUB_PERIOD = 3600000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean login() throws LoginException {
        block11: {
            boolean bl;
            block12: {
                WikiEngine engine;
                File cookieFile;
                HttpRequestCallback hcb = new HttpRequestCallback();
                WikiEngineCallback wcb = new WikiEngineCallback();
                Callback[] callbacks = new Callback[]{hcb, wcb};
                this.m_handler.handle(callbacks);
                HttpServletRequest request = hcb.getRequest();
                String uid = CookieAuthenticationLoginModule.getLoginCookie(request);
                if (uid == null || (cookieFile = CookieAuthenticationLoginModule.getCookieFile(engine = wcb.getEngine(), uid)) == null || !cookieFile.exists() || !cookieFile.canRead()) break block11;
                Reader in = null;
                try {
                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(cookieFile), "UTF-8"));
                    String username = FileUtil.readContents((Reader)in);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Logged in cookie authenticated name=" + username));
                    }
                    this.m_principals.add(new WikiPrincipal(username, "loginName"));
                    cookieFile.setLastModified(System.currentTimeMillis());
                    bl = true;
                    if (in == null) break block12;
                }
                catch (IOException e) {
                    boolean bl2;
                    block13: {
                        try {
                            bl2 = false;
                            if (in == null) break block13;
                        }
                        catch (Throwable throwable) {
                            String message;
                            try {
                                if (in != null) {
                                    in.close();
                                }
                                throw throwable;
                            }
                            catch (IOException e2) {
                                message = "IO exception; disallowing login.";
                                log.error((Object)message, (Throwable)e2);
                                throw new LoginException(message);
                            }
                            catch (UnsupportedCallbackException e3) {
                                message = "Unable to handle callback; disallowing login.";
                                log.error((Object)message, (Throwable)e3);
                                throw new LoginException(message);
                            }
                        }
                        in.close();
                    }
                    return bl2;
                }
                in.close();
            }
            return bl;
        }
        return false;
    }

    private static File getCookieFile(WikiEngine engine, String uid) {
        File cookieDir = new File(engine.getWorkDir(), COOKIE_DIR);
        if (!cookieDir.exists()) {
            cookieDir.mkdirs();
        }
        if (!cookieDir.canRead()) {
            log.error((Object)("Cannot read from cookie directory!" + cookieDir.getAbsolutePath()));
            return null;
        }
        if (!cookieDir.canWrite()) {
            log.error((Object)("Cannot write to cookie directory!" + cookieDir.getAbsolutePath()));
            return null;
        }
        long now = System.currentTimeMillis();
        if (now > c_lastScrubTime + 3600000L) {
            CookieAuthenticationLoginModule.scrub(TextUtil.getIntegerProperty((Properties)engine.getWikiProperties(), (String)PROP_LOGIN_EXPIRY_DAYS, (int)14), cookieDir);
            c_lastScrubTime = now;
        }
        File cookieFile = new File(cookieDir, uid);
        return cookieFile;
    }

    private static String getLoginCookie(HttpServletRequest request) {
        String cookie = HttpUtil.retrieveCookieValue((HttpServletRequest)request, (String)LOGIN_COOKIE_NAME);
        return cookie;
    }

    public static void setLoginCookie(WikiEngine engine, HttpServletResponse response, String username) {
        UUID uid = UUID.randomUUID();
        int days = TextUtil.getIntegerProperty((Properties)engine.getWikiProperties(), (String)PROP_LOGIN_EXPIRY_DAYS, (int)14);
        Cookie userId = new Cookie(LOGIN_COOKIE_NAME, uid.toString());
        userId.setMaxAge(days * 24 * 60 * 60);
        response.addCookie(userId);
        File cf = CookieAuthenticationLoginModule.getCookieFile(engine, uid.toString());
        if (cf != null) {
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cf), StandardCharsets.UTF_8));){
                FileUtil.copyContents((Reader)new StringReader(username), (Writer)out);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created login cookie for user " + username + " for " + days + " days"));
                }
            }
            catch (IOException ex) {
                log.error((Object)("Unable to create cookie file to store user id: " + uid));
            }
        }
    }

    public static void clearLoginCookie(WikiEngine engine, HttpServletRequest request, HttpServletResponse response) {
        File cf;
        Cookie userId = new Cookie(LOGIN_COOKIE_NAME, "");
        userId.setMaxAge(0);
        response.addCookie(userId);
        String uid = CookieAuthenticationLoginModule.getLoginCookie(request);
        if (uid != null && (cf = CookieAuthenticationLoginModule.getCookieFile(engine, uid)) != null) {
            cf.delete();
        }
    }

    private static synchronized void scrub(int days, File cookieDir) {
        log.debug((Object)"Scrubbing cookieDir...");
        File[] files = cookieDir.listFiles();
        long obsoleteDateLimit = System.currentTimeMillis() - ((long)days + 1L) * 24L * 60L * 60L * 1000L;
        int deleteCount = 0;
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            long lastModified = f.lastModified();
            if (lastModified >= obsoleteDateLimit) continue;
            f.delete();
            ++deleteCount;
        }
        log.debug((Object)("Removed " + deleteCount + " obsolete cookie logins"));
    }
}

