/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.user;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.user.DefaultUserProfile;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.util.ByteUtils;
import org.apache.wiki.util.CryptoUtil;

public abstract class AbstractUserDatabase
implements UserDatabase {
    protected static final Logger log = Logger.getLogger(AbstractUserDatabase.class);
    protected static final String SHA_PREFIX = "{SHA}";
    protected static final String SSHA_PREFIX = "{SSHA}";

    @Override
    public UserProfile find(String index) throws NoSuchPrincipalException {
        UserProfile profile = null;
        try {
            profile = this.findByFullName(index);
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        if (profile != null) {
            return profile;
        }
        try {
            profile = this.findByWikiName(index);
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        if (profile != null) {
            return profile;
        }
        try {
            profile = this.findByLoginName(index);
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        if (profile != null) {
            return profile;
        }
        throw new NoSuchPrincipalException("Not in database: " + index);
    }

    @Override
    public abstract UserProfile findByEmail(String var1) throws NoSuchPrincipalException;

    @Override
    public abstract UserProfile findByFullName(String var1) throws NoSuchPrincipalException;

    @Override
    public abstract UserProfile findByLoginName(String var1) throws NoSuchPrincipalException;

    @Override
    public abstract UserProfile findByWikiName(String var1) throws NoSuchPrincipalException;

    @Override
    public Principal[] getPrincipals(String identifier) throws NoSuchPrincipalException {
        UserProfile profile = this.findByLoginName(identifier);
        ArrayList<WikiPrincipal> principals = new ArrayList<WikiPrincipal>();
        if (profile.getLoginName() != null && profile.getLoginName().length() > 0) {
            principals.add(new WikiPrincipal(profile.getLoginName(), "loginName"));
        }
        if (profile.getFullname() != null && profile.getFullname().length() > 0) {
            principals.add(new WikiPrincipal(profile.getFullname(), "fullName"));
        }
        if (profile.getWikiName() != null && profile.getWikiName().length() > 0) {
            principals.add(new WikiPrincipal(profile.getWikiName(), "wikiName"));
        }
        return principals.toArray(new Principal[principals.size()]);
    }

    @Override
    public abstract void initialize(WikiEngine var1, Properties var2) throws NoRequiredPropertyException, WikiSecurityException;

    @Override
    public UserProfile newProfile() {
        return DefaultUserProfile.newProfile(this);
    }

    @Override
    public abstract void save(UserProfile var1) throws WikiSecurityException;

    @Override
    public boolean validatePassword(String loginName, String password) {
        try {
            String hashedPassword;
            boolean verified;
            UserProfile profile = this.findByLoginName(loginName);
            String storedPassword = profile.getPassword();
            boolean newPasswordFormat = storedPassword.startsWith(SSHA_PREFIX);
            if (newPasswordFormat) {
                String hashedPassword2 = this.getHash(password);
                return CryptoUtil.verifySaltedPassword((byte[])password.getBytes(StandardCharsets.UTF_8), (String)storedPassword);
            }
            if (storedPassword.startsWith(SHA_PREFIX)) {
                storedPassword = storedPassword.substring(SHA_PREFIX.length());
            }
            if (verified = (hashedPassword = this.getOldHash(password)).equals(storedPassword)) {
                profile.setPassword(password);
                this.save(profile);
            }
            return verified;
        }
        catch (NoSuchPrincipalException profile) {
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("Unsupported algorithm: " + e.getMessage()));
        }
        catch (WikiSecurityException e) {
            log.error((Object)("Could not upgrade SHA password to SSHA because profile could not be saved. Reason: " + e.getMessage()), (Throwable)e);
        }
        return false;
    }

    protected static String generateUid(UserDatabase db) {
        boolean collision;
        String uid = null;
        do {
            uid = UUID.randomUUID().toString();
            collision = true;
            try {
                db.findByUid(uid);
            }
            catch (NoSuchPrincipalException e) {
                collision = false;
            }
        } while (collision || uid == null);
        return uid;
    }

    protected String getHash(String text) {
        try {
            return CryptoUtil.getSaltedPassword((byte[])text.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("Error creating salted SHA password hash:" + e.getMessage()));
            return text;
        }
    }

    String getOldHash(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(text.getBytes(StandardCharsets.UTF_8));
            byte[] digestedBytes = md.digest();
            return ByteUtils.bytes2hex((byte[])digestedBytes);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("Error creating SHA password hash:" + e.getMessage()));
            return text;
        }
    }

    protected long parseLong(String value) {
        if (NumberUtils.isParsable((String)value)) {
            return Long.valueOf(value);
        }
        return 0L;
    }
}

