/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.user;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.wiki.auth.user.AbstractUserDatabase;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;

public final class DefaultUserProfile
implements UserProfile {
    private static final long serialVersionUID = -5600466893735300647L;
    private static final String EMPTY_STRING = "";
    private static final String WHITESPACE = "\\s";
    private Map<String, Serializable> attributes = new HashMap<String, Serializable>();
    private Date created = null;
    private String email = null;
    private String fullname = null;
    private Date lockExpiry = null;
    private String loginName = null;
    private Date modified = null;
    private String password = null;
    private String uid = null;
    private String wikiname = null;

    private DefaultUserProfile() {
    }

    protected static UserProfile newProfile(UserDatabase db) {
        DefaultUserProfile profile = new DefaultUserProfile();
        profile.setUid(AbstractUserDatabase.generateUid(db));
        return profile;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof UserProfile) {
            DefaultUserProfile u = (DefaultUserProfile)o;
            return this.same(this.fullname, u.fullname) && this.same(this.password, u.password) && this.same(this.loginName, u.loginName) && this.same(StringUtils.lowerCase((String)this.email), StringUtils.lowerCase((String)u.email)) && this.same(this.wikiname, u.wikiname);
        }
        return false;
    }

    public int hashCode() {
        return (this.fullname != null ? this.fullname.hashCode() : 0) ^ (this.password != null ? this.password.hashCode() : 0) ^ (this.loginName != null ? this.loginName.hashCode() : 0) ^ (this.wikiname != null ? this.wikiname.hashCode() : 0) ^ (this.email != null ? StringUtils.lowerCase((String)this.email).hashCode() : 0);
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getFullname() {
        return this.fullname;
    }

    @Override
    public Date getLastModified() {
        return this.modified;
    }

    @Override
    public String getLoginName() {
        return this.loginName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getWikiName() {
        return this.wikiname;
    }

    @Override
    public boolean isNew() {
        return this.modified == null;
    }

    @Override
    public void setCreated(Date date) {
        this.created = date;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public void setFullname(String arg) {
        this.fullname = arg;
        if (this.fullname != null) {
            this.wikiname = this.fullname.replaceAll(WHITESPACE, EMPTY_STRING);
        }
    }

    @Override
    public void setLastModified(Date date) {
        this.modified = date;
    }

    @Override
    public void setLoginName(String name) {
        this.loginName = name;
    }

    @Override
    public void setPassword(String arg) {
        this.password = arg;
    }

    @Override
    public String toString() {
        return "[DefaultUserProfile: '" + this.getFullname() + "']";
    }

    private boolean same(Object arg1, Object arg2) {
        if (arg1 == null && arg2 == null) {
            return true;
        }
        if (arg1 == null || arg2 == null) {
            return false;
        }
        return arg1.equals(arg2);
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return this.attributes;
    }

    @Override
    public Date getLockExpiry() {
        return this.isLocked() ? this.lockExpiry : null;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public boolean isLocked() {
        boolean locked;
        boolean bl = locked = this.lockExpiry != null && System.currentTimeMillis() < this.lockExpiry.getTime();
        if (!locked && this.lockExpiry != null) {
            this.lockExpiry = null;
        }
        return locked;
    }

    @Override
    public void setLockExpiry(Date expiry) {
        this.lockExpiry = expiry;
    }

    @Override
    public void setUid(String uid) {
        this.uid = uid;
    }
}

