/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.diff;

import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.diff.DiffProvider;
import org.apache.wiki.diff.TraditionalDiffProvider;
import org.apache.wiki.util.ClassUtil;

public class DifferenceManager {
    private static final Logger log = Logger.getLogger(DifferenceManager.class);
    public static final String PROP_DIFF_PROVIDER = "jspwiki.diffProvider";
    private DiffProvider m_provider;

    public DifferenceManager(WikiEngine engine, Properties props) {
        this.loadProvider(props);
        this.initializeProvider(engine, props);
        log.info((Object)("Using difference provider: " + this.m_provider.getProviderInfo()));
    }

    private void loadProvider(Properties props) {
        String providerClassName = props.getProperty(PROP_DIFF_PROVIDER, TraditionalDiffProvider.class.getName());
        try {
            Class providerClass = ClassUtil.findClass((String)"org.apache.wiki.diff", (String)providerClassName);
            this.m_provider = (DiffProvider)providerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"Failed loading DiffProvider, will use NullDiffProvider.", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.warn((Object)"Failed loading DiffProvider, will use NullDiffProvider.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)"Failed loading DiffProvider, will use NullDiffProvider.", (Throwable)e);
        }
        if (null == this.m_provider) {
            this.m_provider = new DiffProvider.NullDiffProvider();
        }
    }

    private void initializeProvider(WikiEngine engine, Properties props) {
        try {
            this.m_provider.initialize(engine, props);
        }
        catch (NoRequiredPropertyException e1) {
            log.warn((Object)"Failed initializing DiffProvider, will use NullDiffProvider.", (Throwable)e1);
            this.m_provider = new DiffProvider.NullDiffProvider();
        }
        catch (IOException e1) {
            log.warn((Object)"Failed initializing DiffProvider, will use NullDiffProvider.", (Throwable)e1);
            this.m_provider = new DiffProvider.NullDiffProvider();
        }
    }

    public String makeDiff(WikiContext context, String firstWikiText, String secondWikiText) {
        String diff = null;
        try {
            diff = this.m_provider.makeDiffHtml(context, firstWikiText, secondWikiText);
            if (diff == null) {
                diff = "";
            }
        }
        catch (Exception e) {
            diff = "Failed to create a diff, check the logs.";
            log.warn((Object)diff, (Throwable)e);
        }
        return diff;
    }
}

