/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.diff;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.diff.DiffProvider;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.TextUtil;

public class ExternalDiffProvider
implements DiffProvider {
    private static final Logger log = Logger.getLogger(ExternalDiffProvider.class);
    public static final String PROP_DIFFCOMMAND = "jspwiki.diffCommand";
    private String m_diffCommand = null;
    private Charset m_encoding;
    private static final char DIFF_ADDED_SYMBOL = '+';
    private static final char DIFF_REMOVED_SYMBOL = '-';
    private static final String CSS_DIFF_ADDED = "<tr><td bgcolor=\"#99FF99\" class=\"diffadd\">";
    private static final String CSS_DIFF_REMOVED = "<tr><td bgcolor=\"#FF9933\" class=\"diffrem\">";
    private static final String CSS_DIFF_UNCHANGED = "<tr><td class=\"diff\">";
    private static final String CSS_DIFF_CLOSE = "</td></tr>";
    private boolean m_traditionalColorization = true;

    @Override
    public String getProviderInfo() {
        return "ExternalDiffProvider";
    }

    @Override
    public void initialize(WikiEngine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        this.m_diffCommand = properties.getProperty(PROP_DIFFCOMMAND);
        if (null == this.m_diffCommand || this.m_diffCommand.trim().equals("")) {
            throw new NoRequiredPropertyException("ExternalDiffProvider missing required property", PROP_DIFFCOMMAND);
        }
        this.m_encoding = engine.getContentEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeDiffHtml(WikiContext ctx, String p1, String p2) {
        File f1 = null;
        File f2 = null;
        String diff = null;
        try {
            f1 = FileUtil.newTmpFile((String)p1, (Charset)this.m_encoding);
            f2 = FileUtil.newTmpFile((String)p2, (Charset)this.m_encoding);
            String cmd = TextUtil.replaceString((String)this.m_diffCommand, (String)"%s1", (String)f1.getPath());
            cmd = TextUtil.replaceString((String)cmd, (String)"%s2", (String)f2.getPath());
            String output = FileUtil.runSimpleCommand((String)cmd, (String)f1.getParent());
            String rawWikiDiff = new String(output.getBytes(StandardCharsets.ISO_8859_1), this.m_encoding);
            String htmlWikiDiff = TextUtil.replaceEntities((String)rawWikiDiff);
            diff = this.m_traditionalColorization ? ExternalDiffProvider.colorizeDiff(htmlWikiDiff) : htmlWikiDiff;
        }
        catch (IOException e) {
            log.error((Object)"Failed to do file diff", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((Object)"Interrupted", (Throwable)e);
        }
        finally {
            if (f1 != null) {
                f1.delete();
            }
            if (f2 != null) {
                f2.delete();
            }
        }
        return diff;
    }

    static String colorizeDiff(String diffText) throws IOException {
        if (diffText == null) {
            return "Invalid diff - probably something wrong with server setup.";
        }
        String line = null;
        String start = null;
        String stop = null;
        BufferedReader in = new BufferedReader(new StringReader(diffText));
        StringBuilder out = new StringBuilder();
        out.append("<table class=\"diff\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
        while ((line = in.readLine()) != null) {
            stop = CSS_DIFF_CLOSE;
            if (line.length() > 0) {
                switch (line.charAt(0)) {
                    case '+': {
                        start = CSS_DIFF_ADDED;
                        break;
                    }
                    case '-': {
                        start = CSS_DIFF_REMOVED;
                        break;
                    }
                    default: {
                        start = CSS_DIFF_UNCHANGED;
                        break;
                    }
                }
            } else {
                start = CSS_DIFF_UNCHANGED;
            }
            out.append(start);
            out.append(line.trim());
            out.append(stop + "\n");
        }
        out.append("</table>\n");
        return out.toString();
    }
}

