/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.event;

import org.apache.wiki.WikiEngine;
import org.apache.wiki.event.WikiEvent;

public class WikiEngineEvent
extends WikiEvent {
    private static final long serialVersionUID = 1829433967558773970L;
    public static final int INITIALIZING = -1;
    public static final int INITIALIZED = 0;
    public static final int SHUTDOWN = 1;
    public static final int STOPPED = 2;
    private WikiEngine m_engine;

    public WikiEngineEvent(Object eventSource, int type) {
        super(eventSource, type);
        this.m_engine = (WikiEngine)eventSource;
    }

    @Override
    protected void setType(int type) {
        if (type >= -1 && type <= 2) {
            super.setType(type);
        } else {
            super.setType(-99);
        }
    }

    public WikiEngine getEngine() {
        return this.m_engine;
    }

    public static boolean isValidType(int type) {
        return type >= -1 && type <= 2;
    }

    @Override
    public final String eventName() {
        switch (this.getType()) {
            case -1: {
                return "INITIALIZING";
            }
            case 0: {
                return "INITIALIZED";
            }
            case 1: {
                return "SHUTDOWN";
            }
            case 2: {
                return "STOPPED";
            }
        }
        return super.eventName();
    }

    @Override
    public final String getTypeDescription() {
        switch (this.getType()) {
            case -1: {
                return "wiki engine initializing";
            }
            case 0: {
                return "wiki engine initialized";
            }
            case 1: {
                return "wiki engine shutting down";
            }
            case 2: {
                return "wiki engine stopped";
            }
        }
        return super.getTypeDescription();
    }
}

