/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.filters;

import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.exceptions.FilterException;
import org.apache.wiki.api.filters.BasicPageFilter;
import org.apache.wiki.parser.CreoleToJSPWikiTranslator;

public class CreoleFilter
extends BasicPageFilter {
    private static final Logger log = Logger.getLogger(CreoleFilter.class);

    @Override
    public void initialize(WikiEngine engine, Properties props) throws FilterException {
    }

    @Override
    public String preSave(WikiContext wikiContext, String content) {
        try {
            String username = wikiContext.getCurrentUser().getName();
            Properties prop = wikiContext.getEngine().getWikiProperties();
            return new CreoleToJSPWikiTranslator().translateSignature(prop, content, username);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
    }

    @Override
    public String preTranslate(WikiContext wikiContext, String content) {
        try {
            Properties prop = wikiContext.getEngine().getWikiProperties();
            return new CreoleToJSPWikiTranslator().translate(prop, content);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return content + "\n \n %%error \n[CreoleFilterError]: This page was not translated by the CreoleFilter due to the following error: " + e.getMessage() + "\n \n%%\n \n";
        }
    }
}

