/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.filters;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.engine.FilterManager;
import org.apache.wiki.api.exceptions.FilterException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.api.filters.PageFilter;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.modules.ModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.PriorityList;
import org.apache.wiki.util.XmlUtil;
import org.jdom2.Element;

public class DefaultFilterManager
extends ModuleManager
implements FilterManager {
    private PriorityList<PageFilter> m_pageFilters = new PriorityList();
    private Map<String, PageFilterInfo> m_filterClassMap = new HashMap<String, PageFilterInfo>();
    private static final Logger log = Logger.getLogger(DefaultFilterManager.class);

    public DefaultFilterManager(WikiEngine engine, Properties props) throws WikiException {
        super(engine);
        this.initialize(props);
    }

    @Override
    public void addPageFilter(PageFilter f, int priority) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException("Attempt to provide a null filter - this should never happen.  Please check your configuration (or if you're a developer, check your own code.)");
        }
        this.m_pageFilters.add((Object)f, priority);
    }

    private void initPageFilter(String className, Properties props) {
        try {
            PageFilterInfo info = this.m_filterClassMap.get(className);
            if (info != null && !this.checkCompatibility(info)) {
                String msg = "Filter '" + info.getName() + "' not compatible with this version of JSPWiki";
                log.warn((Object)msg);
                return;
            }
            int priority = 0;
            Class cl = ClassUtil.findClass((String)"org.apache.wiki.filters", (String)className);
            PageFilter filter = (PageFilter)cl.newInstance();
            filter.initialize(this.m_engine, props);
            this.addPageFilter(filter, priority);
            log.info((Object)("Added page filter " + cl.getName() + " with priority " + priority));
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to find the filter class: " + className));
        }
        catch (InstantiationException e) {
            log.error((Object)("Cannot create filter class: " + className));
        }
        catch (IllegalAccessException e) {
            log.error((Object)("You are not allowed to access class: " + className));
        }
        catch (ClassCastException e) {
            log.error((Object)("Suggested class is not a PageFilter: " + className));
        }
        catch (FilterException e) {
            log.error((Object)("Filter " + className + " failed to initialize itself."), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(Properties props) throws WikiException {
        InputStream xmlStream = null;
        String xmlFile = props.getProperty("jspwiki.filterConfig");
        try {
            this.registerFilters();
            if (this.m_engine.getServletContext() != null) {
                log.debug((Object)"Attempting to locate /WEB-INF/filters.xml from servlet context.");
                xmlStream = xmlFile == null ? this.m_engine.getServletContext().getResourceAsStream("/WEB-INF/filters.xml") : this.m_engine.getServletContext().getResourceAsStream(xmlFile);
            }
            if (xmlStream == null) {
                log.debug((Object)"Attempting to locate filters.xml from class path.");
                xmlStream = xmlFile == null ? this.getClass().getResourceAsStream("/filters.xml") : this.getClass().getResourceAsStream(xmlFile);
            }
            if (xmlStream == null && xmlFile != null) {
                log.debug((Object)("Attempting to load property file " + xmlFile));
                xmlStream = new FileInputStream(new File(xmlFile));
            }
            if (xmlStream == null) {
                log.info((Object)("Cannot find property file for filters (this is okay, expected to find it as: '" + (xmlFile == null ? "/WEB-INF/filters.xml" : xmlFile) + "')"));
                return;
            }
            this.parseConfigFile(xmlStream);
        }
        catch (IOException e) {
            log.error((Object)"Unable to read property file", (Throwable)e);
        }
        finally {
            try {
                if (xmlStream != null) {
                    xmlStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void parseConfigFile(InputStream xmlStream) {
        List pageFilters = XmlUtil.parse((InputStream)xmlStream, (String)"/pagefilters/filter");
        for (Element f : pageFilters) {
            String filterClass = f.getChildText("class");
            Properties props = new Properties();
            List params = f.getChildren("param");
            for (Element p : params) {
                props.setProperty(p.getChildText("name"), p.getChildText("value"));
            }
            this.initPageFilter(filterClass, props);
        }
    }

    @Override
    public String doPreTranslateFiltering(WikiContext context, String pageData) throws FilterException {
        this.fireEvent(12, context);
        for (PageFilter f : this.m_pageFilters) {
            pageData = f.preTranslate(context, pageData);
        }
        this.fireEvent(14, context);
        return pageData;
    }

    @Override
    public String doPostTranslateFiltering(WikiContext context, String htmlData) throws FilterException {
        this.fireEvent(15, context);
        for (PageFilter f : this.m_pageFilters) {
            htmlData = f.postTranslate(context, htmlData);
        }
        this.fireEvent(17, context);
        return htmlData;
    }

    @Override
    public String doPreSaveFiltering(WikiContext context, String pageData) throws FilterException {
        this.fireEvent(18, context);
        for (PageFilter f : this.m_pageFilters) {
            pageData = f.preSave(context, pageData);
        }
        this.fireEvent(20, context);
        return pageData;
    }

    @Override
    public void doPostSaveFiltering(WikiContext context, String pageData) throws FilterException {
        this.fireEvent(21, context);
        for (PageFilter f : this.m_pageFilters) {
            f.postSave(context, pageData);
        }
        this.fireEvent(23, context);
    }

    @Override
    public List<PageFilter> getFilterList() {
        return this.m_pageFilters;
    }

    @Override
    public void destroy() {
        for (PageFilter f : this.m_pageFilters) {
            f.destroy(this.m_engine);
        }
    }

    public void fireEvent(int type, WikiContext context) {
        if (WikiEventManager.isListening(this) && WikiPageEvent.isValidType(type)) {
            WikiEventManager.fireEvent(this, new WikiPageEvent(this.m_engine, type, context.getPage().getName()));
        }
    }

    @Override
    public Collection<WikiModuleInfo> modules() {
        return this.modules(this.m_filterClassMap.values().iterator());
    }

    @Override
    public PageFilterInfo getModuleInfo(String moduleName) {
        return this.m_filterClassMap.get(moduleName);
    }

    private void registerFilters() {
        log.info((Object)"Registering filters");
        List filters = XmlUtil.parse((String)"ini/jspwiki_module.xml", (String)"/modules/filter");
        for (Element pluginEl : filters) {
            String className = pluginEl.getAttributeValue("class");
            PageFilterInfo filterInfo = PageFilterInfo.newInstance(className, pluginEl);
            if (filterInfo == null) continue;
            this.registerFilter(filterInfo);
        }
    }

    private void registerFilter(PageFilterInfo pluginInfo) {
        this.m_filterClassMap.put(pluginInfo.getName(), pluginInfo);
    }

    private static final class PageFilterInfo
    extends WikiModuleInfo {
        private PageFilterInfo(String name) {
            super(name);
        }

        protected static PageFilterInfo newInstance(String className, Element pluginEl) {
            if (className == null || className.length() == 0) {
                return null;
            }
            PageFilterInfo info = new PageFilterInfo(className);
            info.initializeFromXML(pluginEl);
            return info;
        }
    }
}

