/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.forms;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.forms.FormElement;
import org.apache.wiki.forms.FormInfo;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.XHTML;
import org.apache.wiki.util.XhtmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class FormSelect
extends FormElement {
    @Override
    public String execute(WikiContext ctx, Map<String, String> params) throws PluginException {
        FormInfo info = this.getFormInfo(ctx);
        ResourceBundle rb = Preferences.getBundle(ctx, "plugin.PluginResources");
        Map<String, String> previousValues = null;
        if (info != null) {
            if (info.hide()) {
                return "<p>" + rb.getString("forminput.noneedtoshow") + "</p>";
            }
            previousValues = info.getSubmission();
        }
        if (previousValues == null) {
            previousValues = new HashMap<String, String>();
        }
        Element field = this.buildSelect(params, previousValues, rb);
        return XhtmlUtil.serialize((Element)field);
    }

    private Element buildSelect(Map<String, String> pluginParams, Map<String, String> ctxValues, ResourceBundle rb) throws PluginException {
        String optionSelector;
        String inputName = pluginParams.get("name");
        if (inputName == null) {
            throw new PluginException(rb.getString("formselect.namemissing"));
        }
        String inputValue = pluginParams.get("value");
        String previousValue = ctxValues.get(inputName);
        String optionSeparator = pluginParams.get("separator");
        if (optionSeparator == null) {
            optionSeparator = ctxValues.get("separator." + inputName);
        }
        if (optionSeparator == null) {
            optionSeparator = ctxValues.get("select.separator");
        }
        if (optionSeparator == null) {
            optionSeparator = ";";
        }
        if ((optionSelector = pluginParams.get("selector")) == null) {
            optionSelector = ctxValues.get("selector." + inputName);
        }
        if (optionSelector == null) {
            optionSelector = ctxValues.get("select.selector");
        }
        if (optionSelector == null) {
            optionSelector = "*";
        }
        if (optionSelector.equals(optionSeparator)) {
            optionSelector = null;
        }
        if (inputValue == null) {
            inputValue = "";
        }
        boolean contextValueOverride = false;
        if (previousValue != null) {
            if (previousValue.indexOf(optionSeparator) != -1) {
                inputValue = previousValue;
                previousValue = null;
            } else {
                contextValueOverride = true;
            }
        }
        String[] options = inputValue.split(optionSeparator);
        int previouslySelected = -1;
        Element[] optionElements = new Element[options.length];
        for (int i = 0; i < options.length; ++i) {
            int indicated = -1;
            options[i] = options[i].trim();
            if (optionSelector != null && options[i].startsWith(optionSelector)) {
                options[i] = options[i].substring(optionSelector.length());
                indicated = i;
            }
            if (previouslySelected == -1) {
                if (!contextValueOverride && indicated > 0) {
                    previouslySelected = indicated;
                } else if (previousValue != null && options[i].equals(previousValue)) {
                    previouslySelected = i;
                }
            }
            optionElements[i] = XhtmlUtil.element((XHTML)XHTML.option, (String)options[i]);
        }
        if (previouslySelected > -1) {
            optionElements[previouslySelected].setAttribute("selected", "true");
        }
        Element select = XhtmlUtil.element((XHTML)XHTML.select);
        select.setAttribute("name", "nbf_" + inputName);
        for (Element option : optionElements) {
            select.addContent((Content)option);
        }
        return select;
    }
}

