/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.modules;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.wiki.util.FileUtil;
import org.jdom2.Element;

public class WikiModuleInfo
implements Comparable<WikiModuleInfo> {
    protected String m_name;
    protected String m_description;
    protected String m_moduleUrl;
    protected String m_moduleVersion;
    protected String m_htmlTemplate;
    protected String m_scriptLocation;
    protected String m_scriptText;
    protected String m_stylesheetLocation;
    protected String m_stylesheetText;
    protected String m_author;
    protected String m_authorUrl;
    protected URL m_resource;
    protected String m_minVersion;
    protected String m_maxVersion;
    protected String m_adminBeanClass;

    public WikiModuleInfo(String name) {
        this.m_name = name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WikiModuleInfo) {
            return ((WikiModuleInfo)obj).m_name.equals(this.m_name);
        }
        return false;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    protected void initializeFromXML(Element el) {
        this.m_description = el.getChildText("description");
        this.m_moduleUrl = el.getChildText("url");
        this.m_moduleVersion = el.getChildText("version");
        this.m_htmlTemplate = el.getChildText("template");
        this.m_scriptLocation = el.getChildText("script");
        this.m_stylesheetLocation = el.getChildText("stylesheet");
        this.m_author = el.getChildText("author");
        this.m_authorUrl = el.getChildText("authorUrl");
        this.m_minVersion = el.getChildText("minVersion");
        this.m_maxVersion = el.getChildText("maxVersion");
        this.m_adminBeanClass = el.getChildText("adminBean");
    }

    public String getAdminBeanClass() {
        return this.m_adminBeanClass;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getModuleUrl() {
        return this.m_moduleUrl;
    }

    public String getModuleVersion() {
        return this.m_moduleVersion;
    }

    public String getHtmlTemplate() {
        return this.m_htmlTemplate;
    }

    public String getStylesheetLocation() {
        return this.m_stylesheetLocation;
    }

    public String getScriptLocation() {
        return this.m_scriptLocation;
    }

    public String getAuthor() {
        return this.m_author;
    }

    public String getAuthorUrl() {
        return this.m_authorUrl;
    }

    public String getMinVersion() {
        return this.m_minVersion;
    }

    public String getMaxVersion() {
        return this.m_maxVersion;
    }

    protected String getTextResource(String resourceLocation) throws IOException {
        if (this.m_resource == null) {
            return "";
        }
        String spec = this.m_resource.toString();
        int length = "ini/jspwiki_module.xml".length();
        spec = spec.substring(0, spec.length() - length) + resourceLocation;
        URL url = new URL(spec);
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        FileUtil.copyContents((InputStream)in, (OutputStream)out);
        in.close();
        String text = out.toString();
        out.close();
        return text;
    }

    @Override
    public int compareTo(WikiModuleInfo arg0) {
        return this.m_name.compareTo(arg0.getName());
    }
}

