/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.pages;

import java.io.IOException;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiBackgroundThread;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.acl.Acl;
import org.apache.wiki.auth.acl.AclEntry;
import org.apache.wiki.auth.acl.AclEntryImpl;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.modules.ModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.pages.PageLock;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.pages.PageSorter;
import org.apache.wiki.providers.RepositoryModifiedException;
import org.apache.wiki.providers.WikiPageProvider;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;

public class DefaultPageManager
extends ModuleManager
implements PageManager {
    private static final Logger LOG = Logger.getLogger(DefaultPageManager.class);
    private WikiPageProvider m_provider;
    protected ConcurrentHashMap<String, PageLock> m_pageLocks = new ConcurrentHashMap();
    private int m_expiryTime = 60;
    private LockReaper m_reaper = null;
    private PageSorter pageSorter = new PageSorter();

    public DefaultPageManager(WikiEngine engine, Properties props) throws WikiException {
        super(engine);
        this.m_engine = engine;
        boolean useCache = "true".equals(props.getProperty("jspwiki.usePageCache"));
        this.m_expiryTime = TextUtil.parseIntParameter((String)props.getProperty("jspwiki.lockExpiryTime"), (int)60);
        String classname = useCache ? "org.apache.wiki.providers.CachingProvider" : this.m_engine.getRequiredProperty(props, "jspwiki.pageProvider");
        this.pageSorter.initialize(props);
        try {
            LOG.debug((Object)("Page provider class: '" + classname + "'"));
            Class providerclass = ClassUtil.findClass((String)"org.apache.wiki.providers", (String)classname);
            this.m_provider = (WikiPageProvider)providerclass.newInstance();
            LOG.debug((Object)("Initializing page provider class " + this.m_provider));
            this.m_provider.initialize(this.m_engine, props);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Unable to locate provider class '" + classname + "' (" + e.getMessage() + ")"), (Throwable)e);
            throw new WikiException("No provider class. (" + e.getMessage() + ")", e);
        }
        catch (InstantiationException e) {
            LOG.error((Object)("Unable to create provider class '" + classname + "' (" + e.getMessage() + ")"), (Throwable)e);
            throw new WikiException("Faulty provider class. (" + e.getMessage() + ")", e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Illegal access to provider class '" + classname + "' (" + e.getMessage() + ")"), (Throwable)e);
            throw new WikiException("Illegal provider class. (" + e.getMessage() + ")", e);
        }
        catch (NoRequiredPropertyException e) {
            LOG.error((Object)("Provider did not found a property it was looking for: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOG.error((Object)("An I/O exception occurred while trying to create a new page provider: " + classname), (Throwable)e);
            throw new WikiException("Unable to start page provider: " + e.getMessage(), e);
        }
    }

    @Override
    public WikiPageProvider getProvider() {
        return this.m_provider;
    }

    @Override
    public Collection<WikiPage> getAllPages() throws ProviderException {
        return this.m_provider.getAllPages();
    }

    @Override
    public String getPageText(String pageName, int version) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        String text = null;
        try {
            text = this.m_provider.getPageText(pageName, version);
        }
        catch (RepositoryModifiedException e) {
            LOG.info((Object)("Repository has been modified externally while fetching page " + pageName));
            WikiPage p = this.m_provider.getPageInfo(pageName, version);
            this.m_engine.updateReferences(p);
            if (p != null) {
                this.m_engine.getSearchManager().reindexPage(p);
                text = this.m_provider.getPageText(pageName, version);
            }
            WikiPage dummy = new WikiPage(this.m_engine, pageName);
            this.m_engine.getSearchManager().pageRemoved(dummy);
            this.m_engine.getReferenceManager().pageRemoved(dummy);
        }
        return text;
    }

    @Override
    public WikiEngine getEngine() {
        return this.m_engine;
    }

    @Override
    public void putPageText(WikiPage page, String content) throws ProviderException {
        if (page == null || page.getName() == null || page.getName().length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        this.m_provider.putPageText(page, content);
    }

    @Override
    public PageLock lockPage(WikiPage page, String user) {
        if (this.m_reaper == null) {
            this.m_reaper = new LockReaper(this.m_engine);
            this.m_reaper.start();
        }
        this.fireEvent(10, page.getName());
        PageLock lock = this.m_pageLocks.get(page.getName());
        if (lock == null) {
            Date d = new Date();
            lock = new PageLock(page, user, d, new Date(d.getTime() + (long)(this.m_expiryTime * 60) * 1000L));
            this.m_pageLocks.put(page.getName(), lock);
            LOG.debug((Object)("Locked page " + page.getName() + " for " + user));
        } else {
            LOG.debug((Object)("Page " + page.getName() + " already locked by " + lock.getLocker()));
            lock = null;
        }
        return lock;
    }

    @Override
    public void unlockPage(PageLock lock) {
        if (lock == null) {
            return;
        }
        this.m_pageLocks.remove(lock.getPage());
        LOG.debug((Object)("Unlocked page " + lock.getPage()));
        this.fireEvent(11, lock.getPage());
    }

    @Override
    public PageLock getCurrentLock(WikiPage page) {
        return this.m_pageLocks.get(page.getName());
    }

    @Override
    public List<PageLock> getActiveLocks() {
        ArrayList<PageLock> result = new ArrayList<PageLock>();
        for (PageLock lock : this.m_pageLocks.values()) {
            result.add(lock);
        }
        return result;
    }

    @Override
    public WikiPage getPageInfo(String pageName, int version) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name '" + pageName + "'");
        }
        WikiPage page = null;
        try {
            page = this.m_provider.getPageInfo(pageName, version);
        }
        catch (RepositoryModifiedException e) {
            LOG.info((Object)("Repository has been modified externally while fetching info for " + pageName));
            page = this.m_provider.getPageInfo(pageName, version);
            if (page != null) {
                this.m_engine.updateReferences(page);
            }
            this.m_engine.getReferenceManager().pageRemoved(new WikiPage(this.m_engine, pageName));
        }
        return page;
    }

    @Override
    public List<WikiPage> getVersionHistory(String pageName) throws ProviderException {
        if (this.pageExists(pageName)) {
            return this.m_provider.getVersionHistory(pageName);
        }
        return null;
    }

    @Override
    public String getProviderDescription() {
        return this.m_provider.getProviderInfo();
    }

    @Override
    public int getTotalPageCount() {
        try {
            return this.m_provider.getAllPages().size();
        }
        catch (ProviderException e) {
            LOG.error((Object)"Unable to count pages: ", (Throwable)e);
            return -1;
        }
    }

    @Override
    public boolean pageExists(String pageName) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        return this.m_provider.pageExists(pageName);
    }

    @Override
    public boolean pageExists(String pageName, int version) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        if (version == -1) {
            return this.pageExists(pageName);
        }
        return this.m_provider.pageExists(pageName, version);
    }

    @Override
    public void deleteVersion(WikiPage page) throws ProviderException {
        this.m_provider.deleteVersion(page.getName(), page.getVersion());
    }

    @Override
    public void deletePage(WikiPage page) throws ProviderException {
        this.fireEvent(26, page.getName());
        this.m_provider.deletePage(page.getName());
        this.fireEvent(27, page.getName());
    }

    protected final void fireEvent(int type, String pagename) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiPageEvent(this.m_engine, type, pagename));
        }
    }

    @Override
    public Collection<WikiModuleInfo> modules() {
        return new ArrayList<WikiModuleInfo>();
    }

    @Override
    public WikiModuleInfo getModuleInfo(String moduleName) {
        return null;
    }

    @Override
    public void actionPerformed(WikiEvent event) {
        if (!(event instanceof WikiSecurityEvent)) {
            return;
        }
        WikiSecurityEvent se = (WikiSecurityEvent)event;
        if (se.getType() == 54) {
            UserProfile[] profiles = (UserProfile[])se.getTarget();
            Principal[] oldPrincipals = new Principal[]{new WikiPrincipal(profiles[0].getLoginName()), new WikiPrincipal(profiles[0].getFullname()), new WikiPrincipal(profiles[0].getWikiName())};
            WikiPrincipal newPrincipal = new WikiPrincipal(profiles[1].getFullname());
            try {
                int pagesChanged = 0;
                Collection<WikiPage> pages = this.getAllPages();
                for (WikiPage page : pages) {
                    boolean aclChanged = this.changeAcl(page, oldPrincipals, newPrincipal);
                    if (!aclChanged) continue;
                    try {
                        this.m_engine.getAclManager().setPermissions(page, page.getAcl());
                    }
                    catch (WikiSecurityException e) {
                        LOG.error((Object)("Could not change page ACL for page " + page.getName() + ": " + e.getMessage()), (Throwable)e);
                    }
                    ++pagesChanged;
                }
                LOG.info((Object)("Profile name change for '" + newPrincipal.toString() + "' caused " + pagesChanged + " page ACLs to change also."));
            }
            catch (ProviderException e) {
                LOG.error((Object)("Could not change user name in Page ACLs because of Provider error:" + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected boolean changeAcl(WikiPage page, Principal[] oldPrincipals, Principal newPrincipal) {
        Acl acl = page.getAcl();
        boolean pageChanged = false;
        if (acl != null) {
            Enumeration<AclEntry> entries = acl.entries();
            ArrayList<AclEntryImpl> entriesToAdd = new ArrayList<AclEntryImpl>();
            ArrayList<AclEntry> entriesToRemove = new ArrayList<AclEntry>();
            while (entries.hasMoreElements()) {
                AclEntry entry = entries.nextElement();
                if (!ArrayUtils.contains((Object[])oldPrincipals, (Object)entry.getPrincipal())) continue;
                AclEntryImpl aclEntryImpl = new AclEntryImpl();
                aclEntryImpl.setPrincipal(newPrincipal);
                Enumeration<Permission> permissions = entry.permissions();
                while (permissions.hasMoreElements()) {
                    Permission permission = permissions.nextElement();
                    aclEntryImpl.addPermission(permission);
                }
                pageChanged = true;
                entriesToRemove.add(entry);
                entriesToAdd.add(aclEntryImpl);
            }
            for (AclEntry aclEntry : entriesToRemove) {
                acl.removeEntry(aclEntry);
            }
            for (AclEntry aclEntry : entriesToAdd) {
                acl.addEntry(aclEntry);
            }
        }
        return pageChanged;
    }

    @Override
    public PageSorter getPageSorter() {
        return this.pageSorter;
    }

    private class LockReaper
    extends WikiBackgroundThread {
        public LockReaper(WikiEngine engine) {
            super(engine, 60);
            this.setName("JSPWiki Lock Reaper");
        }

        @Override
        public void backgroundTask() throws Exception {
            Collection<PageLock> entries = DefaultPageManager.this.m_pageLocks.values();
            Iterator<PageLock> i = entries.iterator();
            while (i.hasNext()) {
                PageLock p = i.next();
                if (!p.isExpired()) continue;
                i.remove();
                LOG.debug((Object)("Reaped lock: " + p.getPage() + " by " + p.getLocker() + ", acquired " + p.getAcquisitionTime() + ", and expired " + p.getExpiryTime()));
            }
        }
    }
}

