/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.pages;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.comparators.JavaNaturalComparator;

public class PageSorter
implements Comparator<String> {
    private static final Logger LOG = Logger.getLogger(PageSorter.class);
    protected static final String PROP_PAGE_NAME_COMPARATOR = "jspwiki.pageNameComparator.class";
    private Comparator<String> m_comparator;

    public PageSorter() {
        this.m_comparator = JavaNaturalComparator.DEFAULT_JAVA_COMPARATOR;
    }

    public PageSorter(Comparator<String> comparator) {
        this.m_comparator = comparator;
    }

    @Override
    public int compare(String pageName1, String pageName2) {
        return this.m_comparator.compare(pageName1, pageName2);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PageSorter)) {
            return false;
        }
        PageSorter that = (PageSorter)o;
        if (this == that || this.m_comparator == that.m_comparator) {
            return true;
        }
        return this.m_comparator.equals(that.m_comparator);
    }

    public void initialize(Properties props) {
        this.m_comparator = JavaNaturalComparator.DEFAULT_JAVA_COMPARATOR;
        String className = props.getProperty(PROP_PAGE_NAME_COMPARATOR);
        if (className != null && className.length() > 0) {
            try {
                this.m_comparator = (Comparator)ClassUtil.findClass((String)"org.apache.wiki.util.comparators", (String)className).newInstance();
            }
            catch (Exception e) {
                LOG.error((Object)"Falling back to default \"natural\" comparator", (Throwable)e);
            }
        }
    }

    public void sort(List<String> nameList) {
        Collections.sort(nameList, this.m_comparator);
    }

    public void sort(String[] nameArray) {
        Arrays.sort(nameArray, this.m_comparator);
    }
}

