/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.Map;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.util.TextUtil;

public class Counter
implements WikiPlugin {
    public static final String PARAM_NAME = "name";
    public static final String PARAM_INCREMENT = "increment";
    public static final String PARAM_SHOW_RESULT = "showResult";
    public static final String PARAM_START = "start";
    public static final String DEFAULT_NAME = "counter";
    private static final int DEFAULT_INCREMENT = 1;
    private static final boolean DEFAULT_SHOW_RESULT = true;

    @Override
    public String execute(WikiContext context, Map<String, String> params) throws PluginException {
        String start;
        String countername = params.get(PARAM_NAME);
        countername = countername == null ? DEFAULT_NAME : "counter-" + countername;
        Integer val = (Integer)context.getVariable(countername);
        if (val == null) {
            val = 0;
        }
        if ((start = params.get(PARAM_START)) != null) {
            val = Integer.parseInt(start);
        } else {
            String incrementObj = params.get(PARAM_INCREMENT);
            int increment = 1;
            if (incrementObj != null) {
                increment = Integer.valueOf(incrementObj);
            }
            val = val + increment;
        }
        context.setVariable(countername, val);
        String showObj = params.get(PARAM_SHOW_RESULT);
        boolean show = true;
        if (showObj != null) {
            show = TextUtil.isPositive((String)showObj);
        }
        if (show) {
            return val.toString();
        }
        return "";
    }
}

