/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.TextUtil;

public class InsertPage
implements WikiPlugin {
    public static final String PARAM_PAGENAME = "page";
    public static final String PARAM_STYLE = "style";
    public static final String PARAM_MAXLENGTH = "maxlength";
    public static final String PARAM_CLASS = "class";
    public static final String PARAM_SHOW = "show";
    public static final String PARAM_SECTION = "section";
    public static final String PARAM_DEFAULT = "default";
    private static final String DEFAULT_STYLE = "";
    private static final String ONCE_COOKIE = "JSPWiki.Once.";
    public static final String ATTR_RECURSE = "org.apache.wiki.plugin.InsertPage.recurseCheck";

    @Override
    public String execute(WikiContext context, Map<String, String> params) throws PluginException {
        WikiEngine engine = context.getEngine();
        StringBuilder res = new StringBuilder();
        String clazz = params.get(PARAM_CLASS);
        String includedPage = params.get(PARAM_PAGENAME);
        String style = params.get(PARAM_STYLE);
        Boolean showOnce = "once".equals(params.get(PARAM_SHOW));
        String defaultstr = params.get(PARAM_DEFAULT);
        int section = TextUtil.parseIntParameter((String)params.get(PARAM_SECTION), (int)-1);
        int maxlen = TextUtil.parseIntParameter((String)params.get(PARAM_MAXLENGTH), (int)-1);
        ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
        if (style == null) {
            style = DEFAULT_STYLE;
        }
        if (maxlen == -1) {
            maxlen = Integer.MAX_VALUE;
        }
        if (includedPage != null) {
            WikiPage page = null;
            try {
                String pageName = engine.getFinalPageName(includedPage);
                page = pageName != null ? engine.getPage(pageName) : engine.getPage(includedPage);
            }
            catch (ProviderException e) {
                res.append("<span class=\"error\">Page could not be found by the page provider.</span>");
                return res.toString();
            }
            if (page != null) {
                AuthorizationManager mgr;
                ArrayList<String> previousIncludes = (ArrayList<String>)context.getVariable(ATTR_RECURSE);
                if (previousIncludes != null) {
                    if (previousIncludes.contains(page.getName())) {
                        return "<span class=\"error\">Error: Circular reference - you can't include a page in itself!</span>";
                    }
                } else {
                    previousIncludes = new ArrayList<String>();
                }
                if (!(mgr = engine.getAuthorizationManager()).checkPermission(context.getWikiSession(), PermissionFactory.getPagePermission(page, "view"))) {
                    res.append("<span class=\"error\">You do not have permission to view this included page.</span>");
                    return res.toString();
                }
                String cookieName = DEFAULT_STYLE;
                if (showOnce.booleanValue()) {
                    cookieName = ONCE_COOKIE + TextUtil.urlEncodeUTF8((String)page.getName()).replaceAll("\\+", "%20");
                    if (HttpUtil.retrieveCookieValue((HttpServletRequest)context.getHttpRequest(), (String)cookieName) != null) {
                        return DEFAULT_STYLE;
                    }
                }
                previousIncludes.add(page.getName());
                context.setVariable(ATTR_RECURSE, previousIncludes);
                WikiContext includedContext = (WikiContext)context.clone();
                includedContext.setPage(page);
                String pageData = engine.getPureText(page);
                String moreLink = DEFAULT_STYLE;
                if (section != -1) {
                    try {
                        pageData = TextUtil.getSection((String)pageData, (int)section);
                    }
                    catch (IllegalArgumentException e) {
                        throw new PluginException(e.getMessage());
                    }
                }
                if (pageData.length() > maxlen) {
                    pageData = pageData.substring(0, maxlen) + " ...";
                    moreLink = "<p><a href=\"" + context.getURL(WikiContext.VIEW, includedPage) + "\">" + rb.getString("insertpage.more") + "</a></p>";
                }
                res.append("<div class=\"inserted-page ");
                if (clazz != null) {
                    res.append(clazz);
                }
                if (style != DEFAULT_STYLE) {
                    res.append("\" style=\"" + style);
                }
                if (showOnce.booleanValue()) {
                    res.append("\" data-once=\"" + cookieName);
                }
                res.append("\" >");
                res.append(engine.textToHTML(includedContext, pageData));
                res.append(moreLink);
                res.append("</div>");
                previousIncludes.remove(page.getName());
                context.setVariable(ATTR_RECURSE, previousIncludes);
            } else if (defaultstr != null) {
                res.append(defaultstr);
            } else {
                res.append("There is no page called '" + includedPage + "'.  Would you like to ");
                res.append("<a href=\"" + context.getURL(WikiContext.EDIT, includedPage) + "\">create it?</a>");
            }
        } else {
            res.append("<span class=\"error\">");
            res.append("You have to define a page!");
            res.append("</span>");
        }
        return res.toString();
    }
}

