/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.Map;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.util.TextUtil;

public class Note
implements WikiPlugin {
    public static final String PROP_NOTE_IMAGE = "notePlugin.imageName";
    public static final String DEFAULT_NOTE_IMAGE = "note.png";

    @Override
    public String execute(WikiContext context, Map<String, String> params) throws PluginException {
        String commandline = params.get("_cmdline");
        if (commandline == null || commandline.length() == 0) {
            return "Unable to obtain plugin command line from parameter'_cmdline'";
        }
        String commentImage = this.imageUrl(context);
        String commentText = this.clean(commandline);
        return "<img src='" + commentImage + "' alt=\"Comment: " + commentText + "\" title=\"" + commentText + "\"/>";
    }

    private String imageUrl(WikiContext ctx) {
        WikiEngine engine = ctx.getEngine();
        String commentImage = engine.getWikiProperties().getProperty(PROP_NOTE_IMAGE, DEFAULT_NOTE_IMAGE);
        commentImage = "images/" + commentImage;
        String resource = engine.getTemplateManager().findResource(ctx, engine.getTemplateDir(), commentImage);
        if (resource != null && resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        return ctx.getURL(WikiContext.NONE, resource);
    }

    private String clean(String commandline) {
        return TextUtil.replaceEntities((String)commandline);
    }
}

