/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.util.TextUtil;

public class SessionsPlugin
implements WikiPlugin {
    public static final String PARAM_PROP = "property";

    @Override
    public String execute(WikiContext context, Map<String, String> params) throws PluginException {
        WikiEngine engine = context.getEngine();
        String prop = params.get(PARAM_PROP);
        if ("users".equals(prop)) {
            Principal[] principals = WikiSession.userPrincipals(engine);
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < principals.length; ++i) {
                s.append(principals[i].getName() + ", ");
            }
            return TextUtil.replaceEntities((String)s.substring(0, s.length() - (s.length() > 2 ? 2 : 0)));
        }
        if ("distinctUsers".equals(prop)) {
            Principal[] principals = WikiSession.userPrincipals(engine);
            HashMap<String, Integer> distinctPrincipals = new HashMap<String, Integer>();
            for (int i = 0; i < principals.length; ++i) {
                String principalName = principals[i].getName();
                if (distinctPrincipals.containsKey(principalName)) {
                    int numSessions = (Integer)distinctPrincipals.get(principalName);
                    distinctPrincipals.put(principalName, ++numSessions);
                    continue;
                }
                distinctPrincipals.put(principalName, 1);
            }
            StringBuilder s = new StringBuilder();
            for (Map.Entry entry : distinctPrincipals.entrySet()) {
                s.append((String)entry.getKey() + "(" + ((Integer)entry.getValue()).toString() + "), ");
            }
            return TextUtil.replaceEntities((String)s.substring(0, s.length() - (s.length() > 2 ? 2 : 0)));
        }
        return String.valueOf(WikiSession.sessions(engine));
    }
}

