/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.pages.PageLock;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.plugin.WeblogPlugin;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.TextUtil;

public class WeblogEntryPlugin
implements WikiPlugin {
    private static Logger log = Logger.getLogger(WeblogEntryPlugin.class);
    private static final int MAX_BLOG_ENTRIES = 10000;
    public static final String PARAM_ENTRYTEXT = "entrytext";
    public static final String PARAM_BLOGNAME = "page";

    public String getNewEntryPage(WikiEngine engine, String blogName) throws ProviderException {
        SimpleDateFormat fmt = new SimpleDateFormat("ddMMyy");
        String today = fmt.format(new Date());
        int entryNum = this.findFreeEntry(engine.getPageManager(), blogName, today);
        String blogPage = WeblogPlugin.makeEntryPage(blogName, today, "" + entryNum);
        return blogPage;
    }

    @Override
    public String execute(WikiContext context, Map<String, String> params) throws PluginException {
        ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
        String weblogName = params.get(PARAM_BLOGNAME);
        if (weblogName == null) {
            weblogName = context.getPage().getName();
        }
        WikiEngine engine = context.getEngine();
        StringBuilder sb = new StringBuilder();
        String entryText = TextUtil.replaceEntities((String)params.get(PARAM_ENTRYTEXT));
        if (entryText == null) {
            entryText = rb.getString("weblogentryplugin.newentry");
        }
        String url = context.getURL(WikiContext.NONE, "NewBlogEntry.jsp", "page=" + engine.encodeName(weblogName));
        sb.append("<a href=\"" + url + "\">" + entryText + "</a>");
        return sb.toString();
    }

    private int findFreeEntry(PageManager mgr, String baseName, String date) throws ProviderException {
        WikiPage page;
        PageLock lock;
        int idx;
        Collection<WikiPage> everyone = mgr.getAllPages();
        int max = 0;
        String startString = WeblogPlugin.makeEntryPage(baseName, date, "");
        for (WikiPage p : everyone) {
            if (!p.getName().startsWith(startString)) continue;
            try {
                String probableId = p.getName().substring(startString.length());
                int id = Integer.parseInt(probableId);
                if (id <= max) continue;
                max = id;
            }
            catch (NumberFormatException e) {
                log.debug((Object)("Was not a log entry: " + p.getName()));
            }
        }
        for (idx = max + 1; idx < 10000 && (lock = mgr.getCurrentLock(page = new WikiPage(mgr.getEngine(), WeblogPlugin.makeEntryPage(baseName, date, Integer.toString(idx))))) != null; ++idx) {
        }
        return idx;
    }
}

