/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.providers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.providers.AbstractFileProvider;

public class FileSystemProvider
extends AbstractFileProvider {
    private static final Logger log = Logger.getLogger(FileSystemProvider.class);
    public static final String PROP_EXT = ".properties";

    @Override
    public void putPageText(WikiPage page, String text) throws ProviderException {
        try {
            super.putPageText(page, text);
            this.putPageProperties(page);
        }
        catch (IOException e) {
            log.error((Object)"Saving failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putPageProperties(WikiPage page) throws IOException {
        Properties props = new Properties();
        try (OutputStream out = null;){
            String author = page.getAuthor();
            String changenote = (String)page.getAttribute("changenote");
            String viewcount = (String)page.getAttribute("viewcount");
            if (author != null) {
                props.setProperty("author", author);
            }
            if (changenote != null) {
                props.setProperty("changenote", changenote);
            }
            if (viewcount != null) {
                props.setProperty("viewcount", viewcount);
            }
            this.getCustomProperties(page, props);
            File file = new File(this.getPageDirectory(), this.mangleName(page.getName()) + PROP_EXT);
            out = new FileOutputStream(file);
            props.store(out, "JSPWiki page properties for page " + page.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPageProperties(WikiPage page) throws IOException {
        Properties props = new Properties();
        try (InputStream in = null;){
            File file = new File(this.getPageDirectory(), this.mangleName(page.getName()) + PROP_EXT);
            if (file.exists()) {
                String viewcount;
                in = new FileInputStream(file);
                props.load(in);
                page.setAuthor(props.getProperty("author"));
                String changenote = props.getProperty("changenote");
                if (changenote != null) {
                    page.setAttribute("changenote", changenote);
                }
                if ((viewcount = props.getProperty("viewcount")) != null) {
                    page.setAttribute("viewcount", viewcount);
                }
                this.setCustomProperties(page, props);
            }
        }
    }

    @Override
    public WikiPage getPageInfo(String page, int version) throws ProviderException {
        WikiPage p = super.getPageInfo(page, version);
        if (p != null) {
            try {
                this.getPageProperties(p);
            }
            catch (IOException e) {
                log.error((Object)"Unable to read page properties", (Throwable)e);
                throw new ProviderException("Unable to read page properties, check logs.");
            }
        }
        return p;
    }

    @Override
    public void deletePage(String pageName) throws ProviderException {
        super.deletePage(pageName);
        File file = new File(this.getPageDirectory(), this.mangleName(pageName) + PROP_EXT);
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void movePage(String from, String to) throws ProviderException {
        File fromPage = this.findPage(from);
        File toPage = this.findPage(to);
        fromPage.renameTo(toPage);
    }
}

