/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.render;

import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.render.WikiRenderer;
import org.jdom2.Text;
import org.jdom2.xpath.XPathFactory;

public class CleanTextRenderer
extends WikiRenderer {
    private static final String ALL_TEXT_NODES = "//text()";
    private static final Logger log = Logger.getLogger(CleanTextRenderer.class);

    public CleanTextRenderer(WikiContext context, WikiDocument doc) {
        super(context, doc);
    }

    @Override
    public String getString() throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            List nodes = XPathFactory.instance().compile(ALL_TEXT_NODES).evaluate((Object)this.m_document.getDocument());
            for (Object el : nodes) {
                if (!(el instanceof Text)) continue;
                sb.append(((Text)el).getValue());
            }
        }
        catch (IllegalStateException e) {
            log.error((Object)"Could not parse XPATH expression");
            throw new IOException(e.getMessage(), e);
        }
        return sb.toString();
    }
}

