/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.render;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.wiki.WikiContext;
import org.apache.wiki.htmltowiki.XHtmlToWikiConfig;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.render.CustomXMLOutputProcessor;
import org.apache.wiki.render.WikiRenderer;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.output.support.XMLOutputProcessor;

public class WysiwygEditingRenderer
extends WikiRenderer {
    private static final String A_ELEMENT = "a";
    private static final String IMG_ELEMENT = "img";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String HREF_ATTRIBUTE = "href";
    private static final String TITLE_ATTRIBUTE = "title";
    private static final String LINEBREAK = "\n";

    public WysiwygEditingRenderer(WikiContext context, WikiDocument doc) {
        super(context, doc);
    }

    private void processChildren(Element baseElement) {
        Iterator itr = baseElement.getChildren().iterator();
        while (itr.hasNext()) {
            String classValue;
            Element element = (Element)itr.next();
            String elementName = element.getName().toLowerCase();
            Attribute classAttr = element.getAttribute(CLASS_ATTRIBUTE);
            if (elementName.equals(A_ELEMENT)) {
                if (classAttr != null) {
                    classValue = classAttr.getValue();
                    Attribute hrefAttr = element.getAttribute(HREF_ATTRIBUTE);
                    XHtmlToWikiConfig wikiConfig = new XHtmlToWikiConfig(this.m_context);
                    String wikiPageLinkUrl = wikiConfig.getWikiJspPage();
                    String editPageLinkUrl = wikiConfig.getEditJspPage();
                    if (hrefAttr != null && hrefAttr.getValue().startsWith(wikiPageLinkUrl)) {
                        String newHref = hrefAttr.getValue().substring(wikiPageLinkUrl.length());
                        newHref = this.m_context.getEngine().decodeName(newHref);
                        hrefAttr.setValue(newHref.replaceFirst("(.+)#section-.+-(.+)", "$1#$2"));
                    } else if (hrefAttr != null && hrefAttr.getValue().startsWith(editPageLinkUrl)) {
                        Attribute titleAttr = element.getAttribute(TITLE_ATTRIBUTE);
                        if (titleAttr != null) {
                            titleAttr.detach();
                        }
                        String newHref = hrefAttr.getValue().substring(editPageLinkUrl.length());
                        newHref = this.m_context.getEngine().decodeName(newHref);
                        hrefAttr.setValue(newHref);
                    } else if (classValue.equals("hashlink")) {
                        itr.remove();
                        continue;
                    }
                }
            } else if (elementName.equals(IMG_ELEMENT) && classAttr != null && (classValue = classAttr.getValue()).equals("outlink")) {
                itr.remove();
                continue;
            }
            this.processChildren(element);
        }
    }

    @Override
    public String getString() throws IOException {
        Element rootElement = this.m_document.getRootElement();
        this.processChildren(rootElement);
        this.m_document.setContext(this.m_context);
        CustomXMLOutputProcessor processor = new CustomXMLOutputProcessor();
        XMLOutputter output = new XMLOutputter((XMLOutputProcessor)processor);
        StringWriter out = new StringWriter();
        Format fmt = Format.getRawFormat();
        fmt.setExpandEmptyElements(false);
        fmt.setLineSeparator(LINEBREAK);
        output.setFormat(fmt);
        output.outputElementContent(this.m_document.getRootElement(), (Writer)out);
        return out.toString();
    }
}

