/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.rss;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.exceptions.NoSuchVariableException;
import org.apache.wiki.rss.Entry;

public abstract class Feed {
    protected List<Entry> m_entries = new ArrayList<Entry>();
    protected String m_feedURL;
    protected String m_channelTitle;
    protected String m_channelDescription;
    protected String m_channelLanguage;
    protected WikiContext m_wikiContext;
    protected String m_mode = "wiki";
    public static final String VAR_BLOGNAME = "blogname";

    public static String getSiteName(WikiContext context) {
        WikiEngine engine = context.getEngine();
        String blogname = null;
        try {
            blogname = engine.getVariableManager().getValue(context, VAR_BLOGNAME);
        }
        catch (NoSuchVariableException noSuchVariableException) {
            // empty catch block
        }
        if (blogname == null) {
            blogname = engine.getApplicationName() + ": " + context.getPage().getName();
        }
        return blogname;
    }

    public Feed(WikiContext context) {
        this.m_wikiContext = context;
    }

    public void setMode(String mode) {
        this.m_mode = mode;
    }

    public void addEntry(Entry e) {
        this.m_entries.add(e);
    }

    public abstract String getString();

    public String getChannelDescription() {
        return this.m_channelDescription;
    }

    public void setChannelDescription(String description) {
        this.m_channelDescription = description;
    }

    public String getChannelLanguage() {
        return this.m_channelLanguage;
    }

    public void setChannelLanguage(String language) {
        this.m_channelLanguage = language;
    }

    public String getChannelTitle() {
        return this.m_channelTitle;
    }

    public void setChannelTitle(String title) {
        this.m_channelTitle = title;
    }

    public String getFeedURL() {
        return this.m_feedURL;
    }

    public void setFeedURL(String feedurl) {
        this.m_feedURL = feedurl;
    }

    protected String getMimeType(ServletContext c, String name) {
        String type = c.getMimeType(name);
        if (type == null) {
            type = "application/octet-stream";
        }
        return type;
    }

    public static String format(String s) {
        return StringEscapeUtils.escapeXml11((String)s);
    }
}

