/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.rss;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.pages.PageTimeComparator;
import org.apache.wiki.rss.AtomFeed;
import org.apache.wiki.rss.Entry;
import org.apache.wiki.rss.Feed;
import org.apache.wiki.rss.RSS10Feed;
import org.apache.wiki.rss.RSS20Feed;
import org.apache.wiki.util.TextUtil;

public class RSSGenerator {
    static Logger log = Logger.getLogger(RSSGenerator.class);
    private WikiEngine m_engine;
    private String m_channelDescription = "";
    private String m_channelLanguage = "en-us";
    private boolean m_enabled = true;
    public static final String RSS10 = "rss10";
    public static final String RSS20 = "rss20";
    public static final String ATOM = "atom";
    public static final String MODE_BLOG = "blog";
    public static final String MODE_WIKI = "wiki";
    public static final String MODE_FULL = "full";
    public static final String PROP_CHANNEL_DESCRIPTION = "jspwiki.rss.channelDescription";
    public static final String PROP_CHANNEL_LANGUAGE = "jspwiki.rss.channelLanguage";
    public static final String PROP_CHANNEL_TITLE = "jspwiki.rss.channelTitle";
    public static final String PROP_GENERATE_RSS = "jspwiki.rss.generate";
    public static final String PROP_RSSFILE = "jspwiki.rss.fileName";
    public static final String PROP_INTERVAL = "jspwiki.rss.interval";
    public static final String PROP_RSS_AUTHOR = "jspwiki.rss.author";
    public static final String PROP_RSS_AUTHOREMAIL = "jspwiki.rss.author.email";
    private static final int MAX_CHARACTERS = 0x7FFFFFFE;

    public RSSGenerator(WikiEngine engine, Properties properties) {
        this.m_engine = engine;
        this.m_channelDescription = properties.getProperty(PROP_CHANNEL_DESCRIPTION, this.m_channelDescription);
        this.m_channelLanguage = properties.getProperty(PROP_CHANNEL_LANGUAGE, this.m_channelLanguage);
    }

    public static String format(String s) {
        s = TextUtil.replaceString((String)s, (String)"&", (String)"&amp;");
        s = TextUtil.replaceString((String)s, (String)"<", (String)"&lt;");
        s = TextUtil.replaceString((String)s, (String)"]]>", (String)"]]&gt;");
        return s.trim();
    }

    private String getAuthor(WikiPage page) {
        String author = page.getAuthor();
        if (author == null) {
            author = "An unknown author";
        }
        return author;
    }

    private String getAttachmentDescription(Attachment att) {
        String author = this.getAuthor(att);
        StringBuilder sb = new StringBuilder();
        if (att.getVersion() != 1) {
            sb.append(author + " uploaded a new version of this attachment on " + att.getLastModified());
        } else {
            sb.append(author + " created this attachment on " + att.getLastModified());
        }
        sb.append("<br /><hr /><br />");
        sb.append("Parent page: <a href=\"" + this.m_engine.getURL(WikiContext.VIEW, att.getParentName(), null, true) + "\">" + att.getParentName() + "</a><br />");
        sb.append("Info page: <a href=\"" + this.m_engine.getURL(WikiContext.INFO, att.getName(), null, true) + "\">" + att.getName() + "</a>");
        return sb.toString();
    }

    private String getPageDescription(WikiPage page) {
        StringBuilder buf = new StringBuilder();
        String author = this.getAuthor(page);
        WikiContext ctx = new WikiContext(this.m_engine, page);
        if (page.getVersion() > 1) {
            String diff = this.m_engine.getDiff(ctx, page.getVersion() - 1, page.getVersion());
            buf.append(author + " changed this page on " + page.getLastModified() + ":<br /><hr /><br />");
            buf.append(diff);
        } else {
            buf.append(author + " created this page on " + page.getLastModified() + ":<br /><hr /><br />");
            buf.append(this.m_engine.getHTML(page.getName()));
        }
        return buf.toString();
    }

    private String getEntryDescription(WikiPage page) {
        String res = page instanceof Attachment ? this.getAttachmentDescription((Attachment)page) : this.getPageDescription(page);
        return res;
    }

    private String getEntryTitle(WikiPage page) {
        return page.getName() + ", version " + page.getVersion();
    }

    public String generate() {
        WikiContext context = new WikiContext(this.m_engine, new WikiPage(this.m_engine, "__DUMMY"));
        context.setRequestContext(WikiContext.RSS);
        RSS10Feed feed = new RSS10Feed(context);
        String result = this.generateFullWikiRSS(context, feed);
        result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + result;
        return result;
    }

    public static String getContentType(String mode) {
        if (mode.equals(RSS10) || mode.equals(RSS20)) {
            return "application/rss+xml";
        }
        if (mode.equals(ATOM)) {
            return "application/atom+xml";
        }
        return "application/octet-stream";
    }

    public String generateFeed(WikiContext wikiContext, List<WikiPage> changed, String mode, String type) throws ProviderException, IllegalArgumentException {
        Feed feed = null;
        String res = null;
        feed = ATOM.equals(type) ? new AtomFeed(wikiContext) : (RSS20.equals(type) ? new RSS20Feed(wikiContext) : new RSS10Feed(wikiContext));
        feed.setMode(mode);
        if (MODE_BLOG.equals(mode)) {
            res = this.generateBlogRSS(wikiContext, changed, feed);
        } else if (MODE_FULL.equals(mode)) {
            res = this.generateFullWikiRSS(wikiContext, feed);
        } else if (MODE_WIKI.equals(mode)) {
            res = this.generateWikiPageRSS(wikiContext, changed, feed);
        } else {
            throw new IllegalArgumentException("Invalid value for feed mode: " + mode);
        }
        return res;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public synchronized void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    protected String generateFullWikiRSS(WikiContext wikiContext, Feed feed) {
        feed.setChannelTitle(this.m_engine.getApplicationName());
        feed.setFeedURL(this.m_engine.getBaseURL());
        feed.setChannelLanguage(this.m_channelLanguage);
        feed.setChannelDescription(this.m_channelDescription);
        Set<WikiPage> changed = this.m_engine.getRecentChanges();
        WikiSession session = WikiSession.guestSession(this.m_engine);
        Iterator<WikiPage> i = changed.iterator();
        for (int items = 0; i.hasNext() && items < 15; ++items) {
            WikiPage page = i.next();
            if (!this.m_engine.getAuthorizationManager().checkPermission(session, new PagePermission(page, "view"))) continue;
            Entry e = new Entry();
            e.setPage(page);
            String url = page instanceof Attachment ? this.m_engine.getURL(WikiContext.ATTACH, page.getName(), null, true) : this.m_engine.getURL(WikiContext.VIEW, page.getName(), null, true);
            e.setURL(url);
            e.setTitle(page.getName());
            e.setContent(this.getEntryDescription(page));
            e.setAuthor(this.getAuthor(page));
            feed.addEntry(e);
        }
        return feed.getString();
    }

    protected String generateWikiPageRSS(WikiContext wikiContext, List<WikiPage> changed, Feed feed) {
        feed.setChannelTitle(this.m_engine.getApplicationName() + ": " + wikiContext.getPage().getName());
        feed.setFeedURL(wikiContext.getViewURL(wikiContext.getPage().getName()));
        String language = this.m_engine.getVariable(wikiContext, PROP_CHANNEL_LANGUAGE);
        if (language != null) {
            feed.setChannelLanguage(language);
        } else {
            feed.setChannelLanguage(this.m_channelLanguage);
        }
        String channelDescription = this.m_engine.getVariable(wikiContext, PROP_CHANNEL_DESCRIPTION);
        if (channelDescription != null) {
            feed.setChannelDescription(channelDescription);
        }
        Collections.sort(changed, new PageTimeComparator());
        Iterator<WikiPage> i = changed.iterator();
        for (int items = 0; i.hasNext() && items < 15; ++items) {
            WikiPage page = i.next();
            Entry e = new Entry();
            e.setPage(page);
            String url = page instanceof Attachment ? this.m_engine.getURL(WikiContext.ATTACH, page.getName(), "version=" + page.getVersion(), true) : this.m_engine.getURL(WikiContext.VIEW, page.getName(), "version=" + page.getVersion(), true);
            url = TextUtil.replaceString((String)url, (String)"&amp;", (String)"&");
            e.setURL(url);
            e.setTitle(this.getEntryTitle(page));
            e.setContent(this.getEntryDescription(page));
            e.setAuthor(this.getAuthor(page));
            feed.addEntry(e);
        }
        return feed.getString();
    }

    protected String generateBlogRSS(WikiContext wikiContext, List<WikiPage> changed, Feed feed) throws ProviderException {
        String ctitle;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating RSS for blog, size=" + changed.size()));
        }
        if ((ctitle = this.m_engine.getVariable(wikiContext, PROP_CHANNEL_TITLE)) != null) {
            feed.setChannelTitle(ctitle);
        } else {
            feed.setChannelTitle(this.m_engine.getApplicationName() + ":" + wikiContext.getPage().getName());
        }
        feed.setFeedURL(wikiContext.getViewURL(wikiContext.getPage().getName()));
        String language = this.m_engine.getVariable(wikiContext, PROP_CHANNEL_LANGUAGE);
        if (language != null) {
            feed.setChannelLanguage(language);
        } else {
            feed.setChannelLanguage(this.m_channelLanguage);
        }
        String channelDescription = this.m_engine.getVariable(wikiContext, PROP_CHANNEL_DESCRIPTION);
        if (channelDescription != null) {
            feed.setChannelDescription(channelDescription);
        }
        Collections.sort(changed, new PageTimeComparator());
        Iterator<WikiPage> i = changed.iterator();
        for (int items = 0; i.hasNext() && items < 15; ++items) {
            WikiPage page = i.next();
            Entry e = new Entry();
            e.setPage(page);
            String url = page instanceof Attachment ? this.m_engine.getURL(WikiContext.ATTACH, page.getName(), null, true) : this.m_engine.getURL(WikiContext.VIEW, page.getName(), null, true);
            e.setURL(url);
            String pageText = this.m_engine.getPureText(page.getName(), -1);
            String title = "";
            int firstLine = pageText.indexOf(10);
            if (firstLine > 0) {
                title = pageText.substring(0, firstLine).trim();
            }
            if (title.length() == 0) {
                title = page.getName();
            }
            while (title.startsWith("!")) {
                title = title.substring(1);
            }
            e.setTitle(title);
            if (firstLine > 0) {
                int maxlen = pageText.length();
                if (maxlen > 0x7FFFFFFE) {
                    maxlen = 0x7FFFFFFE;
                }
                if (maxlen > 0) {
                    pageText = this.m_engine.textToHTML(wikiContext, pageText.substring(firstLine + 1, maxlen).trim());
                    if (maxlen == 0x7FFFFFFE) {
                        pageText = pageText + "...";
                    }
                    e.setContent(pageText);
                } else {
                    e.setContent(title);
                }
            } else {
                e.setContent(title);
            }
            e.setAuthor(this.getAuthor(page));
            feed.addEntry(e);
        }
        return feed.getString();
    }
}

