/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.search.QueryItem;
import org.apache.wiki.search.SearchMatcher;
import org.apache.wiki.search.SearchProvider;
import org.apache.wiki.search.SearchResult;
import org.apache.wiki.search.SearchResultComparator;

public class BasicSearchProvider
implements SearchProvider {
    private static final Logger log = Logger.getLogger(BasicSearchProvider.class);
    private WikiEngine m_engine;

    @Override
    public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException, IOException {
        this.m_engine = engine;
    }

    @Override
    public void pageRemoved(WikiPage page) {
    }

    @Override
    public void reindexPage(WikiPage page) {
    }

    public QueryItem[] parseQuery(String query) {
        StringTokenizer st = new StringTokenizer(query, " \t,");
        QueryItem[] items = new QueryItem[st.countTokens()];
        int word = 0;
        log.debug((Object)("Expecting " + items.length + " items"));
        while (st.hasMoreTokens()) {
            log.debug((Object)("Item " + word));
            String token = st.nextToken().toLowerCase();
            items[word] = new QueryItem();
            switch (token.charAt(0)) {
                case '+': {
                    items[word].type = 1;
                    token = token.substring(1);
                    log.debug((Object)("Required word: " + token));
                    break;
                }
                case '-': {
                    items[word].type = -1;
                    token = token.substring(1);
                    log.debug((Object)("Forbidden word: " + token));
                    break;
                }
                default: {
                    items[word].type = 0;
                    log.debug((Object)("Requested word: " + token));
                }
            }
            items[word++].word = token;
        }
        return items;
    }

    private String attachmentNames(WikiPage page, String separator) {
        if (this.m_engine.getAttachmentManager().hasAttachments(page)) {
            List<Attachment> attachments;
            try {
                attachments = this.m_engine.getAttachmentManager().listAttachments(page);
            }
            catch (ProviderException e) {
                log.error((Object)"Unable to get attachments for page", (Throwable)e);
                return "";
            }
            StringBuilder attachmentNames = new StringBuilder();
            Iterator<Attachment> it = attachments.iterator();
            while (it.hasNext()) {
                Attachment att = it.next();
                attachmentNames.append(att.getName());
                if (!it.hasNext()) continue;
                attachmentNames.append(separator);
            }
            return attachmentNames.toString();
        }
        return "";
    }

    private Collection<SearchResult> findPages(QueryItem[] query, WikiContext wikiContext) {
        TreeSet<SearchResult> res = new TreeSet<SearchResult>(new SearchResultComparator());
        SearchMatcher matcher = new SearchMatcher(this.m_engine, query);
        Collection<WikiPage> allPages = null;
        try {
            allPages = this.m_engine.getPageManager().getAllPages();
        }
        catch (ProviderException pe) {
            log.error((Object)"Unable to retrieve page list", (Throwable)pe);
            return null;
        }
        AuthorizationManager mgr = this.m_engine.getAuthorizationManager();
        Iterator<WikiPage> it = allPages.iterator();
        while (it.hasNext()) {
            try {
                String pageContent;
                String pageName;
                SearchResult comparison;
                WikiPage page = it.next();
                if (page == null) continue;
                PagePermission pp = new PagePermission(page, "view");
                if (wikiContext != null && !mgr.checkPermission(wikiContext.getWikiSession(), pp) || (comparison = matcher.matchPageContent(pageName = page.getName(), pageContent = this.m_engine.getPageManager().getPageText(pageName, -1) + this.attachmentNames(page, " "))) == null) continue;
                res.add(comparison);
            }
            catch (ProviderException pe) {
                log.error((Object)"Unable to retrieve page from cache", (Throwable)pe);
            }
            catch (IOException ioe) {
                log.error((Object)"Failed to search page", (Throwable)ioe);
            }
        }
        return res;
    }

    @Override
    public Collection<SearchResult> findPages(String query, WikiContext wikiContext) {
        return this.findPages(this.parseQuery(query), wikiContext);
    }

    @Override
    public String getProviderInfo() {
        return "BasicSearchProvider";
    }
}

