/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.http.HttpSession;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.pages.PageLock;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.tags.WikiTagBase;

public class CheckLockTag
extends WikiTagBase {
    private static final long serialVersionUID = 1L;
    private LockState m_mode;

    @Override
    public void initTag() {
        super.initTag();
        this.m_mode = LockState.NOTLOCKED;
    }

    public void setMode(String arg) {
        this.m_mode = "locked".equals(arg) ? LockState.LOCKED : ("owned".equals(arg) ? LockState.OWNED : LockState.NOTLOCKED);
    }

    @Override
    public final int doWikiStartTag() throws IOException, ProviderException {
        WikiEngine engine = this.m_wikiContext.getEngine();
        WikiPage page = this.m_wikiContext.getPage();
        if (page != null) {
            PageManager mgr = engine.getPageManager();
            PageLock lock = mgr.getCurrentLock(page);
            HttpSession session = this.pageContext.getSession();
            PageLock userLock = (PageLock)session.getAttribute("lock-" + page.getName());
            if (lock != null && this.m_mode == LockState.LOCKED && lock != userLock || lock != null && this.m_mode == LockState.OWNED && lock == userLock || lock == null && this.m_mode == LockState.NOTLOCKED) {
                String tid = this.getId();
                if (tid != null && lock != null) {
                    this.pageContext.setAttribute(tid, (Object)lock);
                }
                return 1;
            }
        }
        return 0;
    }

    private static enum LockState {
        LOCKED,
        NOTLOCKED,
        OWNED;

    }
}

