/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import org.apache.wiki.WikiSession;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.util.TextUtil;

public class MessagesTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private String m_action = null;
    private String m_prefix = "";
    private String m_topic = null;
    private String m_div = "information";
    private static final String CLEAR = "clear";

    @Override
    public void initTag() {
        super.initTag();
        this.m_topic = null;
        this.m_action = null;
        this.m_prefix = "";
        this.m_div = "information";
    }

    public void setTopic(String topic) {
        this.m_topic = topic;
    }

    public void setPrefix(String prefix) {
        this.m_prefix = prefix;
    }

    public void setDiv(String div) {
        this.m_div = div;
    }

    public void setAction(String action) {
        this.m_action = action.toLowerCase();
    }

    @Override
    public final int doWikiStartTag() throws IOException {
        WikiSession session = this.m_wikiContext.getWikiSession();
        if (CLEAR.equals(this.m_action)) {
            if (this.m_topic == null) {
                session.clearMessages();
            } else {
                session.clearMessages(this.m_topic);
            }
        } else {
            String[] messages;
            String[] stringArray = messages = this.m_topic == null ? session.getMessages() : session.getMessages(this.m_topic);
            if (messages.length > 0) {
                StringBuilder sb = new StringBuilder();
                if (messages.length == 1) {
                    sb.append("<div class=\"" + this.m_div + "\">" + this.m_prefix + TextUtil.replaceEntities((String)messages[0]) + "</div>");
                } else {
                    sb.append("<div class=\"" + this.m_div + "\">" + this.m_prefix);
                    sb.append("<ul>");
                    for (int i = 0; i < messages.length; ++i) {
                        sb.append("<li>" + TextUtil.replaceEntities((String)messages[i]) + "</li>");
                    }
                    sb.append("</ul></div>");
                }
                this.pageContext.getOut().println(sb.toString());
            }
        }
        return 0;
    }
}

